<div>
    {!! Form::open(['class' => 'form-inline', 'method' => 'GET', 'id' => 'formOPS']) !!}

    @if (env(MULTIPLE_AIRLINE) && ghaModule() && isset($enableAirline) && $enableAirline)
        <div class="form-group marginBottomRight">
            <label>@lang("content.airline")</label>

            <div class="btn-group">
                {!! Form::select('airline', $airlines, \request("airline"), [ 'required', 'class'=>'multiselect_search', 'id'=>'airline']) !!}
            </div>
        </div>
    @endif

    @if (isset($enableAirport) && $enableAirport)
        <div class="form-group marginBottomRight">
            <label>@lang("content.airport")</label>

            <div class="btn-group">
                {!! Form::select('airport', $airports, \request("airport"), ['class'=>'multiselect_search', 'id'=>'airport']) !!}
            </div>
        </div>

        <div class="form-group marginBottomRight">
            <label>@lang("content.type")</label>

            <div class="btn-group">
                {!! Form::select('type', [ALL => ALL, DEPARTURE => DEPARTURE, ARRIVAL => ARRIVAL,], \request("type"), [ 'class'=>'multiselect', 'id'=> 'type' ]) !!}
            </div>
        </div>
    @endif

    <div class="form-group marginBottomRight">
        {!! Form::hidden('activeTab', 'Analysis') !!}
        <label>{!! Form::radio('flightSearch','flightNumber', !\request("flightSearch") || \request("flightSearch") == 'flightNumber') !!}
            @lang("content.flight_number")</label>

        <div class="btn-group">
            @if (is_array($flightNumbers))
                {!! Form::select('flightNumber[]', $flightNumbers, \request("flightNumber"), ['multiple'=>'multiple', 'class'=>'multiselect_search', 'id' => 'flight_number']) !!}
            @else
                <select name="flightNumber[]" class="multiselect_search" id="flight_number" multiple>
                    @foreach($flightNumbers as $each)
                        <option value="{{ $each->id }}" {!! \request("flightNumber") && in_array($each->id, \request("flightNumber")) ? "selected" : "" !!}>{{ $each->sector }}</option>
                    @endforeach
                </select>
            @endif
        </div>
    </div>

    <div class="form-group marginBottomRight">
        <label>{!! Form::radio('flightSearch','sector', \request("flightSearch") == 'sector') !!} @lang("content.sector")</label>

        <div class="btn-group">
            {!! Form::select('sector[]', $sectors, \request("sector"), ['multiple'=>'multiple', 'class'=>'multiselect_search', 'id' => 'sector']) !!}
        </div>
    </div>



    @if (isset($enablePeriod) && $enablePeriod)
        <div class="form-group marginBottomRight">
            <label>{!! Form::radio('dateSearch','fromTo', !\request("dateSearch") || \request("dateSearch") == 'fromTo') !!}
                @lang("content.from")</label>
            {!! Form::text('dateFrom', !\request("dateSearch") ? $dateYesterday : \request("dateFrom"), ['class'=>'form-control dateFrom myinput', 'placeholder'=>'From Date', 'id'=>'from_date']) !!}
            <label form="dateTo">@lang("content.to")</label>
            {!! Form::text('dateTo', !\request("dateSearch") ? $dateYesterday : \request("dateTo"), ['class'=>'form-control dateTo myinput', 'placeholder' => 'To Date', 'id'=>'to_date']) !!}
        </div>

        <div class="form-group marginBottomRight">
            <label>{!! Form::radio('dateSearch','monthYear', \request("dateSearch") == 'monthYear') !!} @lang("content.month")</label>

            <div class="btn-group">
                {!! Form::select('month[]', $monthNames, \request("month"), ['multiple'=>'multiple', 'class'=>'multiselect_search', 'id'=>'month']) !!}
            </div>
        </div>

        <div class="form-group marginBottomRight">
            <label for="year" class="control-label">@lang("content.year")</label>

            <div class="btn-group">
                {!! Form::select('year', $years, getSelectedYear(), ['class'=>'singleselect']) !!}
            </div>
        </div>
        <div class="form-group marginBottomRight">
            <label for="period" class="control-label">@lang("content.period")</label>

            <div class="btn-group">
                {!! Form::select('period', $periods, \request("period"), ['class'=>'multiselect_search', 'id'=>'period']) !!}
            </div>
        </div>
    @endif

    <div class="form-group marginBottomRight">
        <label for="period" class="control-label">ULD @lang("content.type")</label>
        {!! Form::select('uldType[]', $uldTypes, \request("uldType"), ['multiple'=>'multiple', 'class'=>'multiselect_search', 'id' => 'uldType']) !!}
    </div>

    <div class="form-group marginBottomRight">
        <label>@lang("content.datetime")</label>
        {!! Form::text('datetime', \request("datetime") ? \request("datetime") : date("Y-m-d H:i:s"), ['class'=>'form-control datetimepicker']) !!}
    </div>

    <div class="form-group marginBottomRight">
        <button type="submit" class="btn btn-primary">@lang("content.submit")</button>
    </div>


    {!! Form::close() !!}
</div>