<?php require_once(public_path("smart/inc/init.php")); ?>
        <!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-sm-12 col-md-12 col-lg-12">
            @include('uld-report.layouts.index-form', ['enableAirline' => true, 'enableAirport' => true])
        </article>

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            <ul id="tabStations" class="nav nav-tabs bordered">
                <li class="active">
                    <a href="#list" role="tab" data-toggle="tab">ULD @lang("content.movements") {{ \request("date") ? "(". baseDateFormat(\request("date")) .")" : "" }}</a>
                </li>
                <li class="">
                    <a href="#stockType" role="tab" data-toggle="tab">ULD @lang("content.stock_by_type")</a>
                </li>
                <li class="">
                    <a href="#stock" role="tab" data-toggle="tab">ULD @lang("content.stock_by_id")</a>
                </li>
                <li class="">
                    <a href="#searchULD" role="tab" data-toggle="tab">ULD @lang("content.search")</a>
                </li>
            </ul>

            @php $active = 0 @endphp
            <div id="tabContent" class="tab-content padding-10 background-white">
                <div class="tab-pane active" id="list">
                    @include('uld-report.layouts.index-table')
                </div>
                <div class="tab-pane" id="stockType">
                    @include('uld-report.layouts.index-stock-type')
                </div>
                <div class="tab-pane" id="stock">
                    @include('uld-report.layouts.index-stock')
                </div>
                <div class="tab-pane" id="searchULD">
                    @include('uld-report.layouts.index-search-form', ['enableAirline' => true])
                </div>
            </div>
        </article>

    </div>

</section>

<script type="text/javascript">

    pageSetUp();

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyValidationDateFormats();

        Apply_Multiselect();

        @if (ghaModule())
            ApplyOperationsFormFilter({!! json_encode($flightNumbers) !!}, {!! json_encode(\request("flightNumber")) !!}, {!! json_encode($sectors) !!}, {!! json_encode($sectorsByAirlines) !!}, {!! json_encode(\request("sector")) !!});
        @endif

        ApplyTableFilter("#uld-table");

        ApplyTableFilter("#stock-type-table");

        ApplyTableFilter("#stock-table");
    };

    pagefunction();

</script>
