@php $container_class = isset($container_class) ? $container_class : "" @endphp
@php $sub_container_first = isset($sub_container_first) ? $sub_container_first : "" @endphp
@php $sub_container_second = isset($sub_container_second) ? $sub_container_second : "" @endphp

@foreach($list as $j => $each)
    @php $label = isset($each['label']) ? $each['label'] : $j @endphp

    @if (isset($each['required']))
        @php $properties['required'] = 'required' @endphp
    @endif
    <div class="{{ $container_class }} list-header added">
        <div class="{{ $sub_container_first }} list">{{ ucwords($label) }}</div>
        <div class="{{ $sub_container_second }}">
            @if ($each['multiple'])
                @php $class = (isset($each['search']) && $each['search'] === true ? 'multiselect_search' : 'multiselect') @endphp
                @php $properties = ['class' => "form-control $class"] @endphp
                @php $properties['multiple'] = 'multiple' @endphp
                {!! Form::select($j."[]", $each['data'], null, $properties) !!}
            @else
                @php $class = (isset($each['search']) && $each['search'] === true ? 'singleselect_search' : 'singleselect') @endphp
                @php $properties = ['class' => "form-control $class"] @endphp
                {!! Form::select($j, ['' => 'Select'] + $each['data'], null, $properties) !!}
            @endif
        </div>
    </div>
@endforeach