@foreach ($fdpPlannedFlights as $i => $fdp)
    @php $fdpClass = $i % 2 == 0 ? "fdp-alter" : "" @endphp
    @foreach($fdp->getFlights() as $flight)
        @php $class = $flight->is_standby ? '<span class="label label-danger">Standby</span>' : ($flight->is_dhc ? '<span class="label label-success">DHC</span>' : '') @endphp
        <tr>
            <td class="{{ $fdpClass }}">{{ ++$i}}</td>
            <td class="{{ $fdpClass }}">{!! $class !!}</td>
            <td class="{{ $fdpClass }}"><a href="{{ url("/flightquery/index?aircraft={$flight->aircraft_id}&period=period&period_field=last_28_days") }}">{{ $flight->aircraft_name }}</a></td>
            <td class="{{ $fdpClass }}" nowrap><a href="{{ url("/flight/details?id={$flight->id}") }}">{{ $CURRENT_IATA_CODE.'-'.$flight->flight_number }}</a></td>
            <td class="{{ $fdpClass }}" nowrap>{{ $flight->departure_airport . "-" . $flight->arrival_airport }}</td>
            <td class="{{ $fdpClass }}">{{ $flight->id == $fdp->getFirstFlight()->id ? dmy_format($fdp->getReportTime(), 'time') : "" }}</td>
            @if ($flight->atd && $flight->atd != EMPTY_DATETIME && $flight->ata && $flight->ata != EMPTY_DATETIME)

                <td class="{{ $fdpClass }}"><span class="label label-primary small-info">ATD</span>{{ dmy_format($flight->atd, 'time') }}</td>
                <td class="{{ $fdpClass }}"><span class="label label-danger small-info">ATA</span>{{ dmy_format($flight->ata, 'time') }}</td>
            @else
                <td class="{{ $fdpClass }}"><span class="label label-warning small-info">STD</span>{{ dmy_format($flight->std, 'time') }}</td>
                <td class="{{ $fdpClass }}"><span class="label label-warning small-info">STA</span>{{ dmy_format($flight->sta, 'time') }}</td>
            @endif
            <td class="{{ $fdpClass }}">{{ $flight->id == $fdp->getLastFlight()->id ? dmy_format($fdp->getReleaseTime(), 'time') : "" }}</td>
            <td class="{{ $fdpClass }}">{{ $flight->other_time == 0 ? "-" : hoursToTime($flight->other_time, true) }}</td>
            <td class="{{ $fdpClass }}">{{ $flight->flight_time == 0 ? "-" : hoursToTime($flight->flight_time, true) }}</td>
            <td class="{{ $fdpClass }}">{{ $flight->flying_time == 0 ? "-" : hoursToTime($flight->flying_time, true) }}</td>
            <td class="{{ $fdpClass }}"></td>
        </tr>
    @endforeach
    @php $limitCrossed = $fdp->getCurrentFdpTime() > $fdp->getMaxFdpTime() ? "fdp-crossed" : "color-green" @endphp
    @php $limitCrossed = "color-green" @endphp
    <tr>
        <td class="{{ $fdpClass }} font-strong color-green" colspan="9">FDP @lang("content.total")</td>
        <td class="{{ $fdpClass }} font-strong color-green">{{ hoursToTime($fdp->getOtherTime(), true) }}</td>
        <td class="{{ $fdpClass }} font-strong color-green">{{ hoursToTime($fdp->getFlightTime(), true) }}</td>
        <td class="{{ $fdpClass }} font-strong color-green">{{ hoursToTime($fdp->getFlyingTime(), true) }}</td>
        <td class="{{ $fdpClass." ".$limitCrossed }} font-strong">{{ hoursToTime($fdp->getCurrentFdpTime(), true) }}</td>
        {{--<td class="{{ $fdpClass }} font-strong color-green">{{ hoursToTime($fdp->getMaxFdpTime(), true) }}</td>--}}
    </tr>
@endforeach
