<?php
/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov
 * Date: 28.08.14

 */
?>

<?php require_once(public_path("smart/inc/init.php")); ?>

        <!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            @include('general.tab-header', ['departmentName' => 'Admin', 'moduleName' => ucfirst(trans("subdepartments"))." | ".$department->name])

            <div>
            {{--Message block--}}
                @if (Session::get("message"))
                    @php $message = Session::get("message"); @endphp
                    <p class="alert alert-{!! $message["type"] !!}">{!! $message["text"] !!}</p>
                @endif

                @if (!count($subDepartments))
                <p class="alert alert-info">Not found any subdivisions</p>
                @else
                <table class="table table-bordered table-striped table-hover">
                    <thead>
                    <tr>
                        <th>No</th>
                        <th>@lang("content.name")</th>
                        <th>@lang("content.last_updated")</th>
                        <th>@lang("content.actions")</th>
                    </tr>
                    </thead>
                    <tbody>
                    @foreach ($subDepartments as $subDepartment)
                    <tr>
                        <td>{!! $subDepartment->id !!}</td>
                        <td data-left>{!! $subDepartment->name !!}</td>
                        <td>{!! $subDepartment->updated_at !!}</td>
                        <td>
                            <div class="btn-group">
                                <a href="{!! route("homepage")."#". url('subdepartment/edit') !!}?id={!! $subDepartment->id !!}" class="btn btn-primary btn-sm">@lang("content.edit")</a>
                                <a href="{!! route("homepage")."#". url('position/index') !!}?subdepartment_id={!! $subDepartment->id !!}" class="btn btn-info btn-sm">Positions</a>
                                <a href="{!! route("homepage")."#". url('subdepartment/delete') !!}?id={!! $subDepartment->id !!}" data-confirm-text="Are you sure you want to remove this subdivision?" class="btn btn-danger confirm btn-sm">@lang("content.remove")</a>
                            </div>
                        </td>
                    </tr>
                    @endforeach
                    </tbody>
                </table>
                @endif
            </div>

            <a href="{!! route("homepage")."#". url('subdepartment/add') !!}?department_id={!! $department->id !!}" class="btn btn-primary">Add Subdivision</a>
            <a href="{!! route("homepage")."#". url("department") !!}" class="btn btn-default">Back</a>


        </article>

    </div>

</section>


<script type="text/javascript">

    pageSetUp();

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyValidationDateFormats();

        Apply_Multiselect();

        ApplyTableFilter("#table");

    };

    pagefunction();

</script>
