<?php require_once(public_path("smart/inc/init.php")); ?>

@include('general.tab-header', ['departmentName' => 'Standby', 'moduleName' => 'Edit Standby Crew'])

<div class="row">
    <div class="col-sm-6">
        {!! Form::open(['method' => 'POST', 'class' => 'form-horizontal', 'url' => URL::full(), 'id' => 'formEdit']) !!}
            <div class="form-group">
                <label class="control-label col-sm-3">{!! $crewType !!}</label>
                <div class="col-sm-4">
                    {!! Form::select('user_id', $crewList, $crew, ['class'=>'form-control', 'id'=>'captain_id']) !!}
                </div>
            </div>
            <div class="form-group">
                <label class="control-label col-sm-3">Date From</label>
                <div class="col-sm-4">
                    {!! Form::text('start_date', date('Y-m-d H:i', strtotime($start_date)), ['class'=>'form-control dateTimeFrom', 'required'=>'required']) !!}
                </div>
            </div>
            <div class="form-group">
                <label class="control-label col-sm-3">Date To</label>
                <div class="col-sm-4">
                    {!! Form::text('end_date', date('Y-m-d H:i', strtotime($end_date)), ['class'=>'form-control dateTimeTo', 'required'=>'required']) !!}
                </div>
            </div>
            <div class="form-group">
                <label class="control-label col-sm-3">@lang("content.location")</label>
                <div class="col-sm-4">
                    {!! Form::select('airport_id', $airports, $airport, ['class'=>'form-control', 'id'=>'location', 'required'=>'required']) !!}
                </div>
            </div>
            <hr/>
            <div class="form-group">
                <div class="col-sm-offset-3 col-sm-9">
                    <button type="submit" class="btn btn-primary">Save Changes</button>
                    <a href="{{ route("homepage")."#standby" }}" class="btn btn-default">Back</a>
                </div>
            </div>
        {!! Form::close() !!}
    </div>
</div>

<script type="text/javascript">

    pageSetUp();

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyDateFormats();

        Apply_Multiselect();

        ApplyTableFilter("#table");
    };

    pagefunction();

</script>