<?php require_once(public_path("smart/inc/init.php")); ?>

        <!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            <div class="col-md-12 no-padding margin-bottom-10">
                <a href="{{ route("homepage")."#". url("staff/create?s=".rand(100, 999)) }}" class="btn btn-primary">@lang("content.add_new_staff")</a>
                <a href="{{ route("homepage")."#". url("staff-upload") }}" class="btn btn-success mr-5">@lang("content.upload_staff")</a>
            </div>

            <div class="clearfix"></div>

            <ul class="nav nav-tabs bordered">
                <li class="">
                    <a href="{{ route("homepage")."#staff" }}">@lang("content.all_current_staff")</a>
                </li>
                <li class="">
                    <a href="{{ route("homepage")."#staff/by-station" }}">@lang("content.by_station")</a>
                </li>
                <li class="active">
                    <a href="#terminated-staff-list" role="tab" data-toggle="tab">@lang("content.terminated_staff")</a>
                </li>
                <li class="">
                    <a href="#deleted-staff-list" role="tab" data-toggle="tab">@lang("content.deleted_staff")</a>
                </li>
            </ul>

            <div class="tab-content padding-10 background-white">
                <div class="tab-pane active" id="terminated-staff-list">
                    @include("staff.layouts.staff-list-stations", ['id' => 'terminated', "terminated" => true, "staffList" => $terminatedStaffList])
                </div>
                <div class="tab-pane" id="deleted-staff-list">
                    @include("staff.layouts.staff-list-stations", ['id' => 'deleted', "deleted" => true, "staffList" => $deletedStaffList])
                </div>
            </div>

        </article>

    </div>

</section>

<script type="text/javascript">

    pageSetUp();

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyDateFormats();

        Apply_Multiselect();

        @foreach($airports as $i => $airport)
           ApplyTableFilter("#staff-table-terminated-{{ $i }}");
           ApplyTableFilter("#staff-table-deleted-{{ $i }}");

        @endforeach
    }

    pagefunction();

</script>