<?php require_once(public_path("smart/inc/init.php")); ?>

        <!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
            @php $base = $user->location && $user->location->airport ? $user->location->airport->iata : "Base N/A" @endphp
            @include('general.tab-header', ['departmentName' => 'Staff', 'moduleName' => $base . " | " . $user->first_name." ".$user->last_name])

            <div class="col-md-12">

                {{--Tabs--}}
                <ul class="nav nav-tabs" id="myTab">

                    <li class="{{ !\request("tab") ? "active" : "" }}">
                        <a href="#general" data-toggle="tab">
                            <span class="tabText">@lang("content.general")</span>
                        </a>
                    </li>

                    <li class="{{ \request("tab") == "notifications" ? "active" : "" }}">
                        <a href="#notifications" data-toggle="tab">
                            <span class="tabText">@lang("content.read_and_sign")</span>
                        </a>
                    </li>

                    @if (ghaModule())
                        <li class="{{ \request("tab") == "services" ? "active" : "" }}">
                            <a href="#services" data-toggle="tab">
                                <span class="tabText">@lang("content.services")</span>
                            </a>
                        </li>
                    @endif

                    <li class="">
                        <a href="#licenses" data-toggle="tab">
                            <span class="tabText">@lang("content.licenses_approvals")</span>
                        </a>
                    </li>

                    <li class="{{ \request("tab") == "hours" ? "active" : "" }}">
                        <a href="#hours" data-toggle="tab">
                            <span class="tabText">@lang("content.roster") / @lang("content.hours")</span>
                        </a>
                    </li>

                    {{--Office Duties/Training--}}
{{--                    <li>--}}
{{--                        <a href="#leaves" data-toggle="tab" title="welcome">--}}
{{--                            <span class="tabText">@lang("content.office_duties") / @lang("content.training")</span>--}}
{{--                        </a>--}}
{{--                    </li>--}}

                    <li class="">
                        <a href="#requests" data-toggle="tab" title="welcome">
                            <span class="tabText">@lang("content.my_requests")</span>
                        </a>
                    </li>

                    <li class="{{ \request("tab") == "leave_request" ? "active" : "" }}">
                        <a href="#leave_request" data-toggle="tab" title="welcome">
                            <span class="tabText">@lang("content.leave_requests")</span>
                        </a>
                    </li>

                    {{--<li>--}}
                        {{--<a href="#duty_travel_request" data-toggle="tab" title="welcome" class="not-active">--}}
                            {{--<i class="glyphicon glyphicon-tasks"></i>--}}
                            {{--<span class="tabText">Duty Travel Request</span>--}}
                        {{--</a>--}}
                    {{--</li>--}}

                    @if ($hasEmployees)
                        <li class="{{ \request("tab") == "employees_requests" ? "active" : "" }}">
                            <a href="#employees_requests" data-toggle="tab" title="welcome">
                                <span class="tabText">@lang("content.employees_requests")</span>
                            </a>
                        </li>
                    @endif

                    <li class="{{ \request("tab") == "leave_entitlements" ? "active" : "" }}">
                        <a href="#leave_entitlements" data-toggle="tab" title="welcome">
                            <span class="tabText">@lang("content.leave_entitlements")</span>
                        </a>
                    </li>
                </ul>

                {{--Tab Content--}}
                <div class="tab-content">

                    {{--General Tab--}}
                    <div class="tab-pane bg-color-white {{ !\request("tab") ? "active" : "" }}" id="general" style="padding: 15px !important; width: 100%; overflow: auto; ">

                        <div class="col-md-3 col-sm-5">
                            <!-- Current avatar -->
                            @include('forms/general/upload-picture', ['postUrl' => url("user/upload/{$userId}")])

                        </div>

                        <div class="col-md-9 col-sm-7">
                            <ul class="nav nav-pills" id="generalSubItems">
                                <li class="active">
                                    <a href="#general-tab-info" data-toggle="tab">@lang("content.info")</a>
                                </li>
                                <li class="">
                                    <a href="#general-tab-details" data-toggle="tab">@lang("content.details")</a>
                                </li>

                            </ul>

                            <div class="tab-content" style="background: #e3e3e3; margin-top: 10px;">
                                {{--General Tab--}}
                                <div class="tab-pane active bg-color-white editable_div" id="general-tab-info" style="">

                                    @include('staff.show-layouts.general-info-tab')

                                </div>

                                <div class="tab-pane bg-color-white editable_div" id="general-tab-details" style="">

                                    @include('staff.show-layouts.general-details-tab')

                                </div>

                            </div>
                        </div>
                    </div>

                    <div class="tab-pane bg-color-white {{ \request("tab") == "notifications" ? "active" : "" }}" id="notifications" style="padding: 15px !important; width: 100%; overflow: auto;">
                        @include("user-notifications.layouts.index-list")
                    </div>

                    <div class="tab-pane bg-color-white {{ \request("tab") == "services" ? "active" : "" }}" id="services" style="padding: 15px !important; width: 100%; overflow: auto;">
                        @include("staff.show-layouts.services-tab")
                    </div>

                    <div class="tab-pane bg-color-white" id="licenses" style="padding: 15px !important; width: 100%; ">
                        @include("staff.show-layouts.licenses-tab")
                    </div>

{{--                    <div class="tab-pane bg-color-white {{ \request("tab") == "roster" ? "active" : "" }}" id="roster" style="padding: 15px !important; width: 100%; ">--}}
{{--                        @include("staff.show-layouts.roster-tab")--}}
{{--                    </div>--}}

{{--                    <div class="tab-pane bg-color-white {{ \request("tab") == "hours" ? "active" : "" }}" id="hours" style="padding: 15px !important; width: 100%; ">--}}
{{--                        @include("staff.show-layouts.hours-tab")--}}
{{--                    </div>--}}

{{--                    Roster / Hours--}}
                    <div class="tab-pane bg-color-white {{ \request("tab") == "hours" ? "active" : "" }}" id="hours" style="padding: 15px !important; width: 100%; ">
                        @include("staff.layouts.edit-hours-tab")
                    </div>

                    {{--Office Duties-/Trining--}}
{{--                    <div class="tab-pane bg-color-white" id="leaves" style="padding: 15px !important; width: 100%; overflow: auto;">--}}
{{--                        @include('user.show-leaves-tab')--}}
{{--                    </div>--}}

                    <div class="tab-pane bg-color-white" id="requests" style="padding: 15px !important; width: 100%; overflow: auto;">
                        @include('user.show-my-requests-tab')
                    </div>

                    <div class="tab-pane bg-color-white {{ \request("tab") == "leave_request" ? "active" : "" }}" id="leave_request" style="padding: 15px !important; width: 100%; overflow: auto;">
                        @include('user.request-leave-tab')
                    </div>

                    <div class="tab-pane bg-color-white" id="duty_travel_request" style="padding: 15px !important; width: 100%; overflow: auto;">
                        @include('user.show-duty-travel-request-tab')
                    </div>

                    @if ($hasEmployees)
                        <div class="tab-pane bg-color-white {{ \request("tab") == "employees_requests" ? "active" : "" }}" id="employees_requests" style="padding: 15px !important; width: 100%; overflow: auto;">
                            @include('user.show-employees-requests-tab')
                        </div>
                    @endif

                    <div class="tab-pane bg-color-white {{ \request("tab") == "leave_entitlements" ? "active" : "" }}" id="leave_entitlements" style="padding: 15px !important; width: 100%; overflow: auto;">
                        @include('user.show-leave-entitlements')
                    </div>
                </div>
            </div>
        </article>
    </div>
</section>

<script type="text/javascript">

    pageSetUp();

    var EDIT = "Edit", SAVE = "Save";

    ApplyMultipleFormSubmit();

    Initialize_DateRangePicker();

    $(document).on('click', 'form button.edit', function () {
        var _this = $(this), form = _this.closest("form"), state = form.attr("data-state"), labels = form.find("label.checkbox"),
                tr = form.find("tr"), inputs = form.find("input[type=checkbox]"),
                cancelBtn = form.find("button.cancel"), saveBtn = form.find("input.save");

        switch (state) {
            case EDIT:
                form.attr("data-state", SAVE);
                labels.removeClass("state-disabled");
                inputs.removeAttr("disabled");
                tr.addClass("selected-row");

                _this.hide();
                cancelBtn.show();
                saveBtn.show();
                return false;

            case SAVE:
                return true;
        }

    }).on("click", "form button.cancel", function () {

        var _this = $(this), form = _this.closest("form"), state = form.data("state"), labels = form.find("label.checkbox"),
                tr = form.find("tr"), inputs = form.find("input[type=checkbox]"), saveBtn = form.find("input.save"),
                editBtn = form.find("button.edit");

        form.attr("data-state", EDIT);
        labels.addClass("state-disabled");
        inputs.attr("disabled", "disabled");
        tr.removeClass("selected-row");

        editBtn.show();
        _this.hide();
        saveBtn.hide();

    });


    $(document).on('click', 'form button.edit_all', function () {
        var _this = $(this), form = _this.closest("form"), state = form.attr("data-state"), labels = form.find("label.checkbox"),
                tr = form.find("tr").not("[data-category=1]"), inputs = form.find("input[type=checkbox]"),
                cancelBtn = form.find("button.cancel_all"), saveBtn = form.find("input.save_all"),
                selectAllBtn = form.find("button.select_all"),deselectAllBtn = form.find("button.deselect_all");

        switch (state) {
            case EDIT:
                form.attr("data-state", SAVE);
                labels.removeClass("state-disabled");
                inputs.removeAttr("disabled");
                tr.addClass("selected-row");

                _this.hide();
                cancelBtn.show();
                saveBtn.show();
                selectAllBtn.show();
                deselectAllBtn.show();
                return false;

            case SAVE:
                return true;
        }
    })
        .on("click", "form button.cancel_all", function () {

        var _this = $(this), form = _this.closest("form"), state = form.data("state"), labels = form.find("label.checkbox"),
                tr = form.find("tr").not("[data-category=1]"), inputs = form.find("input[type=checkbox]"), saveBtn = form.find("input.save_all"),
                editBtn = form.find("button.edit_all"),
                selectAllBtn = form.find("button.select_all"),deselectAllBtn = form.find("button.deselect_all");


        form.attr("data-state", EDIT);
        labels.addClass("state-disabled");
        inputs.attr("disabled", "disabled");
        tr.removeClass("selected-row");

        editBtn.show();
        _this.hide();
        saveBtn.hide();
        selectAllBtn.hide();
        deselectAllBtn.hide();

    })
        .on("click", "form button.select_all", function () {

        var _this = $(this), form = _this.closest("form"),
               inputs = form.find("input[type=checkbox]"),
                deselectAllBtn = form.find("button.deselect_all");

        inputs.prop("checked", "checked");

//        deselectAllBtn.show();
//        _this.hide();

    })
        .on("click", "form button.deselect_all", function () {

        var _this = $(this), form = _this.closest("form"),
                inputs = form.find("input[type=checkbox]"),
                selectAllBtn = form.find("button.select_all");

        inputs.removeAttr("checked");

//        selectAllBtn.show();
//        _this.hide();

    })

    $(document).on('click', 'td.status', function () {
        var _this = $(this), parent = _this.parent(), find_details = parent.nextUntil("tr.request").filter('tr.details');

        if (find_details.is(":visible")){
            find_details.hide();
        }
        else {
            find_details.show();
        }
    });

    $(document).on('click', 'button.hide-modify-form', function () {
        var _this = $(this), modify_form = _this.parents('div.modify_form');
        modify_form.hide();
    });

    $(document).on('click', 'button.modify', function () {
        var _this = $(this), parent = _this.parents('tr.request'), date_from = parent.find('td.date_from'),
                date_to = parent.find('td.date_to'),
                modify_form = $(document).find('div.modify_form'),
                periodInput = modify_form.find('input.daterangepicker-from-now'),
                leaveId = parent.attr('data-leave-id'),
                start = moment(date_from.text(), "DD MMM YY").toDate(),
                end = moment(date_to.text(), "DD MMM YY").toDate(),
                leaveIdInput = modify_form.find('select[name=leave_id]').val(leaveId),
                leaveRequestId = parent.attr('data-request-id'),
                leaveRequestIdInput = modify_form.find('input[type=hidden][name=leave_request_id]');

        if (modify_form.is(":visible")){
            if (leaveRequestIdInput.val() == leaveRequestId){
                modify_form.hide();

            }
            else {
                leaveRequestIdInput.val(leaveRequestId);
                leaveIdInput.multiselect('rebuild');
                periodInput.daterangepicker("setRange", {start: start, end: end});
            }
        }
        else {
            leaveIdInput.multiselect('rebuild');
            leaveRequestIdInput.val(leaveRequestId);
            periodInput.daterangepicker("setRange", {start: start, end: end});
            modify_form.show();
        }
    });

    var btnUpload = $(document).find("input[name=upload]"),
            btnDelete = $(document).find("input[name=delete]");

    $(document).on('click', 'a.edit-update', function () {
        $(this).parents("tr").find(".upload-container").toggle(400, function () {
            $(this).val(($(this).is(":visible")) ? "1" : "0");
        });
    });

    var pagefunction = function () {

        btnUpload.each(function () {
            ApplySubmitEvent($(this));
        });

        btnDelete.each(function () {
            ApplySubmitEvent($(this));
        });

//        ApplyMultipleFormSubmit();

        ApplyDateFormats();

        Apply_Multiselect();

        ApplyTableFilter("#notificationsTable");
        ApplyTableFilter("#rosterTable");
        ApplyTableFilter("#officeDutiesTable");
        ApplyTableFilter("#totalHoursTable");
        ApplyTableFilter("#dailyHoursTable");
        ApplyTableFilter("#monthlyHoursTable");
        ApplyTableFilter("#yearlyHoursTable");
        ApplyTableFilter("#entitlementTable");
        ApplyTableFilter("#showEntitlementTable");
    };


    loadScript("{{ asset("/assets/js/views/user/edit.js?7") }}", pagefunction);

</script>
