<div class="col-md-12 margin-bottom-10">
    <form class="form-inline" method="get" action="{{ URL::full() }}">
        <label>@lang("content.period") </label>
        <div class="btn-group">
            {!! Form::select("period", $periods, \request("period"), ["class"=>"form-control marginRight"]) !!}

        </div>
        {!! Form::label('from', trans("content.from")) !!}
        {!! Form::text('from', \request("from") ? \request("from") : date("Y-m-d"), ['class' => 'form-control dateFrom inputDateSmall']) !!}
        {!! Form::label('to', trans("content.to")) !!}
        {!! Form::text('to', \request("to") ? \request("to") : date("Y-m-d"), ['class' => 'form-control dateTo inputDateSmall']) !!}
        {!! Form::submit("Submit", ["class" => "btn btn-primary btn-sm"]) !!}
        {!! Form::hidden("id", \request("id")) !!}
        {!! Form::hidden("tab", "roster") !!}
    </form>
</div>

<div class="clearfix"></div>

@if (!count($staffFlights))

    <div class="alert alert-info"  style="margin-top: 10px">
        <p>@lang("content.found") 0 @lang("content.records")</p>
    </div>

@else

    <div class="jarviswidget jarviswidget-color-blueDark" id="wid-roster-tab" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

        <header>
            <span class="widget-icon"> <i class="fa fa-table"></i> </span>
            <h2>@lang("content.roster")</h2>
        </header>

        <!-- widget div-->
        <div>

            <!-- widget edit box -->
            <div class="jarviswidget-editbox">
                <!-- This area used as dropdown edit box -->

            </div>
            <!-- end widget edit box -->

            <!-- widget content -->
            <div class="widget-body no-padding" style="min-height: 50px !important;">

                <div class="table-responsive">

                    <table class="table table-bordered table-hover roster" id="roster-table">
                        <thead>
                        <tr>
                            <th>No</th>
                            <th>@lang("content.flight_number")</th>
                            <th>@lang("content.sector")</th>
                            <th>@lang("content.service_type")</th>
                            <th>@lang("content.date_time")</th>
                            <th>@lang("content.service")</th>
                            <th>@lang("content.start_date_time")</th>
                            <th>@lang("content.release_date_time")</th>
                            <th>@lang("content.duration") (@lang("content.hours"))</th>
                        </tr>

                        </thead>
                        <tbody>
                        @foreach($staffFlights as $i => $each)

                            <tr>
                                <td data-center>{{ $i + 1 }}</td>
                                <td><strong><a target="_blank" href="{{ url("flight-tracker/{$each->flight->id}") }}">{{ $each->flightInfo }}</a></strong></td>
                                <td>{{ /* @var App\Classes\Staff\Flight\StaffFlight $each */  $each->route }}</td>
                                <td>{!! displayServiceWithLabel($each->serviceType) !!}</td>
                                @if ($each->serviceType == DEPARTURE_SERVICE)
                                    <td>{{ /* @var App\Classes\Staff\Flight\StaffFlight $each */ baseDateFormat($each->departure, true, "-") }}</td>
                                @else
                                    <td>{{ /* @var App\Classes\Staff\Flight\StaffFlight $each */ baseDateFormat($each->arrival, true, "-") }}</td>
                                @endif
                                <td><span class='label label-warning font-sm'>{{ $each->service->abbr }}</span></td>
                                <td>{!! ($each->pReportTime ? baseDateFormat($each->pReportTime, true, "-")." <span class='label label-success'>PLN</span>" : "-")."<br/>".($each->reportTime ? baseDateFormat($each->reportTime, true, "-")." <span class='label label-primary'>ACT</span>" : "-") !!}</td>
                                <td>{!! ($each->pReleaseTime ? baseDateFormat($each->pReleaseTime, true, "-")." <span class='label label-success'>PLN</span>" : "-")."<br/>".($each->releaseTime ? baseDateFormat($each->releaseTime, true, "-")." <span class='label label-primary'>ACT</span>" : "-") !!}</td>
                                <td>{!! ($each->pDurationTime && $each->pDurationTime != EMPTY_TIME_HM ? $each->pDurationTime." <span class='label label-success'>PLN</span>" : "-")."<br/>".($each->durationTime && $each->durationTime != EMPTY_TIME_HM ? $each->durationTime." <span class='label label-primary'>ACT</span>" : "-") !!}</td>
                            </tr>

                        @endforeach

                        </tbody>

                    </table>

                </div>

            </div>

        </div>

    </div>

@endif
