<div class="clearfix"></div>

@if (!count($staffLicenses))
    <div class="alert alert-info" role="alert">
        <a href="#" class="alert-link">Info<br/></a>
        There are no licenses attached.
    </div>
@else
    <div class="jarviswidget jarviswidget-color-blueDark" id="wid-license-tab" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

    <header>
        <span class="widget-icon"> <i class="fa fa-table"></i> </span>
        <h2>@lang("content.list")</h2>
    </header>

    <!-- widget div-->
    <div>

        <!-- widget edit box -->
        <div class="jarviswidget-editbox">
            <!-- This area used as dropdown edit box -->

        </div>
        <!-- end widget edit box -->

        <!-- widget content -->
        <div class="widget-body no-padding" style="min-height: 50px !important;">

            <div class="table-responsive editable_div">

                <table class="table table-bordered table-hover" id="licenses-table">
                    <thead>
                    <tr>
                        <th>No</th>
                        <th>@lang("content.license_approval")</th>
                        <th>@lang("content.abbr")</th>
                        <th>@lang("content.doi")</th>
                        <th>@lang("content.dex")</th>
                        <th>@lang("content.status")</th>
                        <th style="width: 250px;">@lang("content.actions")</th>
                    </tr>

                    </thead>
                    <tbody>
                    @foreach($staffLicenses as $i => $each)
                        @php $licenseExists = $each->attachment_file ? true : false @endphp
                        <tr>
                            <td data-center>{{ $i + 1 }}</td>
                            @if ($each->license)
                                <td>{{ $each->license->name }}</td>
                                <td><strong>{{ $each->license->abbr }}</strong></td>
                            @else
                                <td></td>
                                <td></td>
                            @endif

                            <td>{{ $each->issue_date ? date('d-M-Y', strtotime($each->issue_date))  : '' }}</td>
                            <td>{{ $each->expiry_date ? date('d-M-Y', strtotime($each->expiry_date))  : '' }}</td>

                            <td>{!! Expiration_Date($each->expiry_date)['status'] !!}</td>

                            <td>
                                <div class="btn-group">
                                    <a target="_blank" {{$licenseExists ? '' : 'disabled' }} href="{{ url("staff-license/{$each->id}") }}?view=1" class="btn btn-warning">View</a>
                                    <a {{$licenseExists ? '' : 'disabled' }} href="{{ url("staff-license/{$each->id}") }}?download=1" class="btn btn-primary">Download</a>
                                </div>
                            </td>
                        </tr>

                    @endforeach

                    </tbody>

                </table>

            </div>

        </div>

    </div>

</div>
@endif