<div class="col-md-12 margin-bottom-10">

    <form class="form-inline" method="get" action="{{ URL::full() }}">

        <label>@lang("content.period") </label>

        <div class="btn-group">
            {!! Form::select("period", $periods, \request("period"), ["class"=>"form-control marginRight"]) !!}
        </div>

        {!! Form::label('from', trans("content.from")) !!}
        {!! Form::text('from', \request("from") ? \request("from") : date("Y-m-d"), ['class' => 'form-control dateFrom inputDateSmall']) !!}
        {!! Form::label('to', trans("content.to")) !!}
        {!! Form::text('to', \request("to") ? \request("to") : date("Y-m-d"), ['class' => 'form-control dateTo inputDateSmall']) !!}
        {!! Form::submit("Submit", ["class" => "btn btn-primary btn-sm"]) !!}
        {!! Form::hidden("id", \request("id")) !!}
        {!! Form::hidden("tab", "hours") !!}

    </form>

</div>

<div class="clearfix"></div>

@if (!count($staffHours['daily']))

    <div class="alert alert-info"  style="margin-top: 10px">
        <p>@lang("content.found") 0 @lang("content.records")</p>
    </div>

@else

    <ul class="nav nav-pills" id="hoursSubItems" style="margin-top: 10px; margin-bottom: 10px;">
        <li class="active">
            <a href="#hours-tab-daily" data-toggle="tab">@lang("content.daily")</a>
        </li>
        <li class="">
            <a href="#hours-tab-monthly" data-toggle="tab">@lang("content.monthly")</a>
        </li>
        <li class="">
            <a href="#hours-tab-yearly" data-toggle="tab">@lang("content.yearly")</a>
        </li>

    </ul>

    <div class="tab-content" style="background: #e3e3e3">
        {{--General Tab--}}
        <div class="tab-pane active bg-color-white editable_div" id="hours-tab-daily" style="">

            @include('staff.show-layouts.hours-tab-period', ['data' => $staffHours['daily']])

        </div>

        <div class="tab-pane bg-color-white editable_div" id="hours-tab-monthly" style="">

            @include('staff.show-layouts.hours-tab-period', ['data' => $staffHours['monthly']])

        </div>

        <div class="tab-pane bg-color-white editable_div" id="hours-tab-yearly" style="">

            @include('staff.show-layouts.hours-tab-period', ['data' => $staffHours['yearly']])

        </div>

    </div>
@endif
