@php $deleted = isset($deleted) && $deleted @endphp
@php $terminated = isset($terminated) && $terminated @endphp
<div class="jarviswidget jarviswidget-color-blueDark" id="wid-staff-{{ $i }}" data-widget-editbutton="false">

    <header>
        <span class="widget-icon"> <i class="fa fa-table"></i> </span>
        <h2>@lang("content.list")</h2>
    </header>

    <!-- widget div-->
    <div>

        <!-- widget edit box -->
        <div class="jarviswidget-editbox">
            <!-- This area used as dropdown edit box -->

        </div>
        <!-- end widget edit box -->

        <!-- widget content -->
        <div class="widget-body no-padding" style="min-height: 50px !important;">

            <div class="table-responsive">

                <table class="table table-bordered table-hover" id="staff-table-{{ $id."-".$i }}">
                    <thead>
                    <tr>
                        <th>No</th>
                        <th>@lang("content.picture")</th>
                        <th>@lang("content.first_name")</th>
                        <th>@lang("content.last_name")</th>
                        <th>@lang("content.station")</th>
                        <th>@lang("content.company")</th>
                        <th>@lang("content.department")</th>
                        <th>@lang("content.position")</th>
                        <th>@lang("content.staff_no")</th>
                        <th>@lang("content.email")</th>
                        <th style="min-width: 60px !important;">@lang("content.doj")</th>

                        <th>@lang("content.min_hrs")</th>
                        <th>@lang("content.max_hrs")</th>
                        @if ($terminated)
                            <th>@lang("content.date_of_termination")</th>
                            <th>@lang("content.reason_of_termination")</th>
                        @elseif($deleted)
                            <th>@lang("content.date_of_deletion")</th>
                            <th>@lang("content.deleted_by")</th>
                        @endif

                        <th style="min-width: 240px !important;">@lang("content.actions")</th>
                    </tr>
                    </thead>
                    <tbody>
                    @if(isset($staffList[$airport]))

                        @php $j = 0 @endphp
                        @foreach($staffList[$airport] as $k => $each)
                            @php $picture = $each->thumb ? '/storage/users/'.$each->thumb : '/assets/img/default-user-picture.png' @endphp
                            <tr>
                                <td>{{ ++$j }}</td>
                                <td><a href="{{ route("homepage")."#".url("/staff/$each->id/edit?s=".rand(100, 999)) }}" >
                                        <img src="{{ $picture }}" width="100" class="img-thumbnail thumb_report_prev" /></a>
                                </td>
                                <td><a target="_blank" href="{{ route("homepage")."#". url("staff/{$each->id}/edit?s=".rand(100, 999)) }}">{{ $each->first_name }}</a></td>
                                <td><a target="_blank" href="{{ route("homepage")."#". url("staff/{$each->id}/edit?s=".rand(100, 999)) }}">{{ $each->last_name }}</a></td>
                                <td>{{ $each->location && $each->location->airport ? $each->location->airport->iata : '' }}</td>
                                <td>{{ $each->company }}</td>
                                <td>{{ $each->department && isset($each->department[0]) ? $each->department[0]->name : "" }}</td>
                                <td>{{ $each->position && isset($each->position[0]) ? $each->position[0]->name : "" }}</td>
                                <td>{{ $each->staff_number }}</td>
                                <td>
                                    {{ $each->email }}
                                    @if ($sprAdm)
                                        <br>
                                        <a href="{{ url("system-log/login-as-user/{$each->id}") }}" target="_blank" class="btn btn-success">Login as User</a>
                                    @endif
                                </td>
                                <td>{{ $each->doj }}</td>
                                <td>{{ $each->min_hours }}</td>
                                <td>{{ $each->max_hours }}</td>

                                @if ($terminated)
                                    <td>{{ $each->resigned_date }}</td>
                                    <td>{{ $each->termination_reason }}</td>
                                    <td>
                                        <div class="btn-group">
                                            <a target="_blank" href="{{ route("homepage")."#". url("staff/{$each->id}") }}" class="btn btn-success">@lang("content.view")</a>
                                            <a target="_blank" href="{{ route("homepage")."#". url("staff/{$each->id}/edit?s=".rand(100, 999)) }}" class="btn btn-warning">@lang("content.edit")</a>
                                            @if ($sprAdm)
                                                <a href="{{ route("homepage")."#system-log/user/{$each->id}" }}" target="_blank" class="btn btn-primary">History</a>
                                            @endif
                                        </div>
                                    </td>
                                @elseif($deleted)
                                    <td>{{ date("Y-m-d", strtotime($each->deleted_at)) }}</td>
                                    <td>{{ getUserName($each->updatedBy) }}</td>
                                    <td>
                                        <div class="btn-group">
                                            <a href="{{ route("homepage")."#". url("staff/{$each->id}/restore") }}" class="btn btn-primary">@lang("content.restore")</a>
                                            <a target="_blank" href="{{ route("homepage")."#". url("staff/{$each->id}") }}" class="btn btn-success">@lang("content.view")</a>
                                            <a target="_blank" href="{{ route("homepage")."#". url("staff/{$each->id}/edit?s=".rand(100, 999)) }}" class="btn btn-warning">@lang("content.edit")</a>
                                            @if ($sprAdm)
                                                <a href="{{ route("homepage")."#system-log/user/{$each->id}" }}" target="_blank" class="btn btn-primary">History</a>
                                            @endif
                                        </div>
                                    </td>
                                @else
                                    <td>
                                        <div class="btn-group">
                                            <a target="_blank" href="{{ route("homepage")."#". url("staff/{$each->id}") }}" class="btn btn-success">@lang("content.view")</a>
                                            <a target="_blank" href="{{ route("homepage")."#". url("staff/{$each->id}/edit?s=".rand(100, 999)) }}" class="btn btn-warning">@lang("content.edit")</a>
                                            <a href="{{ route("homepage")."#". url("staff/{$each->id}/delete") }}" class="btn btn-danger">@lang("content.delete")</a>
                                            @if ($sprAdm)
                                                <a href="{{ route("homepage")."#system-log/user/{$each->id}" }}" target="_blank" class="btn btn-primary">History</a>
                                            @endif
                                        </div>
                                    </td>
                                @endif
                            </tr>
                        @endforeach

                    @endif

                    </tbody>
                </table>

            </div>

        </div>

    </div>

</div>
