<div class="editable_div">

    <h3 style="padding: 10px; margin: 0; background-color: #e6e6e6; color: #000; font-size: 1.2em; font-weight: bold;">@lang("content.preferences")</h3>

    @if (in_array($user->user_role_id, [ROLE_ADMIN, ROLE_SUPER_ADMIN]) || in_array($authUser->user_role_id, [ROLE_ADMIN, ROLE_SUPER_ADMIN]))
    <div class="col-md-12" style="border: 1px solid #ddd ;">
        <p class="col-md-2" style="padding: 10px;">@lang("content.airport")</p>
        <div class="col-md-6" style="padding: 10px;">
        <a href="#" data-field ='airport_id' data-model="StaffStation" data-type="multiselect" data-id = '{{ $user->id }}' data-foreign_key = 'user_id'
               data-placeholder="Required" data-value = '{!! json_encode(array_keys($staffStations)) !!}' class="editable {!! count($staffStations) ? 'editable-click' : 'editable-empty' !!}">
                {!! count($staffStations) ? implode(', ', $staffStations) : 'Empty' !!}</a>
        </div>
    </div>
    @endif

    @if (ghaModule())
        <div class="col-md-12" style="border: 1px solid #ddd; border-top: 0; margin-bottom: 10px;">
            <p class="col-md-2" style="padding: 10px;">@lang("content.airline")</p>
            <div class="col-md-6" style="padding: 10px;">
                <a href="#" data-field ='airline_id' data-model="StaffAirline" data-type="multiselect" data-id = '{{ $user->id }}' data-foreign_key = 'user_id'
                   data-placeholder="Required" data-value = '{!! json_encode(array_keys($staffAirlines)) !!}' class="editable {!! count($staffAirlines) ? 'editable-click' : 'editable-empty' !!}">
                    {!! count($staffAirlines) ? implode(', ', $staffAirlines) : 'Empty' !!}</a>
            </div>
        </div>
    @endif
</div>

<div class="clearfix"></div>

@if (in_array($user->user_role_id, [ROLE_ADMIN, ROLE_SUPER_ADMIN]) || in_array($authUser->user_role_id, [ROLE_ADMIN, ROLE_SUPER_ADMIN]))
    <div class="jarviswidget jarviswidget-color-blueDark" id="wid-license-tab" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

        <header>
            <span class="widget-icon"> <i class="fa fa-table"></i> </span>
            <h2>@lang("content.modules_list")</h2>
        </header>

        <!-- widget div-->
        <div>

            <!-- widget edit box -->
            <div class="jarviswidget-editbox">
                <!-- This area used as dropdown edit box -->

            </div>
            <!-- end widget edit box -->

            <!-- widget content -->
            <div class="widget-body no-padding" style="min-height: 50px !important;">

                <div class="table-responsive editable_div">

                    {!! Form::open(['method' => 'POST', 'class' => 'smart-form edit-forms', 'data-state' => 'Edit', 'url' => url("user-module/{$userId}") ]) !!}

                        <div class="" style="padding: 10px !important;">
                            <button type="button" class="input-sm btn btn-success select_all" style="width: 100px; display: none; ">@lang("content.select_all")</button>
                            <button type="button" class="input-sm btn btn-warning deselect_all" style="width: 100px; display: none; ">@lang("content.deselect_all")</button>
                            <input type="submit" name="save" value="@lang("content.save")" class="input-sm btn btn-primary save_all" style="width: 100px; display: none; " />
                            <button type="button" class="input-sm btn btn-warning edit_all" style="width: 100px;">@lang("content.edit_all")</button>
                            <button type="button" class="input-sm btn btn-danger cancel_all" style="width: 100px; display: none; ">@lang("content.cancel")</button>
                        </div>

                        <div class="clearfix"></div>

                        @php $widthEach = 130 @endphp
                        @php $moduleName = 200 @endphp
                        @php $action = 10 @endphp

                        @php $j = 0 @endphp
                        @php $category = "" @endphp

                        <div class="">
                            @foreach($modules as $i => $module)
                                @if (in_array($module->name, [MODULES, USERS_MODULES, USERS_TRACKING ]) && $user->user_role_id != 4)
                                    @continue
                                @endif

                                @php $permissionCounter = $module->permission->count() @endphp
                                @php $width = ($moduleName + $action) + ($widthEach * $permissionCounter) @endphp

                                @if (!$permissionCounter)
                                    @continue
                                @endif

                                <table class="table table-hover" style="width: {{ $width }}px; min-width: 100% !important; ">

                                    {{--@if ($j % 7 == 0)
                                        <thead>
                                        <tr style="height: 50px; vertical-align: middle;">
                                            <th style="width: {{ $rest }}% !important; border-bottom: 0; vertical-align: middle;">Module Permission</th>
                                            @foreach($module->permission as $permission)
                                                <th class="rotate-45" style="width: {{ $eachPerc }}% !important; border-bottom: 0; vertical-align: middle;">{{ $permission->name }}</th>
                                            @endforeach
                                            <th style="width: 10%; border-bottom: 0; vertical-align: middle">Actions</th>
                                        </tr>
                                        </thead>
                                    @endif--}}

                                    <tbody>

                                    @if ($module->category != $category)
                                        <tr data-category="1" style="border-bottom: 1px solid #ddd !important; background-color: #e6e6e6; color: #000; font-size: 1.2em; font-weight: bold;">
                                            <td colspan="10">{{ $category = $module->category }}</td>
                                        </tr>
                                    @endif

                                    <tr style="border-bottom: 1px solid #ddd !important;">
                                        <td style="width: {{ $moduleName }}px !important; border: 0; ">{{ trans("modules.{$module->lang}") }}</td>

                                        @foreach($module->permission as $permission)
                                            <td style="width: {{ $widthEach }}px !important; border: 0;">
                                                <section>
                                                    <div class="inline-group">
                                                        {{--{!! Form::hidden("module", $module->id) !!}--}}
                                                        <label class="checkbox state-disabled">
                                                            <input name="permission[]" type="checkbox" disabled
                                                                   value="{{ $permission->id }}" {{ in_array($permission->id, $userModulePermissions) ? "checked" : "" }}>
                                                            <i></i>
                                                            {{ trans("content.".strtolower($permission->name)) }}
                                                        </label>
                                                    </div>
                                                </section>
                                            </td>
                                        @endforeach

                                        <td style="min-width: {{ $action }}px; border: 0; padding-left: 0 !important; padding-right: 0 !important;">
                                            {{--<div class="btn-group" style="width: 100%;">--}}
    {{--                                            {!! Form::hidden("module", $module->id) !!}--}}
                                                {{--<input type="submit" name="save" value="Save" class="input-sm btn btn-primary save" style="width: 50px; display: none; " />--}}
                                                {{--<button type="button" class="input-sm btn btn-warning edit" style="width: 50px;">Edit</button>--}}
                                                {{--<button type="button" class="input-sm btn btn-danger cancel" style="width: 50px; display: none; ">Cancel</button>--}}
                                            {{--</div>--}}
                                        </td>
                                    </tr>
                                    </tbody>

                                </table>

                                @php $j++ @endphp

                            @endforeach
                        </div>

                    {!! Form::close() !!}

                </div>
            </div>
        </div>
    </div>
@endif