<div class="col-md-12 no-padding margin-bottom-10">
    <a href="{{ route("homepage")."#". url("staff-license/create/{$user->id}") }}" class="btn btn-primary">@lang("content.attach_license_approval")</a>
</div>

<div class="clearfix"></div>

@if (!count($staffLicenses))
    <div class="alert alert-info" role="alert">
        <a href="#" class="alert-link">@lang("content.info")<br/></a>
        @lang("content.there_are_no_licenses_attached")
    </div>
@else
    <div class="jarviswidget jarviswidget-color-blueDark" id="wid-license-tab" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

    <header>
        <span class="widget-icon"> <i class="fa fa-table"></i> </span>
        <h2>@lang("content.list")</h2>
    </header>

    <!-- widget div-->
    <div>

        <!-- widget edit box -->
        <div class="jarviswidget-editbox">
            <!-- This area used as dropdown edit box -->

        </div>
        <!-- end widget edit box -->

        <!-- widget content -->
        <div class="widget-body no-padding" style="min-height: 50px !important;">

            <div class="table-responsive editable_div">

                <table class="table table-bordered table-hover" id="licenses-table">
                    <thead>
                    <tr>
                        <th>No</th>
                        <th>@lang("content.license_approval")</th>
                        <th style="min-width: 80px;">@lang("content.abbr")</th>
                        <th style="min-width: 100px;">@lang("content.doi")</th>
                        <th style="min-width: 100px;">@lang("content.dex")</th>
                        <th>@lang("content.remove")</th>
                        <th>@lang("content.status")</th>
                        <th style="min-width: 340px;">@lang("content.actions")</th>
                        <th>@lang("content.upload")</th>
                        <th style="min-width: 120px;">@lang("content.created")</th>
                        <th style="min-width: 120px;">@lang("content.updated")</th>

                        @php $logPermission = isAdminOrSuperAdmin() @endphp
                        @if ($logPermission)
                            <th>@lang("content.history")</th>
                        @endif
                    </tr>
{{--                    <tr>--}}
{{--                        <th>@lang("content.at")</th>--}}
{{--                        <th>@lang("content.by")</th>--}}
{{--                        <th>@lang("content.at")</th>--}}
{{--                        <th>@lang("content.by")</th>--}}
{{--                    </tr>--}}
                    </thead>
                    <tbody>
                    @foreach($staffLicenses as $i => $each)
                        @php $licenseExists = $each->attachment_file ? true : false @endphp
                        @if(!$each->license)
                            @continue
                        @endif
                        <tr>
                            <td data-center>{{ $i + 1 }}</td>
                            <td>{{ $each->license->name }}</td>
                            <td><strong>{{ $each->license->abbr }}</strong></td>

                            <td>
                                <a href="#" data-field='license_id' data-field_value="{{ $each->license->id }}" data-model="StaffLicense" data-foreign_key='user_id' data-type="date" data-id='{{ $user->id }}' data-placeholder="Required" data-format='d-M-Y'
                                   data-js_format = 'DD-MMM-YYYY'  data-value_key="issue_date"  data-value='{{ $each->issue_date }}'
                                   class="editable {{ $each->issue_date ? 'editable-click' : 'editable-empty'  }}">{{ $each->issue_date ? date('d-M-Y', strtotime($each->issue_date))  : 'Empty' }}</a>
                            </td>

                            <td>
                                <a href="#" data-field='license_id' data-field_value="{{ $each->license->id }}" data-model="StaffLicense" data-foreign_key='user_id' data-type="date" data-id='{{ $user->id }}' data-placeholder="Required" data-format='d-M-Y'
                                   data-js_format = 'DD-MMM-YYYY'  data-value_key="expiry_date"  data-value='{{ $each->expiry_date }}'
                                   class="editable {{ $each->expiry_date ? 'editable-click' : 'editable-empty'  }}">{{ $each->expiry_date ? date('d-M-Y', strtotime($each->expiry_date))  : 'Empty' }}</a>
                            </td>
                            <td>
                                <a href="{{ url("staff-license/delete/{$each->id}") }}" class="btn btn-danger">@lang("content.delete")</a>
                            </td>

                            <td>{!! Expiration_Date($each->expiry_date, $each->issue_date)['status'] !!}</td>

                            <td>
                                <div class="btn-group">
                                    @if ($licenseExists)
                                        <a target="_blank" href="{{ url("staff-license/{$each->id}") }}?view=1" class="btn btn-warning">@lang("content.view")</a>
                                        <a href="{{ url("staff-license/{$each->id}") }}?download=1" class="btn btn-primary">@lang("content.download")</a>
                                        <a href="{{ route("homepage")."#". url("staff-license/delete/file/{$each->id}") }}" class="btn btn-danger">@lang("content.remove")</a>
                                    @endif
                                    <a class="btn btn-success edit-update">@lang("content.upload")</a>
                                </div>
                            </td>
                            <td>
                                <div class="upload-container" style="padding: 15px; display: none" >
                                    {!! Form::open(['files' => true, 'method' => 'POST', 'url' => url("staff-license/{$each->id}")]) !!}
                                        {!! Form::file('file') !!}

                                        <br/>
                                        <div class="btn-group">
                                            {!! Form::submit( trans("content.upload"), ['class' => 'btn btn-success', 'name' => 'upload']) !!}
                                        </div>

                                    {!! Form::close() !!}
                                </div>
                            </td>

                            <td>{{ baseDateFormat($each->created_at, true) }}</td>
{{--                            <td>{{ getUserFullName($each->created_by) }}</td>--}}
                            <td>{{ baseDateFormat($each->updated_at, true) }}</td>
{{--                            <td>{{ getUserFullName($each->updated_by) }}</td>--}}
                            {{--<th class="color-red" colspan="4">No Services Found!</th>--}}

                            @if ($logPermission)
                                <td>
                                    <a target="_blank" href="{{ route("homepage")."#". url("system-log/staff-license/{$each->id}") }}">
                                        @lang("content.show_history")
                                    </a>
                                </td>
                            @endif
                        </tr>

                    @endforeach

                    </tbody>

                </table>

            </div>

        </div>

    </div>

</div>
@endif