<div class="col-md-12 margin-bottom-10">

    <form class="form-inline" method="get" action="{{ $page }}?tab=hours">

        <label>@lang("content.period") </label>
        <div class="btn-group">{!! Form::select("period", $periods, \request("period"), ["class"=>"form-control marginRight"]) !!}</div>
        {!! Form::label('from', trans("content.from")) !!}
        {!! Form::text('from', $from, ['class' => 'form-control dateFrom inputDateSmall']) !!}
        {!! Form::label('to', trans("content.to")) !!}
        {!! Form::text('to', $to, ['class' => 'form-control dateTo inputDateSmall']) !!}
        {!! Form::submit("Submit", ["class" => "btn btn-primary btn-sm"]) !!}
        {!! Form::hidden("id", \request("id")) !!}
        {!! Form::hidden("tab", "hours") !!}

        <p class="padding-top-5 color-red">*All times in UTC</p>
    </form>

</div>

<div class="clearfix"></div>

    <ul class="nav nav-pills" id="hoursSubItems" style="margin-top: 10px; margin-bottom: 10px;">
        <li class="active">
            <a href="#hours-tab-roster" data-toggle="tab">@lang("content.roster")</a>
        </li>
        <li class="">
            <a href="#hours-tab-office_duties" data-toggle="tab">@lang("content.office_duties")</a>
        </li>
        <li class="">
            <a href="#hours-tab-total" data-toggle="tab">@lang("content.total")</a>
        </li>
        <li class="">
            <a href="#hours-tab-daily" data-toggle="tab">@lang("content.daily")</a>
        </li>
        <li class="">
            <a href="#hours-tab-monthly" data-toggle="tab">@lang("content.monthly")</a>
        </li>
        <li class="">
            <a href="#hours-tab-yearly" data-toggle="tab">@lang("content.yearly")</a>
        </li>

    </ul>

    <div class="tab-content" style="background: #e3e3e3">
        {{--General Tab--}}
        <div class="tab-pane active bg-color-white" id="hours-tab-roster" style="">

            @include('staff.layouts.edit-hours-roster-tab')

        </div>

        <div class="tab-pane bg-color-white" id="hours-tab-office_duties" style="">

            @include('staff.layouts.edit-hours-office-duties-tab')

        </div>

        <div class="tab-pane bg-color-white" id="hours-tab-total" style="">

            @include('staff.layouts.edit-hours-total-tab')

        </div>

        <div class="tab-pane bg-color-white editable_div" id="hours-tab-daily" style="">

            @include('staff.layouts.edit-hours-tab-period', ['data' => $staffHours['daily'], 'dailyHoursTable'])

        </div>

        <div class="tab-pane bg-color-white editable_div" id="hours-tab-monthly" style="">

            @include('staff.layouts.edit-hours-tab-period', ['data' => $staffHours['monthly'], 'monthlyHoursTable'])

        </div>

        <div class="tab-pane bg-color-white editable_div" id="hours-tab-yearly" style="">

            @include('staff.layouts.edit-hours-tab-period', ['data' => $staffHours['yearly'], 'yearlyHoursTable'])

        </div>

    </div>
