@if (!count($staffHistory))
    <div class="alert alert-info"  style="margin-top: 10px">
        <h4>Search results:</h4>
        <p>Found 0 records</p>
    </div>
@else

    <div class="jarviswidget jarviswidget-color-blueDark" id="wid-hours" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

        <header>
            <span class="widget-icon"> <i class="fa fa-table"></i> </span>
            <h2>@lang("content.list")</h2>
        </header>

        <!-- widget div-->
        <div>

            <!-- widget edit box -->
            <div class="jarviswidget-editbox">
                <!-- This area used as dropdown edit box -->

            </div>
            <!-- end widget edit box -->

            <!-- widget content -->
            <div class="widget-body no-padding" style="min-height: 50px !important;">

                <div class="table-responsive" style="overflow: auto;">

                    <table style="min-width: {{ 1000 + count($periodUnique) * 100 }}px;" class="table table-bordered table-hover table-filter apply_filter" id="officeDutiesTable">
                        <thead>
                        <tr>
                            <th style="width: 60px;">No</th>
                            <th>@lang("content.duty")</th>
                            <th>@lang("content.airline")</th>
                            <th>@lang("content.from")</th>
                            <th>@lang("content.to")</th>
                            <th>@lang("content.duration")</th>
                            <th>@lang("content.rmks")</th>
                            <th>@lang("content.signature")</th>
                            <th>@lang("content.date")</th>
{{--                            <th>@lang("content.created_at")</th>--}}
{{--                            <th>@lang("content.created_by")</th>--}}
                        </tr>

                        </thead>

                        <tbody>
                        @php $totalSecs = $i = 0 @endphp
                        @foreach($staffHistory["list"] as $id => $data)
                            @foreach($data["history"] as $each)
                                @php $dayOffsClass = $each->condition->name == "DAY OFF" ? "day_off" : "" @endphp
                                @php $seconds = CalculateDifference($each->condition_from, $each->condition_to, true) @endphp
                                @if ($each->condition->name == NOT_AVAILABLE)
                                    @continue
                                @endif
                                @if (!$each->condition->skip_total)
                                    @php $totalSecs += $seconds @endphp
                                @endif
                                <tr class="{{ $dayOffsClass }}">
                                    <td data-center>{{ ++$i }}</td>
                                    <td>{{ $each->condition->name }}</td>
                                    <td>{{ $each->airline ? $each->airline->airline : ""  }}</td>
                                    <td data-center>{{ $each->condition_from }}</td>
                                    <td data-center>{{ $each->condition_to }}</td>
                                    <td data-center>{{ convertToHoursMinutes($seconds, true) }}</td>
                                    <td>{{ $each->notes }}</td>
                                    <td></td>
                                    <td></td>
{{--                                    <td>{{ baseDateFormat($each->created_at, true) }}</td>--}}
{{--                                    <td>{{ getUserName($each->createdBy) }}</td>--}}
                                </tr>
                            @endforeach
                        @endforeach
                        <tr>
                            <td data-center><strong>Total</strong></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td data-center><strong>{{ convertToHoursMinutes($totalSecs, true) }}</strong></td>
                            <td></td>
                            <td></td>
                            <td></td>
                        </tr>
                        </tbody>

                    </table>
                </div>

            </div>

        </div>

    </div>

@endif
