<?php require_once(public_path("smart/inc/init.php")); ?>

<!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            <div class="col-md-12 no-padding margin-bottom-10">
                <a href="{{ route("homepage")."#". url("staff/create?s=".rand(100, 999)) }}" class="btn btn-primary">@lang("content.add_new_staff")</a>
                <a href="{{ route("homepage")."#". url("staff-upload") }}" class="btn btn-success mr-5">@lang("content.upload_staff")</a>
            </div>

            <div class="clearfix"></div>

            <ul class="nav nav-tabs bordered">
                <li class="active">
                    <a href="#staff-by-stations" role="tab" data-toggle="tab">@lang("content.all_current_staff")</a>
                </li>
                <li class="">
                    <a href="{{ route("homepage")."#staff/by-station" }}">@lang("content.by_station")</a>
                </li>

                @if ($terminatedPermission || $sprAdm)
                    <li class="">
                        <a href="{{ route("homepage")."#staff/terminated-deleted" }}">@lang("content.terminated_staff")</a>
                    </li>
                    <li class="">
                        <a href="{{ route("homepage")."#staff/terminated-deleted" }}">@lang("content.deleted_staff")</a>
                    </li>
                @endif
            </ul>

            <div class="tab-content padding-10 background-white">
                <div class="tab-pane active" id="staff-by-stations">
                    @include("staff.layouts.staff-list", ["i" => 0, "id" => "current", "airport" => ALL, "staffList" => $staffList])
                </div>
            </div>

        </article>

    </div>

</section>

<script type="text/javascript">

    pageSetUp();

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyDateFormats();

        Apply_Multiselect();

        ApplyTableFilter("#staff-table-current-0");
    }

    pagefunction();

</script>