<?php require_once(public_path("smart/inc/init.php")); ?>

<!-- widget grid -->
<section id="widget-grid" class="">
    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
            <div class="col-lg-7 col-lg-offset-1">

                {!! Form::open(['method' => 'POST', 'class' => "form-horizontal", 'url' => url("staff"), "autocomplete" => "off"]) !!}

                    <div class="form-group has-feedback">
                        <label class="control-label col-sm-3 color-red">@lang("content.first_name")*</label>
                        <div class="col-sm-9">
                            {!! Form::text('first_name', null, ['class' => 'form-control', 'placeholder' => trans("content.first_name"), 'id' => 'first_name', "required" => "required"]) !!}
                            <span class="glyphicon glyphicon glyphicon-ok form-control-feedback"></span>
                        </div>
                    </div>
                    <div class="form-group has-feedback">
                        <label class="control-label col-sm-3 color-red">@lang("content.last_name")*</label>
                        <div class="col-sm-9">
                            {!! Form::text('last_name', null, ['class' => 'form-control', 'placeholder' => trans("content.last_name"), 'id' => 'last_name', "required" => "required"]) !!}
                            <span class="glyphicon glyphicon glyphicon-ok form-control-feedback"></span>
                        </div>
                    </div>
                    <div class="form-group has-feedback">
                        <label class="control-label col-sm-3 color-red">@lang("content.email")*</label>
                        <div class="col-sm-9">
                            {!! Form::text('email', null, ['class' => 'form-control', 'placeholder' => trans("content.email"), 'id' => 'email', "required" => "required"]) !!}
                            <span class="glyphicon glyphicon glyphicon-ok form-control-feedback"></span>
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="control-label col-sm-3 color-red">@lang("content.location")*</label>
                        <div class="col-sm-9">
                            {!! Form::select('location', $locations, null, ['class' => 'form-control', 'id' => 'location']) !!}
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-sm-3 control-label color-red">@lang("content.department")*</label>
                        <div class="col-sm-9">
                            {!! Form::select('department_id', $departments, null, ['class' => 'form-control', 'id' => 'department_id']) !!}
                        </div>
                    </div>
                    <div class="form-group" id="subdepartment" style="display: none;">
                        <label class="col-sm-3 control-label">@lang("content.subdepartment")</label>
                        <div class="col-sm-9">
                            {!! Form::select('subdepartment_id', [], null, ['class' => 'form-control', 'id' => 'subdepartment_id']) !!}
                        </div>
                    </div>

                    <div class="form-group" id="position" style="display: none;">
                        <label class="col-sm-3 control-label color-red">@lang("content.position")</label>
                        <div class="col-sm-9">
                            {!! Form::select('position_id', [], null, ['class' => 'form-control', 'id' => 'position_id'])!!}
                        </div>
                    </div>

                    <div class="form-group" id="other_position" style="display: none;">
                        <label class="col-sm-3 control-label color-red">@lang("content.other_position")</label>
                        <div class="col-sm-9">
                            {!! Form::text('other_position', null, ['class' => 'form-control', 'id' => 'other_position_id'])!!}
                        </div>
                    </div>

                    @if (env(CARRIER) == AIRLINE)
                    <div class="form-group">
                        <label class="control-label col-sm-3">@lang("content.crew")</label>
                        <div class="col-sm-9">
                            <label class="radio-inline">
                                {!! Form::radio('crew', 0, true, ['id' => 'no_crew']) !!} @lang("content.off")
                            </label>
                            <label class="radio-inline">{!! Form::radio('crew', CCM_CREW, null, ['id' => 'ccm']) !!} @lang("content.cabin_crew")</label>
                            <label class="radio-inline">{!! Form::radio('crew', FCM_CREW, null, ['id' => 'fcm']) !!} @lang("content.flight_crew")</label>
                        </div>
                    </div>
                    @endif

                    <div class="form-group">
                        <label class="control-label col-sm-3 color-red">@lang("content.password")*</label>
                        <div class="col-sm-9">
                            {!! Form::password('password', ['class' => 'form-control', 'placeholder' => trans("content.password"), 'id' => 'password', "required" => "required"]) !!}
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="control-label col-sm-3 color-red">@lang("content.confirm_password")*</label>
                        <div class="col-sm-9">
                            {!! Form::password('password_confirmation', ['class' => 'form-control', 'placeholder' => trans("content.confirm_password"), 'id' => 'password_confirmation', "required" => "required"]) !!}
                        </div>
                    </div>
                    <div class="form-group has-feedback">
                        <label class="control-label col-sm-3">@lang("content.date_of_birth")</label>
                        <div class="col-sm-9">
                            {!! Form::text('dob', null, ['class' => 'form-control date', 'placeholder' => 'YYYY-MM-DD', 'id' => 'dob']) !!}
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="control-label col-sm-3">@lang("content.contractor")</label>
                        <div class="col-sm-9">
                            <label class="checkbox-inline">
                                {!! Form::checkbox('is_contractor', 1, null, ['id' => 'is_contractor']) !!} @lang("content.yes_no")
                            </label>
                       </div>
                    </div>
                    <div class="form-group has-feedback">
                        <label class="control-label col-sm-3 color-red">@lang("content.company")</label>
                        <div class="col-sm-9">
                            {!! Form::text('company', null, ['class' => 'form-control', 'placeholder' => trans("content.company"), 'id' => 'company']) !!}
                        </div>
                    </div>

                    <div class="form-group has-feedback">
                        <label class="control-label col-sm-3">@lang("content.id_card_no")</label>
                        <div class="col-sm-9">
                            {!! Form::text('idcard_number', null, ['class' => 'form-control', 'placeholder' => trans("content.id_card_no"), 'id' => 'idcard_number']) !!}
                        </div>
                    </div>

                    <div class="form-group has-feedback">
                        <label class="control-label col-sm-3">@lang("content.id_card_expiry")</label>
                        <div class="col-sm-9">
                            {!! Form::text('idcard_expiry', null, ['class' => 'form-control  input-sm date', 'placeholder' => trans("content.id_card_expiry"), 'id' => 'idcard_expiry']) !!}
                        </div>
                    </div>

                    <div class="form-group">
                        <div class="col-sm-offset-3 col-sm-9">
                            <button type="submit" class="btn btn-primary">@lang("content.add")</button>
                            <a href="{!! route("homepage")."#". url("staff") !!}" class="btn btn-default">@lang("content.back")</a>
                        </div>
                    </div>

                {!! Form::close() !!}

            </div>

        </article>

    </div>

</section>

<script type="text/javascript">

    pageSetUp();

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyDateFormats();

        Apply_Multiselect();

        ApplyTableFilter("#table");
    };

    loadScript("{{  asset("/assets/js/views/user/add-user.js?4") }}", pagefunction);

</script>
