@php $airlineModule = airlineModule() @endphp

@if ($airlineModule)
    <div class="form-group margin-top-10">
        <div class="form-group col-sm-3">
            <label class="col-sm-5 control-label">@lang("content.ac_type")</label>
            <div class="col-sm-7">
                {!! Form::select('aircraft_type_id', $aircraftTypes, null, ['class'=>'form-control', 'id'=>'aircraft_type_id']) !!}
            </div>
        </div>

        {{--Manual AC Type--}}
        <div class="form-group col-sm-3">
            <label class="checkbox-inline col-sm-6">
                {!! Form::checkbox('manual_ac_type', 'value', false, ['id' => 'manual_ac_type']) !!}
                @lang("content.add_ac_type")
            </label>

            <div class="col-sm-6" style="display: none" id="manual_ac_type_container">
                {!! Form::text('ac_type', null, ['class' => 'form-control', "maxlength" => "15", 'id' => 'ac_type']) !!}
            </div>
        </div>

        <div class="form-group col-sm-3">
            <label class="col-sm-5 control-label">@lang("content.ac_reg")</label>
            <div class="col-sm-7">
                {!! Form::select('aircraft_id', $aircraft, null, ['class'=>'form-control', 'id'=>'aircraft_id']) !!}
            </div>
        </div>

        {{--Manual AC--}}
        <div class="form-group col-sm-3">
            <label class="checkbox-inline col-sm-offset-1 col-sm-6">
                {!! Form::checkbox('manual_ac', 'value', false, ['id' => 'manual_ac']) !!}
                @lang("content.add_aircraft")
            </label>

            <div class="col-sm-5" style="display: none" id="manual_ac_container">
                {!! Form::text('ac', null, ['class' => 'form-control', "maxlength" => "10", 'id' => 'ac']) !!}
            </div>
        </div>
    </div>

    <ul class="nav nav-tabs margin-top-10" id="flight_by_type_tab">
        <li class="">
            <a href="#tabDetails" data-toggle="tab">@lang("content.details")</a>
        </li>
        <li class="">
            <a href="#tabLine" data-toggle="tab">@lang("content.line")</a>
        </li>
    </ul>

    <div class="tab-content" style="background: #e3e3e3; margin-top: 10px;">
        <div class="tab-pane bg-color-white editable_div" id="tabDetails" style="">
            @include("staff-watch.templates.form-flight-details-airline")
        </div>

        @if ($airlineModule)
            <div class="tab-pane bg-color-white editable_div" id="tabLine" style="">

                <div class="padding-5 margin-bottom-10 inline-group" id="lineHeader" style="display: none">
                    <div class="margin-right-20" style="float: left;">
                        <h4 class="text-white font-weight-bold" id="lineTitle"></h4>
                    </div>
                    <a id="save_line" class="btn btn-warning">@lang("content.save_changes")</a>
                </div>

                @include('flight-tracker.layouts.flights-list-airline', ["flightsOPS" => [], "tableId" => "tableFltLine", "checkbox" => true])
            </div>
        @endif
    </div>
@else
    @include("staff-watch.templates.form-flight-details")
@endif
