@php $airlineModule = airlineModule() @endphp
<div id="{{ $type }}-message-block"></div>

<div>

    <ul id="{{ $type }}-tab-info" class="nav nav-tabs bordered">

        <li class="active">
            <a href="#{{ $type }}_raw_data" data-toggle="tab"><i class="fa fa-fw fa-lg fa-database"></i> @lang("content.message") <span class="badge bg-color-blue txt-color-white" id="{{ $type }}-data-no"></span></a>
        </li>
        <li>
            <a href="#{{ $type }}_list" data-toggle="tab"><i class="fa fa-fw fa-lg fa-user"></i> @lang("content.passengers") <span class="badge bg-color-blue txt-color-white" id="{{ $type }}-passenger-no"></span></a>
        </li>
        <li>
            <a href="#{{ $type }}_details" data-toggle="tab"><i class="fa fa-fw fa-lg fa-info-circle"></i> @lang("content.details")<span class="badge bg-color-blue txt-color-white" id="{{ $type }}-details-no"></span></a>
        </li>
        <li>
            <a href="#{{ $type }}_inbound" data-toggle="tab"><i class="fa fa-fw fa-lg fa-sign-in"></i> @lang("content.inbound") <span class="badge bg-color-blue txt-color-white" id="{{ $type }}-inbound-no"></span></a>
        </li>
        <li>
            <a href="#{{ $type }}_outbound" data-toggle="tab"> @lang("content.outbound") <i class="fa fa-fw fa-lg fa-sign-out"></i><span class="badge bg-color-blue txt-color-white" id="{{ $type }}-outbound-no"></span></a>
        </li>
        <li>
            <a href="#{{ $type }}_xbag" data-toggle="tab"><i class="fa fa-fw fa-lg fa-suitcase"></i> @lang("content.XBAG")<span class="badge bg-color-blue txt-color-white" id="{{ $type }}-xbag-no"></span></a>
        </li>

        @if ($airlineModule)
            <li>
                <a href="#{{ $type }}_docs" data-toggle="tab"><i class="fa fa-fw fa-lg fa-file-text-o"></i> @lang("content.DOCS") <span class="badge bg-color-blue txt-color-white" id="{{ $type }}-docs-no"></span></a>
            </li>
        @endif

    </ul>

    <div id="{{ $type }}-tab-content" class="tab-content padding-10">

        <div class="tab-pane active" id="{{ $type }}_raw_data">

            <div class="message-block" data-type="{{ $type }}" style="margin-top: 10px"></div>

            <div class="col-lg-12 message-container" id="{{ $type }}-data-container" style="max-height: 500px; min-height: 200px; overflow: auto; padding: 0;"></div>

            <div class="clearfix"></div>
        </div>

        <div class="tab-pane" id="{{ $type }}_list">
            <div class="col-md-12" style="margin: 10px 0">
                <h4 class="pnl">
                    <span class="margin-right-10"><span class="color-item inbound"></span> - @lang("content.inbound")</span>
                    <span class="margin-right-10"><span class="color-item outbound"></span> - @lang("content.outbound")</span>
                    <span class="margin-right-10"><span class="color-item outbound-inbound"></span> - @lang("content.inbound")/@lang("content.outbound")</span>
                    <span class="margin-right-10"><span class="color-item inf"></span> - @lang("content.infant")</span>
                    <span class="margin-right-10"><i class="fa fa-md fa-suitcase"></i> - @lang("content.extra_baggage")</span>
                </h4>
            </div>
            
            <div class="clearfix"></div>
            
            <div id="{{ $type }}-container" style="min-height: 200px ; max-height: 436px; overflow: auto;">
                <table id="{{ $type }}-table" class="table table-bordered table-striped table-hover" data-opened="0" style="">
                    <thead>
                    <tr>
                        <th width="5%">No</th>
                        <th width="5%">SEQ</th>
                        <th><i class="fa fa-md fa-suitcase"></i></th>
                        <th>@lang("content.first_name")</th>
                        <th>@lang("content.last_name")</th>
                        <th>G</th>
                        <th>@lang("content.seat")</th>
                        <th>@lang("content.GRP")</th>
                        <th>@lang("content.ticket_no")</th>
                        <th>CPN</th>
                        <th>PNR</th>
                        <th>FQTV</th>
                        {{--<th>Cabin</th>--}}
                        {{--<th>Bag(pcs)</th>--}}
                        {{--<th>Bag(wt)</th>--}}
                        {{--<th>DOB</th>--}}
                    </tr>
                    </thead>
                    <tbody id="{{ $type }}-table-body">

                    </tbody>
                </table>
            </div>
        </div>

        <div class="tab-pane" id="{{ $type }}_details">
            <div id="{{ $type }}-details-container" style="min-height: 300px ; max-height: 436px; overflow: auto;">
                <table id="{{ $type }}-details-table" class="table table-bordered table-striped table-hover" data-opened="0">
                    <thead>
                    <tr>
                        <th rowspan="2" width="5%">No</th>
                        <th rowspan="2">@lang("content.first_name")</th>
                        <th rowspan="2">@lang("content.last_name")</th>
                        {{--<th colspan="2" data-center>@lang("content.resident")</th>--}}
                        <th colspan="3" data-center>@lang("content.baggage")</th>
                    </tr>
                    <tr>
                        {{--<th>@lang("content.country")</th>--}}
                        {{--<th>@lang("content.address")</th>--}}

                        <th>Pcs</th>
                        <th>@lang("content.weight")</th>
                        <th>@lang("content.tag_number")</th>
                    </tr>
                    </thead>
                    <tbody id="{{ $type }}-details-table-body">

                    </tbody>
                </table>
            </div>
        </div>

        <div class="tab-pane" id="{{ $type }}_inbound">
            <div id="{{ $type }}-inbound-container" style="min-height: 300px ; max-height: 436px; overflow: auto;">
                <table id="{{ $type }}-inbound-table" class="table table-bordered table-striped table-hover" data-opened="0">
                    <thead>
                    <tr>
                        <th width="5%">No</th>
                        <th>@lang("content.first_name")</th>
                        <th>@lang("content.last_name")</th>
                        <th>@lang("content.flight_number")</th>
                        <th>RBD</th>
                        <th>@lang("content.arrival")</th>
                        <th>@lang("content.origin")</th>
                    </tr>
                    </thead>
                    <tbody id="{{ $type }}-inbound-table-body">

                    </tbody>
                </table>
            </div>
        </div>

        <div class="tab-pane" id="{{ $type }}_outbound">
            <div id="{{ $type }}-outbound-container" style="min-height: 300px ; max-height: 436px; overflow: auto;">
                <table id="{{ $type }}-outbound-table" class="table table-bordered table-striped table-hover" data-opened="0">
                    <thead>
                    <tr>
                        <th rowspan="2">No</th>
                        <th colspan="2">@lang("content.passenger")</th>
                        <th colspan="4">@lang("content.flight_details")</th>
                        <th colspan="2">PTM @lang("content.data")</th>
                        <th colspan="2">@lang("content.baggage")</th>
                    </tr>
                    <tr>
                        <th>@lang("content.first_name")</th>
                        <th>@lang("content.last_name")</th>

                        <th rowspan="2">@lang("content.flight_number")</th>
                        <th rowspan="2">RBD</th>
                        <th rowspan="2">@lang("content.departure")</th>
                        <th rowspan="2">@lang("content.destination")</th>

                        <th>@lang("content.other_info")</th>
                        <th>PAX</th>

                        <th>PCS</th>
                        <th>WT</th>
                    </tr>
                    </thead>
                    <tbody id="{{ $type }}-outbound-table-body">

                    </tbody>
                </table>
            </div>
        </div>

        <div class="tab-pane" id="{{ $type }}_xbag">
            <div id="{{ $type }}-xbag-container" style="min-height: 300px ; max-height: 436px; overflow: auto;">
                <table id="{{ $type }}-xbag-table" class="table table-bordered table-striped table-hover" data-opened="0">
                    <thead>
                    <tr>
                        <th width="5%">No</th>
                        <th>@lang("content.first_name")</th>
                        <th>@lang("content.last_name")</th>
                        <th>@lang("content.weight")</th>
                    </tr>
                    </thead>
                    <tbody id="{{ $type }}-xbag-table-body">

                    </tbody>
                </table>
            </div>
        </div>

        @if ($airlineModule)
            <div class="tab-pane" id="{{ $type }}_docs">
                <div id="{{ $type }}-docs-container" style="min-height: 300px ; max-height: 436px; overflow: auto;">
                    <table id="{{ $type }}-docs-table" class="table table-bordered table-striped table-hover" data-opened="0">
                        <thead>
                        <tr>
                            <th width="5%">No</th>
                            <th>@lang("content.first_name")</th>
                            <th>@lang("content.last_name")</th>
                            <th>@lang("content.gender")</th>
                            <th>@lang("content.dob")</th>
                            <th>@lang("content.passport_no")</th>
                            <th>@lang("content.country_of_issue")</th>
                            <th>@lang("content.dex")</th>
                        </tr>
                        </thead>
                        <tbody id="{{ $type }}-docs-table-body">
                        </tbody>
                    </table>
                </div>
            </div>
        @endif

    </div>

</div>