<?php

    //initialize the page
    require_once(public_path("smart/inc/init.php"));

    //require UI configuration (nav, ribbon, etc.)
    require_once(public_path("smart/inc/config.ui.php"));

    include_once(public_path("smart/inc/user_variables.php"));


    /*---------------- PHP Custom Scripts ---------

    YOU CAN SET CONFIGURATION VARIABLES HERE BEFORE IT GOES TO NAV, RIBBON, ETC.
    E.G. $page_title = "Custom Title" */

    $page_title = trans("modules.staff_watch");

    /* ---------------- END PHP Custom Scripts ------------- */

    //include header
    //you can add your custom css in $page_css array.
    //Note: all css files are inside css/ folder
    $page_css[] = "your_style.css";

    $no_main_header = true;

    $page_body_prop = array("id"=>"extr-page", "class"=>"animated fadeInDown");

    include(public_path("smart/inc/header.php"));

?>
<style>
    span.item {
        display: inline-block;
        margin-top: 8px;
    }
    div.fleetwatch_form .form-control{
        font-size: 14px !important;
    }
    div.fleetwatch_form select.crew{
        max-width: 200px !important;
    }
    div.fleetwatch_form label{
        font-size: 14px !important;
    }
    body{
        background-color: #FFFFff;
    }
    .form-inline input[type="text"],
    .form-inline input[type="email"],
    .form-inline select {
        margin-right: 10px;
        max-width: 160px;
    }
    #mytimeline .ui-widget-content {
        background: #FFF;
    }
    .message-item > pre {
        max-width: 890px;
    }

    div.timeline-groups-text{
        font-weight: bold;
    }

    a.left_sidebar:hover{
        cursor: pointer !important;
    }
    th.checkbox-column:hover{
        cursor: pointer !important;
    }
    div.timeline-axis{
        background: #353D4B !important;
    }
    div.timeline-axis-grid-minor{
        /*border-color: #4250bf !important;*/
    }
</style>


<!-- ==========================CONTENT STARTS HERE ========================== -->
<!-- possible classes: minified, no-right-panel, fixed-ribbon, fixed-header, fixed-width-->
<header id="header" style="background-color: #ffffff !important; height: auto">
    <!--<span id="logo"></span>-->

    <div id="logo-group" style="{{ $div_external_page }}">
        <span> <img style="{{ $logo_external_page }}" src="{{ $logo_fw }}"  alt=""> </span>
        <h2 style="{{ $logo_text_external_page }}">{{ $logo_text }}</h2>
        <!-- END AJAX-DROPDOWN -->
    </div>

    @if (isset($logo2) && $logo2)
        <div id="logo-group" style="{{ $div2_external_page }}">
            <span> <img style="{{ $logo2_external_page }}" src="{{ $logo2 }}"  alt=""> </span>
            <!-- END AJAX-DROPDOWN -->
        </div>
    @endif

    @php $authUser = \Auth::user() @endphp
    @php $marginLeft = $isMobile ? "10px" : "50px" @endphp

    @if (env(CARRIER) == HANDLING && count($handlingAirports) >= 1)
        <div style="margin-top: 20px; margin-left: {{ $marginLeft }}; text-align: center">
{{--            <a id="occ_sla" style="cursor:pointer;  margin-bottom: 5px; margin-right: 30px;" class="btn btn-success font-md occ-sla" data-id="">OCC</a>--}}

{{--            <a id="all_stations" style="cursor:pointer;  margin-bottom: 5px;" class="btn btn-success font-md quick-airports {{ !count($staffStations) ? "btn-warning" : "" }}" data-id="">ALL</a>--}}
            @foreach($handlingAirports as $id => $each)
                @if (in_array($id, $staffStations))
                    <a style="cursor:pointer; margin-bottom: 5px;" class="btn btn-primary font-md quick-airports {{ $id == $selectedAirportIds ? "btn-warning" : "" }}" data-id="{{ $id }}">{{ $handlingAirports[$id] }}</a>
                @endif
            @endforeach
        </div>

{{--        @if (!$isMobile && count($handlingAirlines) > 1)--}}
{{--            <div style="width: 100%; margin: 10px auto; text-align: center; height: auto !important;">--}}
{{--                <a id="all_airlines" style="cursor:pointer;" class="btn btn-success font-sm quick-airlines {{ !count($staffAirlines) ? "selected" : "" }}" data-id="">ALL</a>--}}
{{--                @foreach($handlingAirlines as $id => $each)--}}
{{--                    @if (in_array($id, $staffAirlines))--}}
{{--                        <img style="cursor:pointer;"  data-id="{{ $id }}" class="header-airline-logo quick-airlines {{ in_array($id, $staffAirlines) ? "selected" : "" }}" src="{{  asset("storage/airlines/img/{$each}")}}" />--}}
{{--                    @endif--}}
{{--                @endforeach--}}
{{--            </div>--}}
{{--        @endif--}}
    @endif


</header>

<div class="clearfix"></div>


<div id="main" role="main" style="padding-bottom: 10px !important;">

    <!-- MAIN CONTENT -->
    <div id="content" class="">

        @include('general.tab-header')

        <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            <div class="col-xs-12 col-sm-12 col-md-6 col-lg-6" style="margin-bottom: 15px;">

                {!! Form::open(["method"=>"get", "id"=>"go_to_date_form", 'class' => 'form-inline']) !!}
                    <button id="btn_prev_date" style="font-size:18px; padding: 0 10px; margin-right: 5px;" class="floatOnly btn btn-success">{{ LEFT_ARROW }}</button>
                    {!! Form::input("text", "go_to_date", \request("go_to_date") ? \request("go_to_date") : date("Y-m-d"), ["class"=>"form-control height27 floatOnly date fleetwatch-input-date margin-right-5", "placeholder"=>"Date", "id"=>"go_to_date"]) !!}
                    <button id="btn_next_date" style="font-size:18px; padding: 0 10px; margin-right: 5px;" class="floatOnly btn btn-success">{{ RIGHT_ARROW }}</button>
{{--                    {!! Form::select('go_to_airline_id[]', $airlines, \request("go_to_airline_id"), ['multiple'=>'multiple', 'class'=>'multiselect_search', 'id'=>'go_to_airline_id']) !!}--}}
{{--                    {!! Form::select('go_to_airport_id[]', $locationsAirports, \request("go_to_airport_id"), ['multiple'=>'multiple', 'class'=>'multiselect_search', 'id'=>'go_to_airport_id']) !!}--}}


{{--                    {!! Form::hidden("airport_id", null, ["id" => "go_to_date_airport_id"]) !!}--}}
{{--                    {!! Form::hidden("airline_id", null, ["id" => "go_to_date_airline_id"]) !!}--}}

                    <div class="form-group margin-left-10 margin-right-10">
                        <label>@lang("content.airline")</label>
                        <div class="btn-group">
                            {!! Form::select('airline[]', $airlines, \request("airline"), ['multiple'=>'multiple', 'class'=>'multiselect_search', 'id'=>'airline']) !!}
                        </div>
                    </div>

                    {!! Form::submit("Submit", [ "id" => "btn_go_to_date", "class" => "btn btn-success"]) !!}

                    <span style="font-size: 11px; color: #5f5f5f; display: none; margin-left: 20px;" id="loading-fleetwatch-data">
                        <img width="24" src="{{ asset("/assets/img/2.GIF") }}" alt="Loading..."/>
                    </span>

                {!! Form::close() !!}

            </div>

            <div class="col-xs-12 col-sm-12 col-md-3 col-lg-3 text-center" style="margin-bottom: 15px;">
                <span class="staff_timeNow">@lang("content.today"): {!! gmdate('D, d M Y') !!}</span><br/>
                <span class="staff_timeNow" style="color: #ff0400">@lang("content.time_now"):&nbsp;</span><span class="timeNow" id="timeNow" style="color: #ff0400"></span>
            </div>

            {{--@if ( isset($userModules) && isset($module) && $userModules && in_array(41, $userModules[$module->id]))--}}
            <div class="col-xs-12 col-sm-12 col-md-5 col-lg-5" style="margin-bottom: 15px; display: none;">
                @php $opsDateFrom = \request("go_to_date") ? \request("go_to_date") : (\request("start_time") ? date('Y-m-d', strtotime(\request("start_time"))) : date('Y-m-d')) @endphp
                @php $opsDateTo   = \request("go_to_date") ? \request("go_to_date") : (\request("start_time") ? date('Y-m-d', strtotime(\request("start_time"))) : date('Y-m-d')) @endphp

                {!! Form::open(['method' => 'GET', 'url' => URL::to('export/fleetwatch-report'), 'target' => "_blank", 'class' => 'form-inline']) !!}
                    {!! Form::label('reportType', 'Reports', ['class'=>'floatOnly center text-right']) !!}
                    {!! Form::select('reportType', ['ops' => 'OPS'/*, 'crew' => 'Crew'*/], null, ['class' => 'form-control input-sm floatOnly']) !!}
                    {!! Form::label('fromDate', trans("content.from"), ['class'=>'floatOnly center']) !!}
                    {!! Form::text('fromDate', $opsDateFrom, [ 'id' => 'from_date', 'class' => 'form-control input-sm fleetwatch-input-date floatOnly', "required" => "required"]) !!}
                    {!! Form::label('toDate', trans("content.to"), ['class'=>'floatOnly center']) !!}
                    {!! Form::text('toDate', $opsDateTo, [ 'id' => 'to_date', 'class' => 'form-control input-sm fleetwatch-input-date floatOnly', "required" => "required"]) !!}
                    <div class="btn-group">
                        {!! Form::submit('Export', ['type' => 'submit', 'class' => 'btn btn-primary floatOnly']) !!}
                        <a target="_blank" href="{{ route("homepage")."#".url("/report/handling/ops?dateSearch=fromTo&dateFrom={$opsDateFrom}&dateTo={$opsDateTo}") }}" class="btn btn-success btn-sm">View</a>
                    </div>
                {!! Form::close() !!}
            </div>
            {{--@endif--}}
        </div>

        <div id="fleetwatch_message_block" style="clear: both"></div>

        <!-- Fleet watch timeline -->
        <div id="mytimeline" style="min-height: 50px;  min-width: 950px; width: 100%; margin-bottom: 20px;"></div>

        <div class="col-sm-12">

            @foreach($sla as $item)
                <a class="box_item"><span class="box_color {{ $item }}"></span> {{ $item }}</a>
            @endforeach

{{--            <span style="display: none; margin-left: 20px;" id="loading-fleetwatch-form">--}}
{{--                <img width="24" src="{{ asset("/assets/img/2.GIF") }}" alt="Loading..."/> Loading, please wait...--}}
{{--            </span>--}}
        </div>

        <div class="clearfix"></div>

        <hr/>

        <!--------Crew Hours Info Modal------------>
{{--        @include('template/crew-change-process')--}}

        <!-------- Include Flight Form ---------------->
        @include("staff-watch.templates.form")

        <!-- Include Flight modal information window -->
        @include("staff-watch.templates.modal_info")

        <!-- Include Flight maintenance modal window -->
        @include("staff-watch.templates.leave_modal")

    </div>

</div>
<!-- END MAIN PANEL -->
<!-- ==========================CONTENT ENDS HERE ========================== -->



<script type="text/javascript">
    var baseUrl = "{{ url('/') }}";
    var baseDashboardUrl = "{{ url('home/dashboard') }}";
    var baseHomeUrl = "{{ route("homepage") }}";
    var AIRLINE = "{{ env("AIRLINE") }}";
    var CARRIER = "{{ env("CARRIER") }}";
    var CURRENT_IATA_CODE = "{{ env("IATA_CODE") }}";

    var ETD = 'ETD';
    var ATD = 'ATD';
    var ABN = 'ABN';
    var ETA = 'ETA';
    var ATA = 'ATA';
    var TDN = 'TDN';

    var LDS = 'LDS';
    var MVT = 'MVT';
    var CPM = 'CPM';
    var LDM = 'LDM';
    var LPM = 'LPM';
    var PSM = 'PSM';
    var PTM = 'PTM';
    var UCM = 'UCM';
    var TPM = 'TPM';
    var PL = 'PL';
    var PNL = 'PNL';
    var PRL = 'PRL';
    var ADL = 'ADL';
    var NOT = 'NOT';
    var SLS = 'SLS';
    var HBG = 'HBG';
    var LIR = 'LIR';
    var CAL = 'CAL';
    var CREW_LIST = 'CREW LIST';
    var NOTOC = 'NOTOC';
    var OTHS = 'OTHS';
    var ONLOAD = 'ONLOAD';
    var LOADSHEET = "L O A D S H E E T";
    var LOADSHEET_FINAL = "LOADSHEET FINAL";

</script>

<?php
    //include required scripts
    include(public_path("smart/inc/scripts.php"));
?>



        <!-- PAGE RELATED PLUGIN(S)
<script src="..."></script>-->
<link rel="stylesheet" href="{{ asset("/assets/timeline/timeline.css?5") }}" />
<link rel="stylesheet" href="{{ asset("/assets/timeline/timeline-theme.css?5") }}" />
<link rel="stylesheet" href="{{ asset("/packages/ionicons/css/ionicons.min.css") }}" />

<script src="<?php echo asset("/assets/js/vendor/underscore-min.js"); ?>"></script>

<script src="{{ asset("/assets/js/vendor/bootstrap-tooltip.js") }}"></script>
<script type="text/javascript">

    pageSetUp();

    var $airlineModule = {{ $airlineModule ? 1 : 0 }},
        $groupsWidth = "180px",
        $timelinePeriod = 12,
        $userAnyAdmin = {{ userAnyAdmin() }},
        airportId = "{{ \request("airport_id") }}",
        airlineId = "{{ \request("airline_id") }}",
        editable = 1; //isset($userModules) && isset($module) && isset($userModules[$module->id]) && in_array(10,$userModules[$module->id]) ? 1 : 0
        json = {!! $json !!},
        goToDate = '{{ (\request("go_to_date")) ? date('D M d Y H:i:s O', strtotime(\request("go_to_date"))) : false }}',
        startVisibleDate = '{!! (\request("start_time")) ? \request("start_time") : false !!}',
            endVisibleDate = '{!! (\request("end_time")) ? \request("end_time") : false !!}',

        aircraftByAirline = {!! json_encode($aircraftByAirline) !!},
        acTypesByAirline = {!! json_encode($acTypesByAirline) !!},
        flightNumbersObj = {!! json_encode($flightNumbersObj) !!},
        aircraftByType = {!! json_encode($aircraftByType) !!}

    // Tooltip
    $("[data-toggle='tooltip']").popover({ trigger: "hover" });


</script>

<script src="{{ asset("/assets/js/vendor/bootbox.min.js") }}"></script>
<script type="text/javascript" src="https://www.google.com/jsapi"></script>
{{--<script src="{{ asset("/assets/js/vendor/google-jsapi.js") }}"></script>--}}
<script src="{{ asset("/assets/timeline/timeline.js") }}"></script>
<script src="{{ asset("/assets/js/views/staff-watch/timeline.js?10") }}"></script>
{{--<script src="{{ asset("/assets/js/vendor/jquery.bpopup.min.js") }}"></script>--}}
<script src="{{ asset("/assets/js/vendor/jquery.datetimepicker.js") }}"></script>
<script src="{{ asset("/assets/js/vendor/select-sync-mine.js") }}"></script>
<script src="{{ asset("/assets/js/views/staff-watch/form.js?10") }}"></script>

<script type="text/javascript">

    runAllForms();

    ApplySpecificFormSubmit($(document).find("#formParseMessages"));
//    ApplySpecificFormSubmit($(document).find("#formMVTDeparture"));
//    ApplyFormInputSubmit("#formMVTArrival");

    ApplyTableFilter("#tableFltDepartures");
    ApplyTableFilter("#tableFltArrivals");
    ApplyTableFilter("#tableFltAll");

    ApplyTableFilter("#flightMessages");
    {{--ApplyTableFilter("#fltTod");--}}
    {{--ApplyTableFilter("#fltTom");--}}

</script>

<?php
//include footer
//include(public_path("smart/inc/google-analytics.php"));
?>
