@if ($showLogo)
    <?php

    //initialize the page
    require_once(public_path("smart/inc/init.php"));

    //require UI configuration (nav, ribbon, etc.)
    require_once(public_path("smart/inc/config.ui.php"));

    include_once(public_path("smart/inc/user_variables.php"));


    /*---------------- PHP Custom Scripts ---------

    YOU CAN SET CONFIGURATION VARIABLES HERE BEFORE IT GOES TO NAV, RIBBON, ETC.
    E.G. $page_title = "Custom Title" */

    $page_title = trans("modules.staff_roster");

    /* ---------------- END PHP Custom Scripts ------------- */

    //include header
    //you can add your custom css in $page_css array.
    //Note: all css files are inside css/ folder
    $page_css[] = "your_style.css";

    $no_main_header = true;

    $page_body_prop = array("id"=>"extr-page", "class"=>"animated fadeInDown");

    include(public_path("smart/inc/header.php"));

    ?>

    <!-- ==========================CONTENT STARTS HERE ========================== -->
    <!-- possible classes: minified, no-right-panel, fixed-ribbon, fixed-header, fixed-width-->

    <style>
        body{
            background-color: #FFFFff;
        }
        #mytimeline .ui-widget-content {
            background: #FFF;
        }
        .timeline-groups-axis.timeline-groups-axis-onleft{
            width: 150px !important;
        }
    </style>

    <header id="header" style="background-color: #ffffff !important; height: auto">
        <div id="logo-group" style="{{ $div_external_page }}">
            <span> <img style="{{ $logo_external_page }}" src="{{ $logo }}"  alt=""> </span>
            <h2 style="{{ $logo_text_external_page }}">{{ $logo_text }}</h2>
        </div>
    </header>
    <div class="clearfix"></div>

    <div id="main" role="main" class="padding-0">
        <div id="content" class="">

    <!-- MAIN CONTENT -->
@endif

    <!-- widget grid -->
    <section id="widget-grid" class="">
        <!-- row -->
        <div class="row">

            <article class="col-sm-12 col-md-12 col-lg-12">

                <ul id="tab" class="nav nav-tabs bordered">
                    <li class="{{ (\request("generate") || !(\request("load") || \request("publish"))) ? "active" : "" }}">
                        <a href="#roster" role="tab" data-toggle="tab">@lang("content.roster")</a>
                    </li>
                    <li class="{{ (\request("leaves") || \request("leaves")) ? "active" : "" }}">
                        <a href="#leaves" role="tab" data-toggle="tab">@lang("content.trainings_and_office_duties")</a>
                    </li>
                    <li class="{{ (\request("load") || \request("load")) ? "active" : "" }}">
                        <a href="#load" role="tab" data-toggle="tab">@lang("content.load_and_publish")</a>
                    </li>
                </ul>

                <div id="tabContent" class="tab-content padding-10 background-white">

                    <div class="tab-pane {{ (\request("generate") || !(\request("load") || \request("publish"))) ? "active" : "" }}" id="roster">

                        @include('staff-roster.index-layouts.index-roster-tab')

                    </div>

                    <div class="tab-pane {{ (\request("leaves") || \request("leaves")) ? "active" : "" }}" id="leaves">

                        @include('staff-roster.index-layouts.index-leaves-tab')

                    </div>

                    <div class="tab-pane {{ (\request("load") || \request("load")) ? "active" : "" }}" id="load">

                        @include('staff-roster.index-layouts.index-load-tab')

                    </div>

                </div>

            </article>

        </div>

    </section>

@if ($showLogo)
        </div>
    </div>

   <script type="text/javascript">
        var baseUrl = "{{ url('/') }}";
        var baseDashboardUrl = "{{ url('home/dashboard') }}";
        var baseHomeUrl = "{{ route("homepage") }}";
        var AIRLINE = "{{ env("AIRLINE") }}";
        var CARRIER = "{{ env("CARRIER") }}";
        var CURRENT_IATA_CODE = "{{ env("IATA_CODE") }}";
    </script>

    <?php include(public_path("smart/inc/scripts.php")); ?>


    <!-- PAGE RELATED PLUGIN(S)
    <script src="..."></script>-->
    {{--<link rel="stylesheet" href="{{ asset("/assets/timeline/timeline.css?5") }}" />--}}
    {{--<link rel="stylesheet" href="{{ asset("/assets/timeline/timeline-theme.css?5") }}" />--}}
    {{--<link rel="stylesheet" href="{{ asset("/packages/ionicons/css/ionicons.min.css") }}" />--}}
    <link rel="stylesheet" href="{{ asset("/assets/css/chart.min.css") }}">

    <style>
        div.timeline-axis {
            border-color: #496a4a !important;
            background: #496a4a;
            color: white !important;
        }

    </style>

    {{--<script src="{{ asset("/assets/js/vendor/underscore-min.js") }}"></script>--}}
@endif

<script type="text/javascript">

    pageSetUp();

    var staffTable =  $(document).find("#staffTable"),
        flightTable =  $(document).find("#flightTable"),
        fromDate =  $(document).find("#from_date"),
        toDate =  $(document).find("#to_date"),
        assignedDate = $(document).find("#assigned_date");

    var DEPARTURE_SERVICE = "departure_service",
        ARRIVAL_SERVICE = "arrival_service",
        TURNAROUND_SERVICE = "turnaround_service"
    ;

    var generateBtn = $(document).find("input[name=generate]"),
        saveBtn = $(document).find("input[name=save]"),
        loadBtn = $(document).find("input[name=load]"),
        publishBtn = $(document).find("input[name=publish]");

    var flightsData, selectedDate, selectedAirport, selectedAirline;
    var rosterID = {!! $roster ? $roster->id : 0 !!}, assignedStaff = {!! $roster && $roster->assignedStaff ? 1 : 0 !!};
    var servicesByFlight = {!! $servicesByFlight ? json_encode($servicesByFlight) : 0 !!};
    var rosterFrom = "{{ $dateFrom }}", rosterTo = "{{ $dateTo }}";

    var json = [];
    var startVisibleDate = '{!! (\request("start_time")) ? \request("start_time") : false !!}',
        endVisibleDate = '{!! (\request("end_time")) ? \request("end_time") : false !!}';

    var MAX_HOURS_FOR_MOVE = 24,
        EMPTY_DATE = "0000-00-00",
        EMPTY_TIME = "00:00:00",
        EMPTY_DATETIME = "0000-00-00 00:00:00",
        timeline = null,
        inputDateFormat = "YYYY-MM-DD HH:mm:ss",
        outputDateOnlyFormat = "MMM DD",
        outputDateFormat = "MMM DD, HH:mm",
        outputTimeFormat = "HH:mm",
        popupFlight = null;

    // Tooltip
    $("[data-toggle='tooltip']").popover({ trigger: "hover" });

</script>

{{--<script src="{{ asset("/assets/js/vendor/bootbox.min.js") }}"></script>--}}
{{--<script src="{{ asset("/assets/js/vendor/google-jsapi.js?2") }}"></script>--}}
{{--<script src="{{ asset("/assets/timeline/timeline.js") }}"></script>--}}
<script src="{{ asset("/assets/js/views/staff-roster/index.js?14") }}"></script>
{{--<script src="{{ asset("/assets/js/vendor/jquery.datetimepicker.js") }}"></script>--}}
{{--<script src="{{ asset("/assets/js/vendor/select-sync-mine.js") }}"></script>--}}
<script src="{{ asset("/assets/js/chart.bundle.min.js") }}"></script>

{{--<script src="{{ asset("/assets/timeline/timeline.js") }}"></script>--}}
<script type="text/javascript" src="{{ asset("/assets/chart/google/loader.js") }}"></script>

<script type="text/javascript">
    runAllForms();

    // ApplySpecificFormSubmit($(document).find("#formParseMessages"));
    // ApplyTableFilter("#flightMessages");

    // Generate And Save
    ApplySubmitEvent(generateBtn);
    ApplySubmitEvent(saveBtn);

    // Load And Publish
    ApplySubmitEvent(loadBtn);
    ApplySubmitEvent(publishBtn);

    // ApplyTableFilter("#table1");
    ApplyValidationDateFormats();

    Apply_Multiselect();

    ApplySpecificFormSubmit($(".leaves-form"));

    assignedDate.val(fromDate.val());


    @if (isset($staffCharts) && $staffCharts && count($staffCharts))
        json = {!! json_encode($staffCharts) !!};
        var start_time = moment(rosterFrom + " 00:00:00").format("YYYY-MM-DD HH:mm:ss"),
            end_time = moment(rosterTo + " 23:59:59").format("YYYY-MM-DD HH:mm:ss");

        var start = new Date(
            moment(start_time).get('year'),
            moment(start_time).get('month'),
            moment(start_time).get('date'),
            moment(start_time).get('hour'),
            moment(start_time).get('minute'),
            moment(start_time).get('second')
        );

        var end = new Date(
            moment(end_time).get('year'),
            moment(end_time).get('month'),
            moment(end_time).get('date'),
            moment(end_time).get('hour'),
            moment(end_time).get('minute'),
            moment(end_time).get('second')
        );

        google.charts.load("current", {packages:["timeline"]});
        google.charts.setOnLoadCallback(drawChart);
    @endif

    function drawChart() {
        var container = document.getElementById('staffChart');
        var chart = new google.visualization.Timeline(container);

        var dataTable = new google.visualization.DataTable();
        dataTable.addColumn({ type: 'string', id: 'Staff' });
        dataTable.addColumn({ type: 'string', id: 'SLA' });
        dataTable.addColumn({ type: 'date', id: 'Start' });
        dataTable.addColumn({ type: 'date', id: 'End' });

        dataTable.addRows(prepareDataForTimeline(json));

        /*
        var options = {
            //start: start_time,
            //end: end_time,
            // dragAreaWidth: 10,
            min: start,
            max: end,     // upper limit of visible range
            zoomable: true,
            zoomMin: 1000 * 60 * 60 * 24,     // 4 hours in milliseconds
            zoomMax: 1000 * 60 * 60 * 24,     // 7 days in milliseconds
            width: "100%",
        };

        var options = {
            colors: ['#cbb69d', '#603913', '#c69c6e'],
            timeline: { rowLabelStyle: { fontName: 'Helvetica', fontSize: 24, color: '#603913' },
                barLabelStyle: { fontName: 'Garamond', fontSize: 14 } }
        };
         */
        // chart.draw(dataTable, options);
        // chart.setVisibleChartRange(start_time, end_time);

        chart.draw(dataTable);
    }

    function prepareDataForTimeline(json, object) {
        var data = [];
        if (json.length) {
            var item, start_date, end_date;
            for (var i = 0, l = json.length; i < l; i++) {
                item = json[i];
                start_date = item.start_date;
                end_date = item.end_date;

                if (object) {
                    data.push({
                        "start": new Date(start_date[0], start_date[1], start_date[2], start_date[3], start_date[4], start_date[5]),
                        "end": new Date(end_date[0], end_date[1], end_date[2], end_date[3], end_date[4], end_date[5]),
                        "content": item.content,
                        "group": item.group,
                        "className": item.className
                    });
                }
                else {
                    data.push([
                        item.group,
                        item.content,
                        // item.className
                        new Date(start_date[0], start_date[1], start_date[2], start_date[3], start_date[4], start_date[5]),
                        new Date(end_date[0], end_date[1], end_date[2], end_date[3], end_date[4], end_date[5]),
                    ]);
                }
            }
        }
        return data;
    }

    //     try {
    //         google.load("visualization", "1");
    //     }
    //     catch (e) { console.log(e.message); }
    //     google.setOnLoadCallback(drawVisualization);

    // var pagefunction = function () {
    {{--        @if (isset($staffCharts) && $staffCharts)--}}
    {{--            var rosterFrom = "{{ $from }}", rosterTo = "{{ $to }}";--}}
    {{--            json = {!! json_encode($staffCharts) !!};--}}
    //             var start_time = moment(rosterFrom + " 00:00:00").format("YYYY-MM-DD HH:mm:ss"),
    //                 end_time = moment(rosterTo + " 23:59:59").format("YYYY-MM-DD HH:mm:ss");
    //             drawVisualization(json, start_time, end_time);
    {{--        @endif--}}
    //     };
    //     pagefunction();
    // var chart = new ApexCharts(document.querySelector("#apexchart"), options);
    // chart.render();

    @if (isset($charts) && $charts && count($charts))
        @foreach($charts["charts"] as $date => $each)
            dailyChartMultiple('line', 'SLA', "chartSLA_" + "{{ $date }}", "rgba(10,60,100,0.5)", {!! json_encode($each) !!}, 10);
        @endforeach
    @endif
</script>
