
<div class="jarviswidget jarviswidget-color-blueDark" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

    <header>
        <span class="widget-icon"> <i class="fa fa-table"></i> </span>

        <h2>@lang("content.staff_list")</h2>
    </header>

    <!-- widget div-->
    <div>
        <!-- widget edit box -->
        <div class="jarviswidget-editbox">
            <!-- This area used as dropdown edit box -->

        </div>
        <!-- end widget edit box -->

        <!-- widget content -->
        <div class="widget-body no-padding" style="min-height: 50px !important;">

            <div class="table-responsive">

                <table class="table table-bordered table-hover" id="table1">

                    <thead>
                    <tr>
                        <th data-center>No</th>
                        <th data-center>@lang("content.details")</th>
                        <th data-center>@lang("content.roster")</th>
                    </tr>
                    </thead>

                    <tbody>
                        <?php /** @var \App\Classes\Staff\Roster\Roster $roster */ ?>
                        @if ($roster->getStaffList())
                            <?php
                            foreach ($roster->getStaffList() as $i => $staff) { ?>

                            @php $weekly = $staff->getValidation()->getMaxWeeklyHours() @endphp
                            @php $monthly = $staff->getValidation()->getMaxMonthlyHours() @endphp
                            @php $actual = $staff->getTotalShiftHours() @endphp

                            @php $shifts = $staff->getShiftCount() @endphp
                            @php $monthlyAcc = $staff->getValidation()->getMonthlyLimitAccomplishment(true) @endphp

                            <tr data-type="staff-list" data-id="{{ $staff->getStation()->id }}">

                                <td class="vertical-center">{{ $i + 1 }}</td>

                                <td class="">
                                    <div class="col-md-12 no-padding">

                                        <div class="col-md-3">
                                            @php $labelClass = $staff->differentLocation ? "label-assigned" : "label-warning" @endphp
                                            <span class="label {{ $labelClass }} font-sm center-block">{{ $staff->getStation()->iata }}</span>
                                        </div>

                                        <p class="col-md-9 staff-roster-body">
                                            <a target="_blank" href="{{ route("homepage")."#".url("staff/{$staff->getUser()->id}/edit") }}">
                                                {{ /* @var \App\Classes\Staff\Roster\Staff\Staff $staff */ $staff->getUser()->first_name ." ". $staff->getUser()->last_name }}
{{--                                                @if ($staff->differentLocation)--}}
{{--                                                    <span class="label label-assigned font-sm margin-left-10">ASSIGNED</span>--}}
{{--                                                @endif--}}
                                            </a>
                                        </p>

                                    </div>

                                    <div class="col-md-12 no-padding">

                                        <div class="col-md-3">

                                            <img style="width: 100%" src="{{ asset("/assets/img/default-user-picture.png") }}"/>

                                        </div>

                                        <div class="col-md-9 no-padding">

                                            <div class="col-md-12 no-padding">
                                                <p class="col-md-4 staff-roster-title">
                                                    @lang("content.max_weekly"):
                                                </p>

                                                <p class="col-md-4 staff-roster-title">
                                                    @lang("content.max_monthly"):
                                                </p>

                                                <p class="col-md-4 staff-roster-title">
                                                    @lang("content.actual"):
                                                </p>
                                            </div>

                                            <div class="col-md-12 no-padding">
                                                <p class="col-md-4 staff-roster-body">
                                                    {{ hoursToTime($weekly, true) }}
                                                </p>

                                                <p class="col-md-4 staff-roster-body">
                                                    {{ hoursToTime($monthly, true) }}
                                                </p>

                                                <p class="col-md-4 staff-roster-body">
                                                    {{ hoursToTime($actual, true) }}
                                                </p>
                                            </div>

                                            <div class="col-md-12 no-padding">
                                                <p class="col-md-4 staff-roster-title">
                                                    @lang("content.shifts"):
                                                </p>

                                                <p class="col-md-6 staff-roster-title">
                                                    @lang("content.monthly_progress"):
                                                <p class="col-md-2 staff-roster-body">{{ $monthlyAcc }}%</p>
                                                </p>
                                            </div>

                                            <div class="col-md-12 no-padding">
                                                <p class="col-md-4 staff-roster-body">
                                                    {{ $shifts }}
                                                </p>

                                                @php $statusClass = accomplishmentStatus($monthlyAcc) @endphp
                                                <div class="col-md-8">
                                                    <div class="progress no-padding no-margin">
                                                        @php $showAcc = $monthlyAcc >= 15 ? $monthlyAcc."%" : "" @endphp
                                                        <div class="progress-bar {{ $statusClass }}" aria-valuetransitiongoal="{{ $monthlyAcc }}" aria-valuenow="{{ $monthlyAcc }}" style="width: {{ $monthlyAcc }}%;">{{ $showAcc }}</div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                </td>

                                <td style="width: 60%" class="no-padding">
                                    @if (!$shifts)
                                        <div class="alert alert-warning alert-block vertical-center" style="margin: 10px;">
                                            <a class="close" data-dismiss="alert" href="#">x</a>
                                            <h4 class="alert-heading">@lang("content.info")</h4>
                                            @lang("content.staff_has_not_been_rostered_please_check_settings")
                                        </div>
                                    @else
                                        <div class="col-md-12 no-padding">
                                            @include("staff-roster.index-layouts.roster-tab.shifts")
                                        </div>
                                    @endif
                                </td>
                            <?php } ?>
                        @endif
                    </tbody>

                </table>

            </div>

        </div>

    </div>

</div>
