
<table class="table table-bordered table-hover">
<thead>
<tr>
    <th rowspan="2" style="width: 6%; " data-center>No</th>
    <th rowspan="2" style="width: 8%;" data-center>@lang("content.shift")</th>
    <th rowspan="2" style="width: 16%;" data-center>@lang("content.start_time")</th>
    <th rowspan="2" style="width: 16%;" data-center>@lang("content.end_time")</th>
    <th rowspan="2" style="width: 11%;" data-center>@lang("content.duration")</th>
    <th rowspan="2" style="width: 13%;" data-center>@lang("content.rest_time")</th>
    <th colspan="3" style="width: 30%;" data-center>@lang("content.settings")(@lang("content.hrs"))</th>
</tr>
<tr>
    <th style="width: 8%" data-center>@lang("content.max")</th>
    <th style="width: 8%" data-center>@lang("content.min")</th>
    <th style="width: 14%" data-center>@lang("content.min_rest_time")</th>
</tr>
</thead>
</table>

{{--<div class="panel-group smart-accordion-default" id="accordion-shifts">--}}


    <?php /* @var \App\Classes\Staff\Roster\Staff\Staff $staff */
    foreach ($staff->getShiftsList() as $j => $shift) {  ?>

        @php $max = $shift->getValidation()->getMaxHours() @endphp
        @php $min = $shift->getValidation()->getMinHours() @endphp
        @php $act = $shift->getDuration(true) @endphp
        @php $shiftClass = shiftValidationClass($max, $min, $act) @endphp
        @php $shiftTypeClass = $shift->getType() == "Day" ? "primary" : "danger" @endphp

        <div class="panel panel-default" style="margin-bottom: 0 ;border-top: 0; {{ $j + 1 == $shifts ? "border-bottom: 0;" : ""}} border-right: 0; border-left: 0;">

            <div class="panel-heading" style="height: 40px; padding: 10px 0;">
                <a data-toggle="collapse" href="#shift-{{ $i ."-". $j }}"> {{--data-parent="#accordion-shifts">--}}
                    <div class="col-md-12 table-container">
                        <div class="tr {{ $shiftClass }}">
                            <div class="td" style="width: 6%;" data-center>{{ $j + 1 }}</div>
                            <div class="td" style="width: 8%;" data-center>
                                <span class="label label-{{ $shiftTypeClass }} font-sm">{{ /* @var \App\Classes\Staff\Roster\Shift\Shift $shift */ $shift->getType() }}</span>
                            </div>
                            <div class="td" style="width: 16%;" data-center>{{ /* @var \App\Classes\Staff\Roster\Shift\Shift $shift */ baseDateFormat($shift->getStartTimeTimezone(), true, "-") }}</div>
                            <div class="td" style="width: 16%;" data-center>{{ /* @var \App\Classes\Staff\Roster\Shift\Shift $shift */ baseDateFormat($shift->getEndTimeTimezone(), true, "-") }}</div>
                            <div class="td" style="width: 11%;" data-center>{{ hoursToTime($act, true) }}</div>
                            <div class="td" style="width: 13%;" data-center>{{ /* @var \App\Classes\Staff\Roster\Shift\Shift $shift */ $shift->getActualRestTime() ? hoursToTime($shift->getActualRestTime(), true) : "" }}</div>

                            <div class="td" style="width: 8%;" data-center>{{ hoursToTime($max, true) }}</div>
                            <div class="td" style="width: 8%;" data-center>{{ hoursToTime($min, true) }}</div>
                            <div class="td" style="width: 14%;" data-center>{{ /* @var \App\Classes\Staff\Roster\Shift\Shift $shift */ hoursToTime($shift->getValidation()->getMinRestTime(), true) }}</div>
                        </div>
                    </div>
                </a>
            </div>

            <div id="shift-{{ $i ."-". $j }}" class="panel-collapse collapse">
                <div class="panel-body" style="padding: 0;">
                    <div class="col-md-12 table-container">
                    <?php /* @var \App\Classes\Staff\Roster\Shift\Shift $shift */
                    foreach ($shift->getJobsList() as $k => $job) {  ?>
                        @if ($k == 0)
                            <div class="tr-2">
                                <div class="th" style="width: 6%; " data-center>No</div>
                                <div class="th" style="width: 10%;" data-center>@lang("content.flight_number")</div>
                                <div class="th" style="width: 8%;" data-center>@lang("content.sector")</div>
                                <div class="th" style="width: 22%;" data-center>@lang("content.departure_arrival")</div>
                                <div class="th" style="width: 11%;" data-center>@lang("content.service")</div>
                                <div class="th" style="width: 13%;" data-center>@lang("content.report_time")</div>
                                <div class="th" style="width: 16%;" data-center>@lang("content.release_time")</div>
                                <div class="th" style="width: 7%;"  data-center>@lang("content.duration")</div>
                                <div class="th" style="width: 7%;"  data-center>@lang("content.rest_time")</div>
                            </div>
                        @endif
                        @php $addClass = $job->staffType == ASSIGNED_TYPE ? "bg-assigned" : ($job->staffType == MANUALLY_ROSTERED_TYPE ? "bg-manually-rostered" : "") @endphp
                        <div class="tr-2 {{ $shiftClass }} {{ $addClass }}">

                            <div class="td-2" style="width: 6%;" data-center>{{ /* @var \App\Classes\Staff\Roster\Shift\Job $job */ ($k + 1) }}</div>
                            <div class="td-2" style="width: 10%;" data-center>{{ /* @var \App\Classes\Staff\Roster\Shift\Job $job */ $job->getFlightNumber() }}</div>
                            <div class="td-2" style="width: 8%;" data-center>{{ /* @var \App\Classes\Staff\Roster\Shift\Job $job */ $job->getSector() }}</div>
                            <div class="td-2" style="width: 15%; padding: 0;" data-center>
                                @if ($job->getFlightHandler())
                                    @if ($job->getFlightHandler()->getServiceType() == "Departure Service")
                                        {{  baseDateFormat($job->getFlightHandler()->getFlightDepartureTimeTimezone(), true, "-")}}
                                    @else
                                        {{ baseDateFormat($job->getFlightHandler()->getFlightArrivalTimeTimezone(), true, "-") }}
                                    @endif
                                @endif
                                <span style="display: inline; margin-left: 10px;" class="label label-success font-sm center-block">
                                    @if ($job->getFlightHandler())
                                        @if ($job->getFlightHandler()->getServiceType() == "Departure Service")
                                            {{ $job->getFlightHandler()->getFlightDepartureTimeType() }}
                                        @else
                                            {{ $job->getFlightHandler()->getFlightArrivalTimeType() }}
                                        @endif
                                    @endif
                                </span>
                            </div>
                            <div class="td-2" style="width: 11%;" data-center>{{ /* @var \App\Classes\Staff\Roster\Shift\Job $job */ $job->getServiceName() }}</div>
                            <div class="td-2" style="width: 13%;" data-center>{{ /* @var \App\Classes\Staff\Roster\Shift\Job $job */ baseDateFormat($job->getReportTimeTimezone(), true, "-") }}</div>
                            <div class="td-2" style="width: 16%;" data-center>{{ /* @var \App\Classes\Staff\Roster\Shift\Job $job */ baseDateFormat($job->getReleaseTimeTimezone(), true, "-") }}</div>
                            <div class="td-2" style="width: 7%;"  data-center>{{  /* @var \App\Classes\Staff\Roster\Shift\Job $job */ hoursToTime($job->getDuration(true), true) }}</div>
                            <div class="td-2" style="width: 7%;"  data-center>{{  /* @var \App\Classes\Staff\Roster\Shift\Job $job */ $job->getBreakTime() ? hoursToTime($job->getBreakTime(), true) : "" }}</div>
                        </div>
                    <?php } ?>
                    </div>
                </div>
            </div>

        </div>
    <?php } ?>
{{--</div>--}}

