<table class="table table-bordered table-hover">
    <thead>
    <tr>
        <th rowspan="2" style="width: 7%; " data-center>No</th>
        <th rowspan="2" style="width: 15%;" data-center>@lang("content.service")</th>
        <th rowspan="2" style="width: 18%;" data-center>@lang("content.report_time")</th>
        <th rowspan="2" style="width: 18%;" data-center>@lang("content.release_time")</th>
        <th rowspan="2" style="width: 12%;" data-center>@lang("content.duration") (@lang("content.mins"))</th>
        <th colspan="3" style="width: 30%;" data-center>@lang("content.staff")</th>
    </tr>
    <tr>
        <th style="width: 10%" data-center>@lang("content.req")</th>
        <th style="width: 10%" data-center>@lang("content.min")</th>
        <th style="width: 10%" data-center>@lang("content.act")</th>
    </tr>
    </thead>
</table>

    @php $serviceCount = count($flightHandler->getServiceList()) @endphp
    <?php /* @var \App\Classes\Staff\Roster\FlightHandler $flightHandler */
    foreach ($flightHandler->getServiceList() as $j => $service) { ?>
        @php $req = $service->getStaffReq() @endphp
        @php $min = $service->getStaffMin() @endphp
        @php $act = $service->getStaffActual() @endphp
        @php $staffClass = staffRequirementClass($req, $min, $act, true) @endphp

        @if (!$service->getDuration() || !$req)
            @continue
        @endif

        <div class="panel panel-default" style="margin-bottom: 0 ;border-top: 0; {{ $j + 1 == $serviceCount ? "border-bottom: 0;" : ""}} border-right: 0; border-left: 0;">

            <div class="panel-heading {{ $staffClass }}" style="height: 40px; padding: 10px 0;">
                <a data-toggle="collapse" href="#service-{{ $i ."-". $j }}"> {{--data-parent="#accordion-shifts">--}}
                    <div class="col-md-12 table-container">
                        <div class="tr">
                            <div class="td" style="width: 7%" data-center>{{ $j + 1 }}</div>
                            <div class="td" style="width: 15%" data-center>{{ /* @var \App\Classes\Staff\Roster\ServiceTypes\Service $service */ $service->getServiceName() }}</div>
                            <div class="td" style="width: 18%" data-center>{{ /* @var \App\Classes\Staff\Roster\ServiceTypes\Service $service */ baseDateFormat($service->getReportTimeTimezone(), true, "-") }}</div>
                            <div class="td" style="width: 18%" data-center>{{ /* @var \App\Classes\Staff\Roster\ServiceTypes\Service $service */ baseDateFormat($service->getReleaseTimeTimezone(), true, "-") }}</div>
                            <div class="td" style="width: 12%" data-center>{{ /* @var \App\Classes\Staff\Roster\ServiceTypes\Service $service */ $service->getDuration() }}</div>

                            <div class="td" style="width: 10%" data-center>{{ $req }}</div>
                            <div class="td" style="width: 10%" data-center>{{ $min }}</div>
                            <div class="td" style="width: 10%" data-center>{{ $act }}</div>
                        </div>
                    </div>
                </a>
            </div>

            @if (count($service->getJobsList()))
                <div id="service-{{ $i ."-". $j }}" class="panel-collapse collapse">
                    <div class="panel-body" style="padding: 0;">
                        <div class="col-md-12 table-container">
                        <?php /* @var \App\Classes\Staff\Roster\ServiceTypes\Service $service */
                        foreach ($service->getJobsList() as $k => $job) {  ?>
                            @if ($k == 0)
                                <div class="tr-2">
                                    <div class="th" style="width: 7%; " data-center>No</div>
                                    <div class="th" style="width: 33%;" data-center>@lang("content.staff_details")</div>
                                    <div class="th" style="width: 18%;" data-center>@lang("content.report_time")</div>
                                    <div class="th" style="width: 18%;" data-center>@lang("content.release_time")</div>
                                    <div class="th" style="width: 14%;"  data-center>@lang("content.duration")</div>
                                    <div class="th" style="width: 10%;"  data-center>@lang("content.rest_time")</div>
                                </div>
                            @endif

                            @php $addClass = $job->staffType == ASSIGNED_TYPE ? "bg-assigned" : ($job->staffType == MANUALLY_ROSTERED_TYPE ? "bg-manually-rostered" : "") @endphp
                            <div class="tr-2 {{ $addClass }}">
                                @php $user = $job->getShift()->getStaff()->getUser() @endphp
                                <div class="td-2" style="width: 7%;" data-center>{{ ($k + 1) }}</div>
                                <div class="td-2" style="width: 33%;">
                                    <a target="_blank" href="{{ route("homepage")."#". url("/staff/{$user->id}/edit") }}">
                                        <span class="label label-warning font-xs">{{ $job->getShift()->getStaff()->getStation()->iata }}</span>
                                        {{ /* @var \App\Models\User $user */ $user->first_name." ".$user->last_name }}

                                        @if ($job->staffType == ASSIGNED_TYPE)
                                            <span class="label label-assigned font-xs">ASSIGNED</span>
                                        @elseif ($job->staffType == MANUALLY_ROSTERED_TYPE)
                                            <span class="label label-manually-rostered font-xs">MANUALLY ROSTERED</span>
                                        @endif
                                    </a>
                                </div>
                                <div class="td-2" style="width: 18%;" data-center>{{ /* @var \App\Classes\Staff\Roster\Shift\Job $job */ baseDateFormat($job->getReportTimeTimezone(), true, "-") }}</div>
                                <div class="td-2" style="width: 18%;" data-center>{{ /* @var \App\Classes\Staff\Roster\Shift\Job $job */ baseDateFormat($job->getReleaseTimeTimezone(), true, "-") }}</div>
                                <div class="td-2" style="width: 14%;"  data-center>{{  /* @var \App\Classes\Staff\Roster\Shift\Job $job */ hoursToTime($job->getDuration(true), true) }}</div>
                                <div class="td-2" style="width: 10%;"  data-center>{{  /* @var \App\Classes\Staff\Roster\Shift\Job $job */ $job->getBreakTime() ? hoursToTime($job->getBreakTime(), true) : "" }}</div>
                            </div>
                        <?php } ?>
                        </div>
                    </div>
                </div>
            @endif

        </div>
    <?php } ?>
{{--</div>--}}

