<div class="jarviswidget jarviswidget-color-blueDark" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

    <header>
        <span class="widget-icon"> <i class="fa fa-table"></i> </span>

        <h2>@lang("content.flights_list")</h2>
    </header>

    <!-- widget div-->
    <div>
        <!-- widget edit box -->
        <div class="jarviswidget-editbox">
            <!-- This area used as dropdown edit box -->

        </div>
        <!-- end widget edit box -->

        <!-- widget content -->
        <div class="widget-body no-padding" style="min-height: 50px !important;">

            <div class="table-responsive">

                <table class="table table-bordered table-hover">

                    <thead>
                    <tr>
                        <th data-center>No</th>
                        <th data-center>@lang("content.details")</th>
                        <th data-center>@lang("content.services")</th>
                    </tr>
                    </thead>

                    <tbody>
                    @if ($roster->getStaffList())
                        <?php /* @var \App\Classes\Staff\Roster\Roster $roster */
                        foreach ($roster->getFlightHandlers() as $i => $flightHandler) { ?>
                            @if (!count($flightHandler->getServiceList()))
                                @continue
                            @endif

                            @php $serviceType = $flightHandler->getServiceType() @endphp
                            @php $servicePicture = $serviceType == "Departure Service" ? asset("/assets/img/departures.png") : asset("/assets/img/arrivals.png") @endphp

                            @php $airline = $flightHandler->getAirline() @endphp
                            @php $logo = $airline && $airline->picture ? asset("storage/airlines/img/{$airline->picture}") : asset("/assets/img/default-airline-picture.png") @endphp
                            @php $tdClass = count($flightHandler->getServiceList()) ? "" : "bg-warning" @endphp

                            @php $req = $flightHandler->getStaffReq() @endphp
                            @php $min = $flightHandler->getStaffMin() @endphp
                            @php $act = $flightHandler->getStaffAct() @endphp
                            @php $staffClass = staffRequirementClass($req, $min, $act) @endphp
                            @php $staffMessage = staffRequirementMessage($req, $min, $act) @endphp

                            <tr data-type="flight-list" data-id="{{ $flightHandler->getStation()->id }}">

                                <td class="{{ $tdClass }} vertical-center">{{ $i + 1 }}</td>

                                <td class="{{ $tdClass }}">

                                    <div class="col-md-3 padding-0">

                                        <div class="col-md-12 margin-bottom-10">
                                            <img style="width: 100%" src="{{ $logo }}"/>
                                        </div>

                                        <p class="col-md-12 staff-roster-body">
                                            {{ /* @var \App\Classes\Staff\Roster\FlightHandler $flightHandler */ getAirlineCode($airline)."-".$flightHandler->getFlightNumber()->flight_number }}
                                        </p>

                                        <p class="col-md-12 staff-roster-body">
                                            {{ /* @var \App\Classes\Staff\Roster\FlightHandler $flightHandler */  $flightHandler->getSector() }}
                                        </p>

                                        <div class="col-md-12 margin-bottom-10">
                                            <img style="width: 40%" src="{{ $servicePicture }}"/>
                                        </div>

                                        <div class="col-md-12">
                                            {!! $staffMessage !!}
                                        </div>

                                        @if ($flightHandler->staffType == ASSIGNED_TYPE)
                                            <div class="col-md-12 margin-top-10">
                                                <span class="label label-assigned font-sm center-block">ASSIGNED</span>
                                            </div>
{{--                                        @elseif ($flightHandler->staffType == MANUALLY_ROSTERED_TYPE)--}}
{{--                                            <div class="col-md-12 margin-top-10">--}}
{{--                                                <span class="label label-assigned font-sm center-block">MANUALLY ROSTERED</span>--}}
{{--                                            </div>--}}
                                        @endif
                                    </div>

                                    <div class="col-md-9">

                                        <div class="col-md-12">
                                            <p class="col-md-5 staff-roster-title">
                                                @lang("content.station"):
                                            </p>

                                            <div class="col-md-7 padding-0">
                                                <span class="label label-warning font-sm center-block">{{ $flightHandler->getStation()->iata }}</span>
                                            </div>

                                        </div>

                                        @php $serviceTypeClass = $flightHandler->getServiceType() == "Departure Service" ? "success" : "primary" @endphp

                                        <div class="col-md-12">
                                            <p class="col-md-5 staff-roster-title">
                                                @lang("content.service_type"):
                                            </p>

                                            <div class="col-md-7 padding-0">
                                                <span class="label label-{{ $serviceTypeClass }} font-sm center-block">{{ /* @var \App\Classes\Staff\Roster\FlightHandler $flightHandler */ displayService($flightHandler->getServiceType()) }}</span>
                                            </div>

                                        </div>

                                        @if ($serviceType == "Departure Service")
                                            <div class="col-md-12">
                                                <p class="col-md-5 staff-roster-title">
                                                    STD/PTD:
                                                </p>

                                                <p class="col-md-7 staff-roster-body padding-0">
                                                    <span class="label label-primary">{{ /* @var \App\Classes\Staff\Roster\FlightHandler $flightHandler */ $flightHandler->getFlightDepartureTimeType() }}</span>
                                                    <span class="same-20 margin-left-5">{{ /* @var \App\Classes\Staff\Roster\FlightHandler $flightHandler */ baseDateFormat($flightHandler->getFlightDepartureTimeTimezone(), true, "-") }}</span>
                                                </p>
                                            </div>
                                            @if ($flightHandler->getFlightDepartureTimeActual())
                                                <div class="col-md-12">
                                                    <p class="col-md-5 staff-roster-title">
                                                        ETD/ATD:
                                                    </p>

                                                    <p class="col-md-7 staff-roster-body padding-0">
                                                        <span class="label label-warning">{{ /* @var \App\Classes\Staff\Roster\FlightHandler $flightHandler */ $flightHandler->getFlightDepartureTimeTypeActual() }}</span>
                                                        <span class="same-20 margin-left-5">{{ /* @var \App\Classes\Staff\Roster\FlightHandler $flightHandler */ baseDateFormat($flightHandler->getFlightDepartureTimeActualTimezone(), true, "-") }}</span>
                                                    </p>
                                                </div>
                                            @endif
                                        @else
                                            <div class="col-md-12">
                                                <p class="col-md-5 staff-roster-title">
                                                    STA/PTA:
                                                </p>

                                                <p class="col-md-7 staff-roster-body padding-0">
                                                    <span class="label label-primary">{{ /* @var \App\Classes\Staff\Roster\FlightHandler $flightHandler */ $flightHandler->getFlightArrivalTimeType() }}</span>
                                                    <span class="same-20 margin-left-5">{{ /* @var \App\Classes\Staff\Roster\FlightHandler $flightHandler */ baseDateFormat($flightHandler->getFlightArrivalTimeTimezone(), true, "-") }}</span>
                                                </p>
                                            </div>
                                            @if ($flightHandler->getFlightDepartureTimeActual())
                                                <div class="col-md-12">
                                                    <p class="col-md-5 staff-roster-title">
                                                        ETA/ATA:
                                                    </p>

                                                    <p class="col-md-7 staff-roster-body padding-0">
                                                        <span class="label label-warning">{{ /* @var \App\Classes\Staff\Roster\FlightHandler $flightHandler */ $flightHandler->getFlightArrivalTimeTypeActual() }}</span>
                                                        <span class="same-20 margin-left-5">{{ /* @var \App\Classes\Staff\Roster\FlightHandler $flightHandler */ baseDateFormat($flightHandler->getFlightArrivalTimeActualTimezone(), true, "-") }}</span>
                                                    </p>
                                                </div>
                                            @endif
                                        @endif

                                        {{--Not Assigned Flight--}}
                                        @if (!$tdClass)

                                            <div class="col-md-12">
                                                <p class="col-md-5 staff-roster-title">
                                                    @lang("content.staff_req"):
                                                </p>

                                                <p class="col-md-4 staff-roster-title">
                                                    @lang("content.min"):
                                                </p>

                                                <p class="col-md-3 staff-roster-title">
                                                    @lang("content.act"):
                                                </p>
                                            </div>

                                            <div class="col-md-12">
                                                <p class="col-md-5 staff-roster-body">
                                                    {{ $req }}
                                                </p>

                                                <p class="col-md-4 staff-roster-body">
                                                    {{ $min }}
                                                </p>

                                                <p class="col-md-3 staff-roster-body">
                                                    {{ $act }}
                                                </p>
                                            </div>

                                        @endif
                                    </div>
                                </td>

                                <td style="width: 60%" class="padding-0">
                                    @if ($tdClass)
                                        <div class="alert alert-warning alert-block vertical-center" style="margin: 10px;">
                                            <a class="close" data-dismiss="alert" href="#">x</a>
                                            <h4 class="alert-heading">@lang("content.info")</h4>
                                            @lang("content.no_services_assigned_to_the_flight__please_check_the_settings_for_the_flights_airline_and_arrival_departure_stations")
                                        </div>
                                    @else
                                        <div class="col-md-12 padding-0">

                                           @include("staff-roster.index-layouts.roster-tab.services")

                                        </div>
                                    @endif
                                </td>
                            <?php } ?>
                        @endif
                    </tbody>

                </table>

            </div>

        </div>

    </div>

</div>
