{!! Form::open([ 'class' => 'form-inline', 'method' => 'GET', 'id' => 'formGenerate' ]) !!}
<div class="col-md-12" style="margin: 0 0 10px 0; padding: 5px; padding-bottom: 10px; border-bottom: 1px solid #b5b5b5;">
    <div class="form-group marginRight">
        <label class="color-red">@lang("content.airport")* </label>

        <div class="btn-group">
            {!! Form::select('airport', $airports, $selectedAirport, ['required', 'class'=>'singleselect', 'id'=>'airport']) !!}
        </div>
    </div>

    @if (env(MULTIPLE_AIRLINE))
    <div class="form-group marginRight">
        <label>@lang("content.airline") </label>

        <div class="btn-group">
            {!! Form::select('airline[]', $airlines, \request("airline"), ['multiple'=>'multiple', 'class'=>'multiselect_search', 'id'=>'airline']) !!}
        </div>
    </div>
    @endif

    <div class="form-group marginRight">
        <label for="dateFrom">@lang("content.from") </label>
        {!! Form::text('dateFrom', $dateFrom, ['class'=>'form-control dateFrom myinput input-sm', 'placeholder'=>'From Date', 'id'=>'from_date']) !!}
        <label for="dateTo">@lang("content.to") </label>
        {!! Form::text('dateTo', $dateTo, ['class'=>'form-control dateTo myinput input-sm', 'placeholder' => 'To Date', 'id'=>'to_date']) !!}
    </div>

    <div class="form-group marginRight">
        <label class="toggle margin-right-10">
            <input type="radio" name="timing" value="{{ UTC }}" {!! (\request("timing") == UTC || !\request("timing")) ? "checked" : "" !!} >
            <i data-swchon-text="ON" data-swchoff-text="OFF"></i> {{ UTC }} </label>
{{--        <label class="toggle">--}}
{{--            <input type="radio" name="timing" value="{{ LOCAL }}" {!! \request("timing") == LOCAL ? "checked" : "" !!} >--}}
{{--            <i data-swchon-text="ON" data-swchoff-text="OFF"></i> {{ LOCAL }}</label>--}}
    </div>

    @php $disabled = \request("generate") ? "" : "disabled" @endphp
    <div class="form-group marginRight">
{{--        @if (isset($roster) && $roster)--}}
{{--        @endif--}}
        {!! Form::hidden("roster_id", isset($roster) && $roster ? $roster->id : null, ["id" => "roster_id"]) !!}

        {!! Form::submit( trans("content.generate"), ['class' => 'btn btn-primary', 'name' => 'generate', "id" => "generate_btn" ]) !!}
        {!! Form::submit( trans("content.save"), ['class' => 'btn btn-success', 'name' => 'save', "id" => "save_btn", $disabled ]) !!}
        {!! Form::submit( trans("content.reset"), ['class' => 'btn btn-danger', 'name' => 'reset', "id" => "reset_btn" ]) !!}
    </div>
</div>

<div class="col-md-12" style="margin-bottom: 20px; margin-left: 0; padding-left: 0;">
    <div class="col-md-2" style="padding: 0">
        <span class="label label-primary font-sm center-block padding-5">@lang("content.type")</span>
    </div>

    <section class="col-md-10">
        <label class="col-md-4 toggle">
            <input type="radio" name="roster_type" value="{{ AUTO_ROSTER_TYPE }}" {!! \request("roster_type") == AUTO_ROSTER_TYPE ? "checked" : "" !!} >
            <i data-swchon-text="ON" data-swchoff-text="OFF"></i> @lang("content.auto_roster")</label>
        <label class="col-md-4 toggle">
            <input type="radio" name="roster_type" value="{{ MANUAL_ROSTER_TYPE }}" {!! \request("roster_type") == MANUAL_ROSTER_TYPE  || !\request("roster_type") ? "checked" : "" !!} >
            <i data-swchon-text="ON" data-swchoff-text="OFF"></i> @lang("content.manual_roster") </label>

        <div class="col-md-4 inline-group">
            <label class="checkbox">
                <input id="include_rostered_staff" name="include_rostered_staff" type="checkbox" value="1" {!! \request("include_rostered_staff") ? "checked" : "" !!}>
                @lang("content.include_rostered_staff")
            </label>
        </div>

{{--        <label class="col-md-4 toggle">--}}
{{--            <input type="radio" name="staff_assignment" value="Max Hours" {!! (\request("staff_assignment") == MAX_HOURS || !\request("staff_assignment")) ? "checked" : "" !!} >--}}
{{--            <i data-swchon-text="ON" data-swchoff-text="OFF"></i> @lang("content.max_hours")</label>--}}
{{--        <label class="col-md-4 toggle">--}}
{{--            <input type="radio" name="staff_assignment" value="Monthly Accomplishment" {!! \request("staff_assignment") == MONTHLY_ACCOMPLISHMENT ? "checked" : "" !!} >--}}
{{--            <i data-swchon-text="ON" data-swchoff-text="OFF"></i> @lang("content.equal_monthly_accomplishment") </label>--}}
{{--        <label class="col-md-4 toggle">--}}
{{--            <input type="radio" name="staff_assignment" value="Total Hours" {!! \request("staff_assignment") == TOTAL_HOURS ? "checked" : "" !!} >--}}
{{--            <i data-swchon-text="ON" data-swchoff-text="OFF"></i> @lang("content.equal_total_hours")</label>--}}
    </section>
</div>

<div class="col-md-12" style="margin-bottom: 20px; margin-left: 0; padding-left: 0;">
    <div class="col-md-2" style="padding: 0">
        <span class="label label-primary font-sm center-block padding-5">@lang("content.shift_settings")</span>
    </div>
    <div class="col-md-10">
        <div class="col-md-4">
            <label>@lang("content.max_hours") </label>
            {!! Form::text("shift_max_hours", \request("shift_max_hours") ? \request("shift_max_hours") : $shiftMaxHours, ['class' => 'form-control input-80 input-sm', "min" => 0]) !!}
        </div>

        <div class="col-md-4">
            <label>@lang("content.min_hours") </label>
            {!! Form::text("shift_min_hours", \request("shift_min_hours") ? \request("shift_min_hours") : $shiftMinHours, ['class' => 'form-control input-80 input-sm', "min" => 0]) !!}
        </div>

        <div class="col-md-4">
            <label>@lang("content.min_rest_time") </label>
            {!! Form::text("shift_min_rest_time", \request("shift_min_rest_time") ? \request("shift_min_rest_time") : $shiftMinRestTime, ['class' => 'form-control input-80 input-sm', "min" => 0]) !!}
        </div>
    </div>
</div>

<div class="col-md-12" style="margin-bottom: 15px; margin-left: 0; padding-left: 0; padding-bottom: 10px; border-bottom: 1px solid #b5b5b5;">
    <div class="col-md-2" style="padding: 0">
        <span class="label label-primary font-sm center-block padding-5">@lang("content.other_settings")</span>
    </div>

    <div class="col-md-10">
        <section>
            <div class="col-md-4 inline-group">
                <label class="checkbox">
                    <input name="airport_license_check" type="checkbox" value="1" {!! \request("airport_license_check") ? "checked" : "" !!}>
                    @lang("content.airport_license_check")
                </label>
            </div>

            <div class="col-md-4 inline-group">
                <label class="checkbox">
                    <input name="airline_license_check" type="checkbox" value="1" {!! \request("airline_license_check") ? "checked" : "" !!}>
                    @lang("content.airline_license_check")
                </label>
            </div>
        </section>
    </div>
</div>



<div class="form-group col-md-12" style="margin-bottom: 15px; margin-left: 0; padding-left: 0; padding-bottom: 10px; border-bottom: 1px solid #b5b5b5;">

    <div class="col-md-2" style="padding: 0">
        <span class="label label-primary font-sm center-block padding-5">@lang("content.manual_staff_assignment")</span>
    </div>

    <div class="col-md-10">

        <div class="col-md-4">
            <label>@lang("content.date") </label>
            {!! Form::text('date', $dateFrom, ['id' => 'assigned_date', 'class'=>'form-control date myinput input-sm assign-date']) !!}
        </div>

        <div class="col-md-8">
            <label>@lang("content.flights") </label>
            {!! Form::select('flights', [], null, ['class'=>'input-sm margin-right-5 flights-list']) !!}
            <button type="button" class="input-sm btn btn-warning load-flights" style="">@lang("content.load_flights")</button>
            <button type="button" class="input-sm btn btn-success add-flight" disabled style="">@lang("content.add_flight")</button>
            <button type="button" class="input-sm btn btn-primary add-all" disabled style="">@lang("content.add_all")</button>
            <button type="button" class="input-sm btn btn-primary save-staff" disabled style="">@lang("content.save_changes")</button>
            <span class="color-red margin-left-10 padding-top-5" id="load-flight-info"></span>
        </div>

    </div>

</div>

<div id="staff_container">
    <div class="form-group col-md-3 assigned-container hidden" style="margin-bottom: 10px;" data-initial="1" data-num="1">
        <span class="col-md-3 label font-sm label-success margin-right-13 margin-top-5 assigned-service"></span>
        <div class="col-md-6">
            {!! Form::select('s_0[]', [], null, ['multiple'=>'multiple', 'class'=>'assigned-staff']) !!}
        </div>
    </div>
</div>

{!! Form::close() !!}


