<?php require_once(public_path("smart/inc/init.php")); ?>

<!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-sm-12 col-md-12 col-lg-12">

            <div class="col-lg-12" style="margin: 0 0 15px 0; padding: 0;">
                <ul class="demo-btns">
                    <li style="margin-right: 10px;">
                        <a href="#" id="station-all" data-id="" class="btn btn-primary font-md">ALL</a>
                    </li>
                    <?php /* @var \App\Classes\Staff\Roster\Roster $roster */
                    foreach ($roster->getStaffFilter()->getRosteredStaffStations() as $id => $station) { ?>
                    <li style="margin-right: 10px;">
                        <a href="#" id="station-{{ $id }}" data-id="{{ $id }}" class="btn btn-warning font-md">{{ $station->iata }}</a>
                    </li>
                    <?php } ?>
                </ul>
            </div>

        </article>

    </div>

</section>


<script type="text/javascript">

    pageSetUp();

    function closedthis() {
        $.smallBox({
            title : "Great! You just closed that last alert!",
            content : "This message will be gone in 5 seconds!",
            color : "#739E73",
            iconSmall : "fa fa-cloud",
            timeout : 5000
        });
    };

    var staffTable =  $(document).find("#staffTable"),
        flightTable =  $(document).find("#flightTable");

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyValidationDateFormats();

        Apply_Multiselect();

        @if (isset($roster) && $roster)

            $("#station-all").click(function(e) {

                $.bigBox({
                    title : "All Stations",
                    content : "Staff list and flights for all the stations.",
                    color : "#3276b1",
                    timeout: 3000,
                    icon : "fa fa-th-large",
                    number : "ALL"
                }, function() {
                    closedthis();
                });

                var staffRecords = staffTable.find("tr[data-type=staff-list]");
                var i = 0;
                staffRecords.each(function(){
                    $(this).find("td").first().text(++i);
                });
                staffRecords.show();

                var flightRecords = flightTable.find("tr[data-type=flight-list]");
                i = 0;
                flightRecords.each(function(){
                    $(this).find("td").first().text(++i);
                });
                flightRecords.show();

                e.preventDefault();
            });
            @foreach ($roster->getStaffFilter()->getRosteredStaffStations() as $id => $station)
                var id = {{ $id }};

                $("#station-{{ $id }}").click(function(e) {

                    $.bigBox({
                        title : "{{ $station->name }}",
                        content : "Roster Filter:\n Staff list and flights for the selected station only.",
                        color : "#c79121",
                        timeout: 3000,
                        icon : "fa fa-filter",
                        number : "{{ $station->iata }}"
                    }, function() {
                        closedthis();
                    });

                    // Staff Records
                    var staffRecords = staffTable.find("tr[data-type=staff-list][data-id={{ $id }}]");
                    var i = 0;
                    staffRecords.each(function(){
                        $(this).find("td").first().text(++i);
                    });

                    staffRecords.show();
                    staffTable.find("tr[data-type=staff-list]").not("[data-id={{ $id }}]").hide();

                    // Flight Records
                    var flightRecords = flightTable.find("tr[data-type=flight-list][data-id={{ $id }}]");
                    i = 0;
                    flightRecords.each(function(){
                        $(this).find("td").first().text(++i);
                    });

                    flightRecords.show();
                    flightTable.find("tr[data-type=flight-list]").not("[data-id={{ $id }}]").hide();

                    e.preventDefault();
                });
            @endforeach

        @endif

    };

    pagefunction();

</script>
