@if (!count($airlineHours))
    <div class="alert alert-info"  style="margin-top: 10px">
        <p>@lang("content.found") 0 @lang("content.records")</p>
    </div>
@else

    <div class="jarviswidget jarviswidget-color-blueDark" id="wid-airline" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

        <header>
            <span class="widget-icon"> <i class="fa fa-table"></i> </span>
            <h2>@lang("content.list")</h2>
        </header>

        <!-- widget div-->
        <div>

            <!-- widget edit box -->
            <div class="jarviswidget-editbox">
                <!-- This area used as dropdown edit box -->

            </div>
            <!-- end widget edit box -->

            <!-- widget content -->
            <div class="widget-body no-padding" style="min-height: 50px !important;">

                <div class="table-responsive">

                    <table class="table table-bordered table-hover table-standard" id="flightTable">
                        <thead>
                        <tr>
                            <th style="width: 60px;">No</th>
                            <th>@lang("content.flight_number")</th>
                            <th>STD</th>
                            <th>ATD</th>
{{--                            <th>@lang("content.departure")</th>--}}
{{--                            <th>@lang("content.type")</th>--}}
                            <th>@lang("content.planned_hours")</th>
                            <th>@lang("content.actual_hours")</th>
                        </tr>
                        {{--<tr>--}}
                            {{--<th data-center>Hours</th>--}}
                            {{--<th data-center>Cost</th>--}}
                        {{--</tr>--}}

                        </thead>
                        <tbody>
                        @php $prevAirline = null @endphp
                        @php $colspan = (count($periodUnique) + 2) * 2 + 1 @endphp

                        @php $i = 0 @endphp
                        @foreach($flightHours["data"] as $flightNumberId => $flights)
                            @foreach($flights as $id => $each)
                                @php $flightNumber = $each->staffFlight->flightNumber @endphp
                                @php $airline = $each->staffFlight->airline @endphp
                                @php $differentAirline = $airline != $prevAirline @endphp
                                @php $prevAirline = $airline @endphp

                                @php $flight = $each->staffFlight->flight @endphp
                                @php $route = $each->staffFlight->route @endphp
                                @php $dep = getFlightDepartureDate($flight) @endphp
                                @php $depDate = $each->staffFlight->departureDate @endphp

{{--                                @include("staff-report.layouts.flight-row", ["i" => ++$i, "each" => $each, 'colspan' => $colspan, 'differentAirline' => $differentAirline, 'flightNumber' => $flightNumber, 'airline' => $airline])--}}

                                <tr>
                                    <td>{{ ++$i }}</td>
                                    <td style="vertical-align: middle">
                                        <a class="flight-type" target="_blank" href="{{ url("flight-tracker/{$flight->id}") }}">
                                            {{ $flightNumber ? getAirlineCode($airline)."-".$flightNumber->flight_number.($route ? " (".$route.")" : "" ) : "-" }}
                                        </a>
                                    </td>
                                    <td>{{ baseDateFormat($flight->std, true) }}</td>
                                    <td>{{ $flight->atd ? baseDateFormat($flight->atd, true) : "-" }}</td>
                                    @php $excessClass = actualTimeAccess($each->pTotalTime, $each->totalTime) @endphp
                                    <td class="time-type" data-center>{{ $each->pTotalTime ? $each->pTotalTime : "-" }}</td>
                                    <td class="time-type {{ $excessClass ? "color-red" : "" }}" data-center>{{ $each->totalTime ? $each->totalTime : "-" }}</td>
                                </tr>

                            @endforeach
                        @endforeach

{{--                        @include("staff-report.layouts.flight-row", ["each" => $flightHours["total"], "total" => true])--}}
                        <tr>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td style="vertical-align: middle; font-weight: bold;">@lang("content.total")</td>
                            @php $excessClass = actualTimeAccess($flightHours["total"]->pTotalTime, $flightHours["total"]->totalTime) @endphp
                            <td class="time-type" data-center>{{ $flightHours["total"]->pTotalTime ? $flightHours["total"]->pTotalTime : "-" }}</td>
                            <td class="time-type {{ $excessClass ? "color-red" : "" }}" data-center>{{ $flightHours["total"]->totalTime ? $flightHours["total"]->totalTime : "-" }}</td>
                        </tr>

                        </tbody>

                    </table>

                </div>

            </div>

        </div>

    </div>

@endif
