@if (!count($airlineHours))
    <div class="alert alert-info"  style="margin-top: 10px">
        <p>@lang("content.found") 0 @lang("content.records")</p>
    </div>
@else

    <style>
        th, td {
            border: 1px solid #ddd;
        }
    </style>

    <div class="jarviswidget jarviswidget-color-blueDark" id="wid-airline" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

        <header>
            <span class="widget-icon"> <i class="fa fa-table"></i> </span>
            <h2>@lang("content.list")</h2>
        </header>

        <!-- widget div-->
        <div>

            <!-- widget edit box -->
            <div class="jarviswidget-editbox">
                <!-- This area used as dropdown edit box -->

            </div>
            <!-- end widget edit box -->

            <!-- widget content -->
            <div class="widget-body no-padding" style="min-height: 50px !important;">

                <div class="table-responsive">

                    <table class="table table-bordered table-hover" id="dailyTable">
                        <thead>
                        <tr>
                            <th>No</th>
                            <th style="min-width: 70px !important;">@lang("content.flight_number")</th>
                            <th style="min-width: 70px !important;">@lang("content.sector")</th>
                            <th>@lang("content.service_type")</th>
                            <th style="min-width: 30px !important;">@lang("content.type")</th>
                            <th style="min-width: 90px !important;">@lang("content.date_time")</th>
                        </tr>

                        </thead>
                        <tbody>
                            @php $i = 0 @endphp
                            @foreach(/**@var App\Classes\Staff\Report\FlightStaffHours $dailyReport */ $dailyReport["data"] as $flightId => $each)

                                @php $depDate = getFlightDepartureDate($each->flight) @endphp
                                @php $depType = getFlightDepartureTimeType($each->flight, true) @endphp
                                @php $depInitDate = getFlightDepartureInitialDate($each->flight) @endphp
                                @php $depInitialType = getFlightDepartureInitialTimeType($each->flight) @endphp

                                @php $arrDate = getFlightArrivalDate($each->flight) @endphp
                                @php $arrType = getFlightArrivalTimeType($each->flight, true) @endphp
                                @php $arrInitDate = getFlightArrivalInitialDate($each->flight) @endphp
                                @php $arrInitialType = getFlightArrivalInitialTimeType($each->flight) @endphp

                                @php $depSpan = departureArrivalTypeSpan($depType, null) @endphp
                                @php $depInitialSpan = departureArrivalTypeSpan($depInitialType, null) @endphp

                                @php $arrSpan = departureArrivalTypeSpan($arrType, null) @endphp
                                @php $arrInitialSpan = departureArrivalTypeSpan($arrInitialType, null) @endphp


                                @php $flightNumber = $each->flight->flightNumber @endphp
                                @php $airline = $flightNumber ? $flightNumber->airline : null @endphp
                                @php $route = $flightNumber ? getSector($flightNumber) : null @endphp

                                @php $serviceType = $each->serviceType @endphp
                                @php $service_type = $serviceType == ARRIVAL_SERVICE ? "arrival_service" : "departure_service" @endphp

                                @php $serviceData = \App\Models\Flight::getFlightsStaffServiceData($each->flight, null, true) @endphp

                                <tr>
                                    <td style="vertical-align: middle" data-center><strong>{{ ++$i }}</strong></td>

                                    <td style="vertical-align: middle;">
                                        <a class="flight-type" target="_blank" href="{{ url("flight-tracker/{$flightId}") }}">
                                            {{ ($flightNumber ? getAirlineCode($airline)."-".$flightNumber->flight_number : "-") }}
                                        </a>
                                    </td>
                                    <td>
                                        <strong>{{ ($route ? " (".$route.")" : "" ) }}</strong>
                                    </td>

                                    <td style="vertical-align: middle;">
                                        @if ($serviceType == ARRIVAL)
                                            <span class='label label-success font-sm'>{{ $serviceType }}</span>
                                        @else
                                            <span class='label label-primary font-sm'>{{ $serviceType }}</span>
                                        @endif
                                    </td>

                                    @if ($serviceType == ARRIVAL)
                                        <td>{!! $arrInitialSpan !!}</td>
                                        <td>{{ $arrInitDate ? baseDateFormat($arrInitDate, true) : "" }}</td>
{{--                                        <td>{!! $arrSpan !!}</td>--}}
{{--                                        <td>{{ baseDateFormat($arrDate, true) }}</td>--}}
                                    @else
                                        <td>{!! $depInitialSpan !!}</td>
                                        <td>{{ $depInitDate ? baseDateFormat($depInitDate, true) : ""}} </td>
{{--                                        <td>{!! $depSpan !!}</td>--}}
{{--                                        <td>{{ baseDateFormat($depDate, true) }}</td>--}}
                                    @endif
                                </tr>

                                @foreach($serviceData["services"] as $airlineService)
                                    @if ($airlineService->service_timings == 1)
                                        @if ($airlineService->service[$service_type] != 1)
                                            @continue
                                        @endif

                                        @php $obj = $airlineService->service @endphp
                                    @else
                                        @if ($airlineService[$service_type] != 1)
                                            @continue
                                        @endif

                                        @php $obj = $airlineService @endphp
                                    @endif

                                    @if ($serviceData["serviceType"] == DEPARTURE_SERVICE)
                                        @php $req = "dep_staff_req" @endphp
                                    @else
                                        @php $req = "arr_staff_req" @endphp
                                    @endif

                                    @php $sla = $obj->service ? $obj->service->abbr : $obj->abbr @endphp
                                    <td>{{ $sla }}-{{ $obj->{$req} }}</td>

                                    @php $k = 0 @endphp
                                    @foreach(/**@var App\Classes\Staff\Report\StaffHours $staffHours */ $each->staffList as $staffHours)

                                        @php $user = $staffHours->user @endphp
                                        @php $service = $staffHours->service @endphp

                                        @if ($service->abbr == $sla)
                                            <tr>
                                                <td>
                                                    <a target="_blank"
                                                       href="{{ route("homepage")."#". url("staff/{$user->id}/edit") }}">
                                                        {{ ++$k.".". \App\Models\User::getStation($user)."-".$user->first_name ." ". $user->last_name }}
                                                    </a>
                                                   </a>
                                                </td>
                                            </tr>
                                        @endif
                                    @endforeach
                                @endforeach
                            @endforeach

{{--                            @php $obj = $airlineHours["total"] @endphp --}}
{{--                            @php $excessClass = actualTimeAccess($obj->pTotalTime, $obj->totalTime) @endphp --}}

                        </tbody>

                    </table>

                </div>

            </div>

        </div>

    </div>

@endif
