<div class="jarviswidget jarviswidget-color-blueDark" id="wid-staff-expiry-report-view" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

    <header>
        <span class="widget-icon"> <i class="fa fa-table"></i> </span>

        <h2>@lang("content.list")</h2>
    </header>

    <!-- widget div-->
    <div>

        <!-- widget edit box -->
        <div class="jarviswidget-editbox">
            <!-- This area used as dropdown edit box -->

        </div>
        <!-- end widget edit box -->

        <!-- widget content -->
        <div class="widget-body no-padding" style="min-height: 50px !important;">

            <div class="table-responsive editable_div" style="">

                    {!!  Form::open(['method' => 'POST', 'class' => 'form-inline'])  !!}

                    @php $width = count($licenses) * 200 + 400 @endphp
                    <table class="table table-bordered table-hover table-standard" id="expiryTable" style="width: {{ $width }}px; min-width: 100%;">
                        <thead>
                            <tr>
                                <th rowspan="2" style="width: 60px;">No</th>
                                <th rowspan="2" style="width: 60px;">@lang("content.picture")</th>
                                <th rowspan="2" style="width: 130px;">@lang("content.first_name")</th>
                                <th rowspan="2" style="width: 150px;">@lang("content.last_name")</th>
                                @if ($isSuperAdmin)
                                    <th rowspan="2">User Status</th>
                                @endif

                                <th rowspan="2">@lang("content.station")</th>
                                <th rowspan="2">@lang("content.company")</th>
                                <th rowspan="2">@lang("content.department")</th>
                                <th rowspan="2">@lang("content.position")</th>
                                <th rowspan="2">@lang("content.staff_no")</th>
                                <th rowspan="2">@lang("content.email")</th>
                                <th rowspan="2" style="min-width: 60px !important;">@lang("content.doj")</th>
                                <th rowspan="2">@lang("content.min_hrs")</th>
                                <th rowspan="2">@lang("content.max_hrs")</th>

                                @foreach($licenses as $license)
                                    <th data-center colspan="3">{{ $license->name }}</th>
                                @endforeach
                            </tr>
                            <tr>
                                @foreach($licenses as $license)
                                    <th data-center style="min-width: 70px !important;">@lang("content.doi")</th>
                                    <th data-center style="min-width: 70px !important;">@lang("content.dex")</th>
                                    <th data-center>@lang("content.status")</th>
                                @endforeach
                            </tr>
                        </thead>

                        <tbody>
                        @php $j = 0 @endphp

                        @foreach($staffData as $ap => $data)
                            @foreach($data as $id => $staffLicense)
                                @php $user = $staffLicense["user"] @endphp
                                @php $picture = $user->thumb ? '/storage/users/'.$user->thumb : '/assets/img/default-user-picture.png' @endphp

                                @if ($j > 0 && $j % 8 == 0)
                                    <tr>
                                        <td style="width: 60px;"><strong>No</strong></td>
                                        <td style="width: 60px;"><strong>@lang("content.picture")</strong></td>
                                        <td style="width: 130px;"><strong>@lang("content.first_name")</strong></td>
                                        <td style="width: 150px;"><strong>@lang("content.last_name")</strong></td>
                                        @if ($isSuperAdmin)
                                            <td><strong>User Status</strong></td>
                                        @endif

                                        <td><strong>@lang("content.station")</strong></td>
                                        <td><strong>@lang("content.company")</strong></td>
                                        <td><strong>@lang("content.department")</strong></td>
                                        <td><strong>@lang("content.position")</strong></td>
                                        <td><strong>@lang("content.staff_no")</strong></td>
                                        <td><strong>@lang("content.email")</strong></td>
                                        <td style="min-width: 60px !important;"><strong>@lang("content.doj")</strong></td>
                                        <td><strong>@lang("content.min_hrs")</strong></td>
                                        <td><strong>@lang("content.max_hrs")</strong></td>

                                        @foreach($licenses as $license)
                                            <td colspan="3" data-center style="width:200px;"><strong>{{ $license->name }}</strong></td>
                                        @endforeach
                                    </tr>
                                @endif

                                <tr>
                                    <td data-center>{{ ++$j }}</td>
                                    <td><a href="{{ route("homepage")."#".url("/staff/$user->id/edit?s=".rand(100, 999)) }}"><img src="{{ $picture }}" width="100" class="img-thumbnail thumb_report_prev"/></a></td>
                                    <td><a target="_blank" href="{{ route("homepage")."#". url("staff/{$user->id}/edit?s=".rand(100, 999)) }}">{{ $user->first_name }}</a></td>
                                    <td><a target="_blank" href="{{ route("homepage")."#". url("staff/{$user->id}/edit?s=".rand(100, 999)) }}">{{ $user->last_name }}</a></td>

                                    @if ($isSuperAdmin)
                                        <td>{{ $user->deleted_at && $user->deleted_at != EMPTY_DATETIME ? "REMOVED" : ($user->resigned_at && $user->resigned_at != EMPTY_DATETIME ? "Resigned" : "") }}</td>
                                    @endif

                                    <td>{{ $user->location && $user->location->airport ? $user->location->airport->iata : '' }}</td>
                                    <td>{{ $user->company }}</td>
                                    <td>{{ $user->department && isset($user->department[0]) ? $user->department[0]->name : "" }}</td>
                                    <td>{{ $user->position && isset($user->position[0]) ? $user->position[0]->name : "" }}</td>
                                    <td>{{ $user->staff_number }}</td>
                                    <td>{{ $user->email }}</td>
                                    <td>{{ $user->doj ? baseDateFormat($user->doj) : "-" }}</td>
                                    <td>{{ $user->min_hours }}</td>
                                    <td>{{ $user->max_hours }}</td>

                                    @foreach($licenses as $license)
                                        @php $issueDate = isset($staffLicense[$license->id]) ? $staffLicense[$license->id][0] : null @endphp
                                        @php $expiryDate = isset($staffLicense[$license->id]) ? $staffLicense[$license->id][1] : null @endphp
                                        <td>
                                            <a href="#" data-field='license_id'
                                               data-field_value="{{ $license->id }}" data-model="StaffLicense"
                                               data-foreign_key='user_id' data-type="date"
                                               data-id='{{ $user->id }}' data-placeholder="Required"
                                               data-format='d-M-Y'
                                               data-js_format='DD-MMM-YYYY' data-value_key="issue_date"
                                               data-value='{{ $issueDate }}'
                                               class="editable {{ $issueDate ? 'editable-click' : 'editable-empty'  }}">{{ $issueDate ? date('d-M-Y', strtotime($issueDate))  : 'Empty' }}</a>
                                        </td>
                                        <td>
                                            <a href="#" data-field='license_id'
                                               data-field_value="{{ $license->id }}" data-model="StaffLicense"
                                               data-foreign_key='user_id' data-type="date"
                                               data-id='{{ $user->id }}' data-placeholder="Required"
                                               data-format='d-M-Y'
                                               data-js_format='DD-MMM-YYYY' data-value_key="expiry_date"
                                               data-value='{{ $expiryDate }}'
                                               class="editable {{ $expiryDate ? 'editable-click' : 'editable-empty'  }}">{{ $expiryDate ? date('d-M-Y', strtotime($expiryDate))  : 'Empty' }}</a>
                                        </td>
                                        <td>{!! Expiration_Date($expiryDate, $issueDate)['status'] !!}</td>
                                    @endforeach
                                </tr>

                            @endforeach
                        @endforeach
                        </tbody>

                    </table>

                    {!!  Form::close()  !!}

                </div>

        </div>

    </div>

</div>
