@if (!count($dailyReport))
    <div class="alert alert-info"  style="margin-top: 10px">
        <p>@lang("content.found") 0 @lang("content.records")</p>
    </div>
@else

    <div class="jarviswidget jarviswidget-color-blueDark" id="wid-airline" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

        <header>
            <span class="widget-icon"> <i class="fa fa-table"></i> </span>
            <h2>@lang("content.list")</h2>
        </header>

        <!-- widget div-->
        <div>

            <!-- widget edit box -->
            <div class="jarviswidget-editbox">
                <!-- This area used as dropdown edit box -->

            </div>
            <!-- end widget edit box -->

            <!-- widget content -->
            <div class="widget-body no-padding" style="min-height: 50px !important;">

                <div class="table-responsive">

                    <table class="table table-bordered table-hover table-standard" id="dailyTable">
                        <thead>
                        <tr>
                            <th rowspan="2">No</th>
                            <th rowspan="2">@lang("content.airline")</th>
                            <th rowspan="2" style="min-width: 70px !important;">@lang("content.flight_number")</th>
                            <th rowspan="2" style="min-width: 70px !important;">@lang("content.sector")</th>
                            <th rowspan="2">@lang("content.service_type")</th>
                            <th rowspan="2" style="min-width: 30px !important;">@lang("content.type")</th>
                            <th rowspan="2" style="min-width: 90px !important;">@lang("content.date_time")</th>
                            <th rowspan="2" style="min-width: 30px !important;">@lang("content.type")</th>
                            <th rowspan="2" style="min-width: 90px !important;">@lang("content.date_time")</th>

                            <th rowspan="2">@lang("content.staff_number")</th>
                            <th rowspan="2">@lang("content.first_name")</th>
                            <th rowspan="2">@lang("content.last_name")</th>
                            <th rowspan="2" style="min-width: 120px !important;">@lang("content.position")</th>
                            <th rowspan="2">@lang("content.base")</th>

                            <th rowspan="2">@lang("content.service")</th>
                            <th colspan="2" style="min-width: 220px !important;">@lang("content.start_date_time")</th>
                            <th colspan="2" style="min-width: 220px !important;">@lang("content.release_date_time")</th>
                            <th colspan="2">@lang("content.duration")</th>
                            <th rowspan="2" class="color-red">RMKS</th>
                        </tr>
                        <tr>
                            <th>PLN</th>
                            <th>ACT</th>

                            <th>PLN</th>
                            <th>ACT</th>

                            <th>PLN</th>
                            <th>ACT</th>
                        </tr>

                        </thead>
                        <tbody>
                            @php $i = 0 @endphp
                            @foreach(/**@var App\Classes\Staff\Report\FlightStaffHours $dailyReport */ $dailyReport["data"] as $flightId => $each)
                                @php $depDate = getFlightDepartureDate($each->flight) @endphp
                                @php $depType = getFlightDepartureTimeType($each->flight, true) @endphp
                                @php $depInitDate = getFlightDepartureInitialDate($each->flight) @endphp
                                @php $depInitialType = getFlightDepartureInitialTimeType($each->flight) @endphp

                                @php $arrDate = getFlightArrivalDate($each->flight) @endphp
                                @php $arrType = getFlightArrivalTimeType($each->flight, true) @endphp
                                @php $arrInitDate = getFlightArrivalInitialDate($each->flight) @endphp
                                @php $arrInitialType = getFlightArrivalInitialTimeType($each->flight) @endphp

                                @php $depSpan = departureArrivalTypeSpan($depType, null) @endphp
                                @php $depInitialSpan = departureArrivalTypeSpan($depInitialType, null) @endphp

                                @php $arrSpan = departureArrivalTypeSpan($arrType, null) @endphp
                                @php $arrInitialSpan = departureArrivalTypeSpan($arrInitialType, null) @endphp


                                @php $flightNumber = $each->flight->flightNumber @endphp
                                @php $airline = $flightNumber ? $flightNumber->airline : null @endphp
                                @php $route = $flightNumber ? getSector($flightNumber) : null @endphp

                                @foreach(/**@var App\Classes\Staff\Report\StaffHours $staffHours */ $each->staffList as $staffHours)
                                    @php $user = $staffHours->user @endphp
                                    @php $service = $staffHours->service @endphp
                                    @php $serviceType = $staffHours->serviceType @endphp

                                    <tr>
                                        <td style="vertical-align: middle" data-center><strong>{{ ++$i }}</strong></td>

                                        <td>
                                            <a target="_blank" href="{{ route("homepage")."#".url("airline-service?airline_id=$airline->id") }}">
                                                <img src="{{ asset("storage/airlines/img/{$airline->picture}") }}" height="30"/>
                                            </a>
                                        </td>

                                        <td style="vertical-align: middle;">
                                            <a class="flight-type" target="_blank" href="{{ url("flight-tracker/{$flightId}") }}">
                                                {{ ($flightNumber ? getAirlineCode($airline)."-".$flightNumber->flight_number : "-") }}
                                            </a>
                                        </td>
                                        <td>
                                            <strong>{{ ($route ? " (".$route.")" : "" ) }}</strong>
                                        </td>


                                        @if ($serviceType == ARRIVAL_SERVICE)
                                            <td style="vertical-align: middle;"><span class='label label-success font-sm'>{{ ARRIVAL }}</span></td>
                                            <td>{!! $arrInitialSpan !!}</td>
                                            <td>{{ $arrInitDate ? baseDateFormat($arrInitDate, true) : "" }}</td>
                                            <td>{!! $arrSpan !!}</td>
                                            <td>{{ baseDateFormat($arrDate, true) }}</td>
                                        @elseif ($serviceType == DEPARTURE_SERVICE)
                                            <td style="vertical-align: middle;"><span class='label label-primary font-sm'>{{ DEPARTURE }}</span></td>
                                            <td>{!! $depInitialSpan !!}</td>
                                            <td>{{ $depInitDate ? baseDateFormat($depInitDate, true) : ""}} </td>
                                            <td>{!! $depSpan !!}</td>
                                            <td>{{ baseDateFormat($depDate, true) }}</td>
                                        @elseif ($serviceType == TURNAROUND_SERVICE)
                                            <td style="vertical-align: middle;"><span class='label label-warning font-sm'>{{ TURNAROUND }}</span></td>
                                            <td>{!! $depInitialSpan !!}</td>
                                            <td>{{ $depInitDate ? baseDateFormat($depInitDate, true) : ""}} </td>
                                            <td>{!! $depSpan !!}</td>
                                            <td>{{ baseDateFormat($depDate, true) }}</td>
                                        @endif

                                        <td data-center>{{ $user->staff_number }}</td>
                                        <td>
                                            <a target="_blank"
                                               href="{{ route("homepage")."#". url("staff/{$user->id}/edit?s=".rand(100, 999)) }}">{{ $user->first_name }}</a>
                                        </td>
                                        <td>
                                            <a target="_blank"
                                               href="{{ route("homepage")."#". url("staff/{$user->id}/edit?s=".rand(100, 999)) }}">{{ $user->last_name }}</a>
                                        </td>
                                        <td>{{ getUserPositionName($user) }}</td>
                                        <td data-center>{{ \App\Models\User::getStation($user) }}</td>
                                        <td data-center><span class='label label-warning font-sm'>{{ $service->abbr }}</span></td>

                                        @php $excessClass = actualTimeAccess($staffHours->pTotalTime, $staffHours->totalTime) @endphp
                                        <td class="" data-center>
                                            <span class="sla-pln">{{ baseDateFormat($staffHours->pReportTime, true) }}</span>
                                        </td>
                                        <td>
                                            <span class="color-blue">{{ $staffHours->reportTime ? baseDateFormat($staffHours->reportTime, true) : "-" }}</span>
                                        </td>

                                        <td class="" data-center>
                                            <span class="sla-pln">{{ baseDateFormat($staffHours->pReleaseTime, true) }}</span>
                                        </td>
                                        <td>
                                            <span class="color-blue">{{ $staffHours->releaseTime ? baseDateFormat($staffHours->releaseTime, true) : "-" }}</span>
                                        </td>
                                        <td class="time-type" data-center>{{ $staffHours->pTotalTime ? $staffHours->pTotalTime : "-" }}</td>
                                        <td class="time-type {{ $excessClass ? "color-red" : "" }}" data-center>{{ $staffHours->totalTime ? $staffHours->totalTime : "-" }}</td>
                                        <td class="color-red" style="min-width: 200px;">{{ $staffHours->reason }}</td>
                                    </tr>

                                @endforeach
                            @endforeach

                            @php $obj = $airlineHours["total"] @endphp

                            @php $excessClass = actualTimeAccess($obj->pTotalTime, $obj->totalTime) @endphp

                            <tr>
                                <td style="vertical-align: middle; font-weight: bold;">@lang("content.total")</td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
{{--                                <td data-center><span class='label label-success font-sm'>PLN</span></td>--}}
                                <td class="time-type" data-center>{{ $obj->pTotalTime ? $obj->pTotalTime : "-" }}</td>
                                {{--<td class="salary-type">{!! $obj->totalSalary ? "<span class='fa fa-euro'></span> ".$obj->totalSalary : "-" !!}</td>--}}
{{--                                <td data-center><span class='label label-primary font-sm'>ACT</span></td>--}}
                                <td class="time-type {{ $excessClass ? "color-red" : "" }}" data-center> {{ $obj->totalTime ? $obj->totalTime : "-" }}</td>
                                {{--<td class="salary-type">{!! $obj->totalSalary ? "<span class='fa fa-euro'></span> ".$obj->totalSalary : "-" !!}</td>--}}
                                <td></td>

                            </tr>

                        </tbody>

                    </table>

                </div>

            </div>

        </div>

    </div>

@endif
