@if (!count($airlineHours))
    <div class="alert alert-info"  style="margin-top: 10px">
        <p>@lang("content.found") 0 @lang("content.records")</p>
    </div>
@else

    <div class="jarviswidget jarviswidget-color-blueDark" id="wid-airline" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

        <header>
            <span class="widget-icon"> <i class="fa fa-table"></i> </span>
            <h2>@lang("content.list")</h2>
        </header>

        <!-- widget div-->
        <div>

            <!-- widget edit box -->
            <div class="jarviswidget-editbox">
                <!-- This area used as dropdown edit box -->

            </div>
            <!-- end widget edit box -->

            <!-- widget content -->
            <div class="widget-body no-padding" style="min-height: 50px !important;">

                <div class="table-responsive">

                    <table class="table table-bordered table-hover" id="dailyTable">
                        <thead>
                        <tr>
                            <th style="width: 60px;">No</th>
{{--                            <th style="width: 60px;">@lang("content.picture")</th>--}}
                            <th>@lang("content.staff_number")</th>
                            <th>@lang("content.first_name")</th>
                            <th>@lang("content.last_name")</th>
                            <th style="width: 160px !important;">@lang("content.position")</th>
                            <th>@lang("content.base")</th>
                            <th>@lang("content.service")</th>

                            <th style="min-width: 120px;">@lang("content.start_time")</th>
                            <th style="min-width: 120px;">@lang("content.release_time")</th>

                            <th>@lang("content.planned_hours")</th>
                            <th>@lang("content.actual_hours")</th>
{{--                            <th>@lang("content.duration")</th>--}}
                        </tr>
                        {{--<tr>--}}
                            {{--<th data-center>Hours</th>--}}
                            {{--<th data-center>Cost</th>--}}
                        {{--</tr>--}}

                        </thead>
                        <tbody>
                            @php $i = 0 @endphp
                            @foreach(/**@var App\Classes\Staff\Report\FlightStaffHours $dailyReport */ $dailyReport["data"] as $flightId => $each)

                                @php $depDate = getFlightDepartureDate($each->flight) @endphp
                                @php $depType = getFlightDepartureTimeType($each->flight, true) @endphp
                                @php $depInitDate = getFlightDepartureInitialDate($each->flight) @endphp
                                @php $depInitialType = getFlightDepartureInitialTimeType($each->flight) @endphp

                                @php $arrDate = getFlightArrivalDate($each->flight) @endphp
                                @php $arrType = getFlightArrivalTimeType($each->flight, true) @endphp
                                @php $arrInitDate = getFlightArrivalInitialDate($each->flight) @endphp
                                @php $arrInitialType = getFlightArrivalInitialTimeType($each->flight) @endphp

                                @php $depSpan = departureArrivalTypeSpan($depType, null) @endphp
                                @php $depInitialSpan = departureArrivalTypeSpan($depInitialType, null) @endphp

                                @php $arrSpan = departureArrivalTypeSpan($arrType, null) @endphp
                                @php $arrInitialSpan = departureArrivalTypeSpan($arrInitialType, null) @endphp


                                @php $flightNumber = $each->flight->flightNumber @endphp
                                @php $airline = $flightNumber ? $flightNumber->airline : null @endphp
                                @php $route = $flightNumber ? getSector($flightNumber) : null @endphp

                                @php $serviceType = $each->serviceType @endphp

                                <tr>
                                    <td style="vertical-align: middle" data-center><strong>{{ ++$i }}</strong></td>

                                    <td>
                                        <a target="_blank" href="{{ route("homepage")."#".url("airline-service?airline_id=$airline->id") }}">
                                            <img src="{{ asset("storage/airlines/img/{$airline->picture}") }}" height="30"/>
                                        </a>
                                    </td>

                                    <td style="vertical-align: middle;">
                                        <a class="flight-type" target="_blank" href="{{ url("flight-tracker/{$flightId}") }}">
                                            {{ ($flightNumber ? getAirlineCode($airline)."-".$flightNumber->flight_number : "-") }}
                                        </a>
                                    </td>
                                    <td style="vertical-align: middle;">
                                        <strong>{{ ($route ? " (".$route.")" : "" ) }}</strong>
                                        <br>
                                        @if ($serviceType == ARRIVAL)
                                            <span class='label label-success font-sm'>{{ $serviceType }}</span>
                                        @else
                                            <span class='label label-primary font-sm'>{{ $serviceType }}</span>
                                        @endif
                                    </td>
                                    <td style="vertical-align: middle">
                                        <div>
                                        @if ($serviceType == ARRIVAL)
                                            <div class="margin-top-5">
                                                @if ($arrInitDate)
                                                    {!! $arrInitialSpan !!} {{ baseDateFormat($arrInitDate, true) }}
                                                @endif
                                                <div class="margin-top-5">
                                                    {!! $arrSpan !!} {{ baseDateFormat($arrDate, true) }}
                                                </div>
                                            </div>
                                        @else
                                            <div class="margin-top-5">
                                                @if ($depInitDate)
                                                    {!! $depInitialSpan !!} {{ baseDateFormat($depInitDate, true) }}
                                                @endif
                                                <div class="margin-top-5">
                                                    {!! $depSpan !!} {{ baseDateFormat($depDate, true) }}
                                                </div>
                                            </div>
                                        @endif
                                        </div>
                                    </td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                </tr>

                                @foreach(/**@var App\Classes\Staff\Report\StaffHours $staffHours */ $each->staffList as $staffHours)

                                    @php $j = 0 @endphp
                                    @include("staff-report.layouts.daily-row", ["j" => ++$j, "each" => $staffHours])

                                @endforeach
                            @endforeach

                            @php $obj = $airlineHours["total"] @endphp

                            @php $excessClass = actualTimeAccess($obj->pTotalTime, $obj->totalTime) @endphp

                            <tr>
                                <td style="vertical-align: middle; font-weight: bold;">@lang("content.total")</td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
{{--                                <td data-center><span class='label label-success font-sm'>PLN</span></td>--}}
                                <td class="time-type" data-center>{{ $obj->pTotalTime ? $obj->pTotalTime : "-" }}</td>
                                {{--<td class="salary-type">{!! $obj->totalSalary ? "<span class='fa fa-euro'></span> ".$obj->totalSalary : "-" !!}</td>--}}
{{--                                <td data-center><span class='label label-primary font-sm'>ACT</span></td>--}}
                                <td class="time-type {{ $excessClass ? "color-red" : "" }}" data-center> {{ $obj->totalTime ? $obj->totalTime : "-" }}</td>
                                {{--<td class="salary-type">{!! $obj->totalSalary ? "<span class='fa fa-euro'></span> ".$obj->totalSalary : "-" !!}</td>--}}
                            </tr>

                        </tbody>

                    </table>

                </div>

            </div>

        </div>

    </div>

@endif
