<?php

//initilize the page
require_once(public_path("smart/inc/init.php"));

//require UI configuration (nav, ribbon, etc.)
require_once(public_path("smart/inc/config.ui.php"));

include_once(public_path("smart/inc/user_variables.php"));


/*---------------- PHP Custom Scripts ---------

YOU CAN SET CONFIGURATION VARIABLES HERE BEFORE IT GOES TO NAV, RIBBON, ETC.
E.G. $page_title = "Custom Title" */

$page_title = "Staff Report";

/* ---------------- END PHP Custom Scripts ------------- */

//include header
//you can add your custom css in $page_css array.
//Note: all css files are inside css/ folder
$page_css[] = "your_style.css";

$no_main_header = true;

$page_body_prop = array("id"=>"extr-page", "class"=>"animated fadeInDown");

include(public_path("smart/inc/header.php"));

?>


<!-- ==========================CONTENT STARTS HERE ========================== -->
<!-- possible classes: minified, no-right-panel, fixed-ribbon, fixed-header, fixed-width-->
<header id="header" class="no-padding" >
    <!--<span id="logo"></span>-->

    <div id="logo-group"  style="height: 60px; width: 100%; padding: 0 15px;" class="flightTrackerBackground">
        <h2 class="flightTracker color-white">Staff Report</h2>
    {{--<span> <img style="max-height: 70px" src="{{ $logo }}"  alt="Aviation-BIS"> </span>--}}
    {{--        <h2><strong>{{ $logo_text }}</strong></h2>--}}
    <!-- END AJAX-DROPDOWN -->
    </div>

</header>

<div id="main" role="main">

    <!-- MAIN CONTENT -->
    <div id="content" class="">
        <!-- widget grid -->
        <section id="widget-grid" class="">

            <!-- row -->
            <div class="row">

                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

                    <div class="col-sm-12 padding-0">

                        {{--Tabs--}}
                        <ul class="nav nav-tabs" id="tabs">

                            <li class="{{ !\request("tab") || \request("tab") == "hours" ? "active" : "" }}">
                                <a href="#hours_tab" data-toggle="tab">
                                    <span class="tabText">@lang("content.roster_and_hours_reports")</span>
                                </a>
                            </li>

                            <li class="{{ \request("tab") == "expiry" ? "active" : "" }}">
                                <a href="#expiry_tab" data-toggle="tab">
                                    <span class="tabText">@lang("content.expiry_report")</span>
                                </a>
                            </li>

                            <li class="{{ \request("tab") == "expiry_summary" ? "active" : "" }}">
                                <a href="#expiry_summary_tab" data-toggle="tab">
                                    <span class="tabText">@lang("content.expiry_summary_report")</span>
                                </a>
                            </li>


                        </ul>

                        {{--Tab Content--}}
                        <div class="tab-content">

                            <div class="tab-pane {{ !\request("tab") || \request("tab") == "hours" ? "active" : "" }} bg-color-white" id="hours_tab" style="min-height: 550px; padding: 15px !important; width: 100%; ">

                                <div class="col-md-12" style="margin-bottom: 20px;">
                                    @include("staff-report.layouts.index-hours-form")
                                </div>

                                @if (\request("tab") == "hours")
                                    {{--Inner tabs--}}
                                    <ul class="nav nav-pills" id="tabs">

                                        <li class="active">
                                            <a href="#daily_tab" data-toggle="tab">
                                                <span class="tabText">@lang("content.hours_report")</span>
                                            </a>
                                        </li>
                                        <li class="">
                                            <a href="#export_tab" data-toggle="tab">
                                                <span class="tabText">@lang("content.export_roster")</span>
                                            </a>
                                        </li>
                                        <li class="">
                                            <a href="#ba_report_tab" data-toggle="tab">
                                                <span class="tabText">BA @lang("content.report")</span>
                                            </a>
                                        </li>
                                        {{--                                <li class="">--}}
                                        {{--                                    <a href="#sla_report_tab" data-toggle="tab">--}}
                                        {{--                                        <span class="tabText">SLA @lang("content.report")</span>--}}
                                        {{--                                    </a>--}}
                                        {{--                                </li>--}}
                                        <li class="">
                                            <a href="#by_staff_tab" data-toggle="tab">
                                                <span class="tabText">@lang("content.by_staff")</span>
                                            </a>
                                        </li>

{{--                                        <li class="">--}}
{{--                                            <a href="#payroll_hours" data-toggle="tab">--}}
{{--                                                <span class="tabText">@lang("content.payroll_hours")</span>--}}
{{--                                            </a>--}}
{{--                                        </li>--}}

                                        <li class="">
                                            <a href="#by_office_duties_tab" data-toggle="tab">
                                                <span class="tabText">@lang("content.office_duties")</span>
                                            </a>
                                        </li>

                                        <li class="">
                                            <a href="#by_airline_tab" data-toggle="tab">
                                                <span class="tabText">@lang("content.by_airline")</span>
                                            </a>
                                        </li>

                                        <li class="">
                                            <a href="#by_flight_tab" data-toggle="tab">
                                                <span class="tabText">@lang("content.by_flight")</span>
                                            </a>
                                        </li>

                                        <li class="">
                                            <a href="#by_flight_date_tab" data-toggle="tab">
                                                <span class="tabText">@lang("content.by_flight_date")</span>
                                            </a>
                                        </li>

                                    </ul>

                                    <div class="pill-content no-padding no-margin">

                                        <div class="pill-pane bg-color-white active" id="daily_tab" style="min-height: 250px; padding: 15px 0 !important; width: 100%; ">
                                            @include("staff-report.layouts.index-daily-tab")
                                        </div>

                                        <div class="pill-pane bg-color-white" id="export_tab" style="min-height: 250px; padding: 15px 0 !important; width: 100%; ">
                                            @include("staff-report.layouts.index-export-tab")
                                        </div>

                                        <div class="pill-pane bg-color-white " id="ba_report_tab" style="min-height: 250px; padding: 15px 0 !important; width: 100%; ">
                                            @include("staff-report.layouts.index-ba-report-tab")
                                        </div>

                                        {{--                                <div class="pill-pane bg-color-white " id="sla_report_tab" style="min-height: 250px; padding: 15px 0 !important; width: 100%; ">--}}
                                        {{--                                    @include("staff-report.layouts.index-sla-report-tab")--}}
                                        {{--                                </div>--}}

                                        {{--By Staff--}}
                                        <div class="pill-pane bg-color-white" id="by_staff_tab" style="min-height: 500px; padding: 15px 0 !important; width: 100%; overflow: auto;">
                                            @if ($monthlyReport)
                                                @include("staff-report.layouts.index-monthly-hours-tab")
                                            @else
                                                @include("staff-report.layouts.index-hours-tab")
                                            @endif
                                        </div>

{{--                                        <div class="pill-pane bg-color-white" id="payroll_hours" style="min-height: 250px; padding: 15px 0 !important; width: 100%; ">--}}
{{--                                            @include("staff-report.layouts.index-payroll-tab")--}}
{{--                                        </div>--}}

                                        <div class="pill-pane bg-color-white" id="by_office_duties_tab" style="min-height: 250px; padding: 15px 0 !important; width: 100%; ">
                                            @include("staff-report.layouts.index-office-duties-tab")
                                        </div>

                                        <div class="pill-pane bg-color-white" id="by_airline_tab" style="min-height: 250px; padding: 15px 0 !important; width: 100%; ">
                                            @include("staff-report.layouts.index-airline-tab")
                                        </div>

                                        <div class="pill-pane bg-color-white" id="by_flight_tab" style="min-height: 250px; padding: 15px 0 !important; width: 100%; ">
                                            @include("staff-report.layouts.index-flight-number-tab")
                                        </div>

                                        <div class="pill-pane bg-color-white" id="by_flight_date_tab" style="min-height: 250px; padding: 15px 0 !important; width: 100%; ">
                                            @include("staff-report.layouts.index-flight-tab")
                                        </div>

                                    </div>
                                @endif
                            </div>

                            {{--Leave And Other Tabs--}}
                            <div class="tab-pane {{ \request("tab") == "expiry" ? "active" : "" }} bg-color-white" id="expiry_tab" style="min-height: 550px; padding: 15px !important; width: 100%; overflow: auto;">
                                @include("staff-report.layouts.index-expiry-tab")
                            </div>

                            <div class="tab-pane {{ \request("tab") == "expiry_summary" ? "active" : "" }} bg-color-white" id="expiry_summary_tab" style="min-height: 550px; padding: 15px !important; width: 100%; overflow: auto;">
                                @include("staff-report.layouts.index-expiry-summary-tab")
                            </div>

                        </div>

                    </div>

                </article>

            </div>

        </section>
    </div>
</div>



<script type="text/javascript">
    var baseUrl = "{{ url('/') }}";
    var baseDashboardUrl = "{{ url('home/dashboard') }}";
    var baseHomeUrl = "{{ route("homepage")."#". url('/') }}";
    var AIRLINE = "{{ env("AIRLINE") }}";
    var CARRIER = "{{ env("CARRIER") }}";
    var CURRENT_IATA_CODE = "{{ env("IATA_CODE") }}";
</script>

<?php
//include required scripts
include(public_path("smart/inc/scripts.php"));
?>


<script type="text/javascript">

    pageSetUp();

    // ApplyMultipleFormSubmit();

    var pagefunction = function () {

        ApplyValidationDateFormats();
        Apply_Multiselect();
        // ApplyTableFilter("#dailyTable", false, [[6, "asc"]]);
        ApplyTableFilter("#dailyTable");
        ApplyTableFilter("#exportTable");
        ApplyTableFilter("#baReportTable");
        ApplyTableFilter("#staff-table");
        ApplyTableFilter("#hoursTable");
        ApplyTableFilter("#office_duties_table");
        ApplyTableFilter("#airline-table");
        ApplyTableFilter("#flightNumberTable");
        ApplyTableFilter("#flightTable");
        ApplyTableFilter("#licensesTable");
        // ApplyTableFilterSortingOff(".sorting-off");

        @if (ghaModule())
            ApplyOperationsFormFilter({!! json_encode($flightNumbers) !!}, {!! json_encode(\request("flightNumber")) !!});
        @endif
    };

    pagefunction();

</script>
