<?php require_once(public_path("smart/inc/init.php")); ?>

        <!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
            
            @include('general.tab-header', ['departmentName' => 'Staff', 'moduleName' => 'Licenses'])
            
                <h2 style="margin-top: 0">{{ $user->first_name ." ".$user->last_name}}</h2>
                <h4 style="margin-top: 0">{{ $license->name}}</h4>
            <!-- Message -->
            @if ($errors->all())
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif
            @if ( Session::has('message'))
                <div class="alert alert-success">
                    {{ Session::get('message')}}
                </div>
            @endif
            
            <div class="btn-group" style="margin-bottom: 10px">
                <a target="_blank" {{$licenseExists ? '' : 'disabled' }} href="{{ url("staff-license/{$staffLicense->id}") }}?view=1" class="btn btn-warning">View</a>
                <a {{$licenseExists ? '' : 'disabled' }} href="{{ url("staff-license/{$staffLicense->id}") }}?download=1" class="btn btn-primary">Download</a>
                <a class="btn btn-danger edit">{{$licenseExists ? 'Edit' : 'Upload' }}</a>
            </div>
            
            @if (!$licenseExists)
                <div class="alert alert-dismissable alert-warning"><button type="button" class="close" data-dismiss="alert">×</button>
                    Sorry license Not found. Please Check if It's Uploaded
                </div>
            @endif
            
            <div id="upload-license" style="width: 30%; background-color: #f4fbf6; max-width: 300px; padding: 15px; display: block" >
                {!! Form::open(['files'=>true, 'method' => 'POST', 'url' => url("staff-license/{$staffLicense->id}")]) !!}
                    {!! Form::file('file') !!}

                  <br/>
                  <!-- submit buttons -->
                  {!! Form::submit('Upload', ['name' => 'upload']) !!}
                  {!! Form::submit('Delete', ['name' => 'delete']) !!}
              {!! Form::close() !!}
            </div>

        </article>

    </div>

</section>

<script type="text/javascript">

    pageSetUp();

    var btnUpload = $(document).find("input[name=upload]"),
        btnDelete = $(document).find("input[name=delete]");

    $(document).on('click', 'a.edit', function () {
        $(document).find("#upload-license").toggle(400, function () {
            var $this = $(this);
            $(document).find("#upload-license").val(($this.is(":visible")) ? "1" : "0");
        });
    });
    
    var pagefunction = function () {

//        ApplySubmitEvent(btnUpload);

//        ApplySubmitEvent(btnDelete);

        ApplyValidationDateFormats();

        Apply_Multiselect();

        ApplyTableFilter("#table");
    };

    pagefunction();

</script>
