<?php
	//initilize the page
	require_once(public_path("smart/inc/init.php"));

	//require UI configuration (nav, ribbon, etc.)
	require_once(public_path("smart/inc/config.ui.php"));

	/*---------------- PHP Custom Scripts ---------

	YOU CAN SET CONFIGURATION VARIABLES HERE BEFORE IT GOES TO NAV, RIBBON, ETC. */

	include(public_path("smart/inc/user_variables.php"));


	/* ---------------- END PHP Custom Scripts ------------- */

	//include header
	//you can add your custom css in $page_css array.
	//Note: all css files are inside css/ folder
	$page_css[] = "your_style.css";
	include(public_path("smart/inc/header.php"));

	//include left panel (navigation)
	//follow the tree in inc/config.ui.php
	include(public_path("smart/inc/nav.php"));


?>
<!-- ==========================CONTENT STARTS HERE ========================== -->
<!-- MAIN PANEL -->
<div id="main" role="main">
	<?php
		include(public_path("smart/inc/ribbon.php"));
	?>

	@include('template/modal-loading', [ 'text' => 'Please Wait...'])

	@include('layouts/alert-message')

	@include('vendor/flash/message')

	<!-- MAIN CONTENT -->
	<div id="content">

	</div>
	<!-- END MAIN CONTENT -->
	
</div>
<!-- END MAIN PANEL -->

<!-- FOOTER -->
	<?php
		include(public_path("smart/inc/footer.php"));
	?>
<!-- END FOOTER -->

<!-- ==========================CONTENT ENDS HERE ========================== -->

<script type="text/javascript">
	var baseUrl = "{{ url('/') }}";
	var routeHomePageUrl = "{{ route("homepage") }}";
	var baseDashboardUrl = "{{ url('home/dashboard') }}";
	var baseHomeUrl = "{{ route("homepage")."#" }}";
	var AIRLINE = "{{ env("AIRLINE") }}";
	var CARRIER = "{{ env("CARRIER") }}";
	var CURRENT_IATA_CODE = "{{ env("IATA_CODE") }}";

	var GSRM = "GSRM";
	var FRAAI = "FRAAI";
	var TAJIK_AIR = "TAJIK_AIR";
	var QAZAQ_AIR = "QAZAQ_AIR";
	var AVIAM = "AVIAM";
	var SCO = "SCO";
	var IAG = "IAG";

	var $location1, $location2, $assets;
	if (CURRENT_IATA_CODE == "SZ"){
		$location1 = "DYU";
		$location2 = "LBD";
		$assets = "assets";
	}
	else {
		$location1 = "FRU";
		$location2 = "OSS";
		$assets = "assets";
	}


	var TAJIKAIR = "Tajik Air",
		OTHERAIRLINES = "Other Airlines";

	var FLIGHT_OPERATIONS_DIRECTOR_POSITION = "Captain",
		CAPTAIN_POSITION = "Captain",
		FIRST_OFFICER_POSITION = "First Officer",
		CHIEF_PILOT_POSITION = "Chief Pilot",
		PILOT_INSTRUCTOR_POSITION = "Pilot-instructor",
		COPILOT_JUNIOR_POSITION = "Co-Pilot Junior";

	var FLIGHT_ATTENDANT_POSITION = "Flight Attendant",
			FLIGHT_ATTENDANT_N2_POSITION = "Flight Attendant #2",
			FLIGHT_ATTENDANT_JUNIOR_POSITION = "Flight Attendant Junior",
			PURSER_POSITION = "Purser",
			INSTRUCTOR_FLIGHT_ATTENDANT_POSITION = "Instructor-Flight Attendant",
			SENIOR_INSTRUCTOR_FLIGHT_ATTENDANT_POSITION = "Senior Instructor-Flight Attendant";

	var authUserId = "", authUserName = "", authUserStatus = "";
	@if (isset($auth) && is_object($auth) && $auth->user())
        authUserId = "{{ $auth->user()->id }}";
		authUserName = "{{ $auth->user()->first_name." ".$auth->user()->last_name}}";
		authUserStatus = "{{ $auth->user()->chatStatus ? $auth->user()->chatStatus->status : STATUS_ONLINE }}";
	@endif
</script>

<?php
	//include required scripts
	include(public_path("smart/inc/scripts.php"));
	//include footer
	// 	include(public_path("smart/inc/google-analytics.php"));

	echo "</body>".
	"</html>";
?>


