@extends($ajaxCall)

@section('css')
	<style>

	</style>
@stop

@section('content')

	@include('setup.wizard', ['step' => 6])

	<div class="container-fluid">
		<div class="row">
			<div class="col-lg-offset-1 col-lg-10 col-lg-offset-1">
				<div class="panel panel-default">
					<div class="panel-heading">Setup / Create System Admin</div>
					<div class="panel-body">
						@if (count($errors) > 0)
							<div class="alert alert-danger">
								<strong>Whoops!</strong> There were some problems with your input.<br><br>
								<ul>
									@foreach ($errors->all() as $error)
										<li>{!! $error !!}</li>
									@endforeach
								</ul>
							</div>
						@endif


						{!! Form::open([ "class" => "form-horizontal", "method" => "POST", "url" => url('/setup/store-cabin-crew') ]) !!}

						<div class="form-group has-feedback col-md-12">
							<label class="control-label col-sm-3 list">@lang("content.first_name")</label>

							<div class="col-sm-9">
								{!! Form::text('first_name', \request("first_name"), ['class'=>'form-control', 'placeholder'=>'First Name', 'id'=>'first_name' ]) !!}
								<span class="glyphicon glyphicon glyphicon-ok form-control-feedback"></span>
							</div>
						</div>

						<div class="form-group has-feedback col-md-12">
							<label class="control-label col-sm-3 list">@lang("content.last_name")</label>

							<div class="col-sm-9">
								{!! Form::text('last_name', \request("last_name"), ['class'=>'form-control', 'placeholder'=>'Last Name', 'id'=>'last_name']) !!}
								<span class="glyphicon glyphicon glyphicon-ok form-control-feedback"></span>
							</div>
						</div>
						<div class="form-group has-feedback col-md-12">
							<label class="control-label col-sm-3 list text-left">@lang("content.email")</label>

							<div class="col-sm-9">
								{!! Form::email('email', \request("email"), ['class'=>'form-control', 'placeholder'=>'Email', 'id'=>'email']) !!}
								<span class="glyphicon glyphicon glyphicon-ok form-control-feedback"></span>
							</div>
						</div>


						<div class="form-group has-feedback col-md-12">
							<label class="control-label col-sm-3 list text-left">Password*</label>
							<div class="col-sm-9">
								{!! Form::password('password', ['class'=>'input-block-level form-control', 'placeholder'=>'Password']) !!}
								<span class="glyphicon glyphicon glyphicon-ok form-control-feedback"></span>
							</div>
						</div>
						<div class="form-group has-feedback col-md-12">
							<label class="control-label col-sm-3 list text-left">Password Confirmation</label>
							<div class="col-sm-9">
								{!! Form::password('password_confirmation', ['class'=>'input-block-level form-control', 'placeholder' => 'Confirm Password']) !!}
								<span class="glyphicon glyphicon glyphicon-ok form-control-feedback"></span>
							</div>
						</div>

						<div class="form-group">
							<div class="col-md-offset-3 col-md-6">
								{!! Form::submit("Back", ['name' => 'Back', 'class' => 'btn btn-primary'])!!}
								{!! Form::submit("Next", ['name' => 'Next', 'class' => 'btn btn-success'])!!}
							</div>
						</div>
						{!! Form::close() !!}
					</div>
				</div>
			</div>
		</div>
	</div>
@endsection
