@extends($ajaxCall)

@section('css')
	<style>

	</style>
@stop

@section('content')

	@include('setup.wizard', ['step' => 2])

	<div class="container-fluid">
		<div class="row">
			<div class="col-lg-offset-1 col-lg-10 col-lg-offset-1">
				<div class="panel panel-default">
					<div class="panel-heading">Setup / Airline Details</div>
					<div class="panel-body">
						@if (count($errors) > 0)
							<div class="alert alert-danger">
								<strong>Whoops!</strong> There were some problems with your input.<br><br>
								<ul>
									@foreach ($errors->all() as $error)
										<li>{!! $error !!}</li>
									@endforeach
								</ul>
							</div>
						@endif


						{!! Form::open([ "class" => "form-horizontal", "method" => "POST", "url" => url('/setup/store-airline-info') ]) !!}

						<div class="form-group has-feedback col-md-12">
							<label class="control-label col-sm-3 list">Airline Name</label>

							<div class="col-sm-9">
								{!! Form::text('airline_name', \request("airline_name"), ['class'=>'form-control', 'placeholder'=>'Airline Name', 'id'=>'airline_name' ]) !!}
								<span class="glyphicon glyphicon glyphicon-ok form-control-feedback"></span>
							</div>
						</div>

						<div class="form-group has-feedback col-md-12">
							<label class="control-label col-sm-3 list">IATA</label>

							<div class="col-sm-9">
								{!! Form::text('iata', \request("iata"), ['class'=>'form-control', 'placeholder'=>'IATA', 'id'=>'iata' ]) !!}
								<span class="glyphicon glyphicon glyphicon-ok form-control-feedback"></span>
							</div>
						</div>

						<div class="form-group has-feedback col-md-12">
							<label class="control-label col-sm-3 list">ICAO</label>

							<div class="col-sm-9">
								{!! Form::text('icao', \request("icao"), ['class'=>'form-control', 'placeholder'=>'ICAO', 'id'=>'icao']) !!}
								<span class="glyphicon glyphicon glyphicon-ok form-control-feedback"></span>
							</div>
						</div>

						<div class="form-group">
							<div class="col-md-offset-3 col-md-6">
								{!! Form::submit("Back", ['name' => 'Back', 'class' => 'btn btn-primary'])!!}
								{!! Form::submit("Next", ['name' => 'Next', 'class' => 'btn btn-success'])!!}
							</div>
						</div>
						{!! Form::close() !!}
					</div>
				</div>
			</div>
		</div>
	</div>
@endsection
