@extends($ajaxCall)

@section('css')
	<style>

	</style>
@stop

@section('content')

	@include('setup.wizard', ['step' => 3])

	<div class="container-fluid">
		<div class="row">
			<div class="col-lg-offset-1 col-lg-10 col-lg-offset-1">
				<div class="panel panel-default">
					<div class="panel-heading">Setup / Create System Admin</div>
					<div class="panel-body">
						@if (count($errors) > 0)
							<div class="alert alert-danger">
								<strong>Whoops!</strong> There were some problems with your input.<br><br>
								<ul>
									@foreach ($errors->all() as $error)
										<li>{!! $error !!}</li>
									@endforeach
								</ul>
							</div>
						@endif

					{!! Form::open([ "class" => "form-horizontal", "method" => "POST", "url" => url('/setup/store-aircraft-types') ]) !!}

						<div class="col-lg-12 data" style="border-bottom: 1px solid #e3e3e3; margin: 10px 0">
						<div class="form-group has-feedback col-md-12">
							<label class="control-label col-sm-3 list">@lang("content.type")</label>

							<div class="col-sm-9">
								{!! Form::text('first_name', \request("first_name"), ['class'=>'form-control', 'placeholder'=>'', 'id'=>'first_name' ]) !!}
								<span class="glyphicon glyphicon glyphicon-ok form-control-feedback"></span>
							</div>
						</div>

						<div class="form-group has-feedback col-md-12">
							<label class="control-label col-sm-3 list">IATA Name</label>

							<div class="col-sm-9">
								{!! Form::text('last_name', \request("last_name"), ['class'=>'form-control', 'placeholder'=>'', 'id'=>'last_name']) !!}
								<span class="glyphicon glyphicon glyphicon-ok form-control-feedback"></span>
							</div>
						</div>

						<div class="clearfix"></div>

							<div class="form-group has-feedback col-md-12">
								<label class="control-label col-sm-3 list">Flight Crew</label>

								<div class="col-md-3">
									<label class="control-label col-sm-4 list">@lang("content.policy")</label>
									<div class="col-sm-8">
										{!! Form::text('last_name', \request("last_name"), ['class'=>'form-control', 'placeholder'=>'', 'id'=>'last_name']) !!}
									</div>
								</div>

								<div class="col-md-3">
									<label class="control-label col-sm-4 list">@lang("content.minimum")</label>
									<div class="col-sm-8">
										{!! Form::text('last_name', \request("last_name"), ['class'=>'form-control', 'placeholder'=>'', 'id'=>'last_name']) !!}
									</div>
								</div>
							</div>

							<div class="clearfix"></div>

							<div class="form-group has-feedback col-md-12">
								<label class="control-label col-sm-3 list">Cabin Crew</label>

								<div class="col-md-3">
									<label class="control-label col-sm-4 list">@lang("content.policy")</label>
									<div class="col-sm-8">
										{!! Form::text('last_name', \request("last_name"), ['class'=>'form-control', 'placeholder'=>'', 'id'=>'last_name']) !!}
									</div>
								</div>

								<div class="col-md-3">
									<label class="control-label col-sm-4 list">@lang("content.minimum")</label>
									<div class="col-sm-8">
										{!! Form::text('last_name', \request("last_name"), ['class'=>'form-control', 'placeholder'=>'', 'id'=>'last_name']) !!}
									</div>
								</div>
							</div>

							<div class="clearfix"></div>
						</div>

						<div class="col-sm-12">
							<div class="col-xs-2">
								<h5><strong>Add/Remove Type</strong></h5>
							</div>
							<i class="glyphicon glyphicon-plus-sign glyphicon-float add"></i>
							<i class="glyphicon glyphicon-minus-sign glyphicon-float remove"></i>
						</div>

						<div class="form-group">
							<div class="col-md-offset-3 col-md-6">
								{!! Form::submit("Back", ['name' => 'Back', 'class' => 'btn btn-primary'])!!}
								{!! Form::submit("Next", ['name' => 'Next', 'class' => 'btn btn-success'])!!}
							</div>
						</div>
						{!! Form::close() !!}
					</div>
				</div>
			</div>
		</div>
	</div>
@endsection

@section('js_scripts')
	<script>
		$(document).on('click', 'i.glyphicon.add', function () {
			var _this = $(this), parent = _this.parent(), data = parent.prev('.data'),
					dataCopy = data.clone();

			data.after(dataCopy);
			console.log(data)
		});
		$(document).on('click', 'i.glyphicon.remove', function () {
			var _this = $(this), parent = _this.parent(), data = parent.prev('.data'), all = parent.prevAll('.data');

			if (all.length > 1){
				data.remove();
			}
		});
	</script>
@stop