@if ($obj->departure_service)
    @php $duration = ($obj->dep_report_time - $obj->dep_release_time) / 60 @endphp
    @php $class = $duration < 0 ? "bg-danger" : "" @endphp

    <td class="{{ $class }}">{{ $obj->dep_staff_req }}</td>
    <td class="{{ $class }}">{{ $obj->dep_staff_min }}</td>
    @if ($obj->dep_report_time >= 0)
        <td class="{{ $class }}">{{ hoursToTime($obj->dep_report_time / 60, true) }}</td>
    @else
        <td class="{{ $class }}">{{ hoursToTime(-1 * $obj->dep_report_time / 60, true) }} <span class="label label-primary margin_left_10">@lang("content.after_departure")</span></td>
    @endif

    @if ($obj->dep_release_time > 0)
        <td class="{{ $class }}">{{ hoursToTime($obj->dep_release_time / 60, true) }} <span class="label label-primary margin_left_10">@lang("content.before_departure")</span></td>
    @elseif($obj->dep_release_time == 0)
        <td class="{{ $class }}">{{ hoursToTime($obj->dep_release_time / 60, true) }}</td>
    @else
        <td class="{{ $class }}">{{ hoursToTime(-1 * $obj->dep_release_time / 60, true) }}</td>
    @endif

    <td class="{{ $class }}">{{ hoursToTime($duration, true) }}</td>
@else
    <td colspan="5" class="">
        <p class="color-red">Departure service not assigned.</p>
    </td>
@endif