@if ($obj->arrival_service)
    @php $duration = ($obj->arr_report_time + $obj->arr_release_time) / 60 @endphp
    @php $class = $duration < 0 ? "bg-danger" : "" @endphp

    <td class="{{ $class }}">{{ $obj->arr_staff_req }}</td>
    <td class="{{ $class }}">{{ $obj->arr_staff_min }}</td>
    @if ($obj->arr_report_time >= 0)
        <td class="{{ $class }}">{{ hoursToTime($obj->arr_report_time / 60, true) }}</td>
    @else
        <td class="{{ $class }}">{{ hoursToTime(-1 * $obj->arr_report_time / 60, true) }} <span class="label label-primary margin_left_10">@lang("content.after_arrival")</span></td>
    @endif

    @if ($obj->arr_release_time >= 0)
        <td class="{{ $class }}">{{ hoursToTime($obj->arr_release_time / 60, true) }}</td>
    @else
        <td class="{{ $class }}">{{ hoursToTime(-1 * $obj->arr_release_time / 60, true) }} <span class="label label-primary margin_left_10">@lang("content.before_arrival")</span></td>
    @endif

    <td class="{{ $class }}">{{ hoursToTime($duration, true) }}</td>
@else
    <td colspan="5" class="">
        <p class="color-red">Arrival service not assigned.</p>
    </td>
@endif
