<?php require_once(public_path("smart/inc/init.php")); ?>

        <!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            <div class="col-md-12 no-padding margin-bottom-10">
                <a href="{{ route("homepage")."#". url("service/create?s=".rand(100, 999)) }}" class="btn btn-primary">Add New Service</a>
            </div>

            <div class="clearfix"></div>

            <div class="jarviswidget jarviswidget-color-blueDark" id="wid-service" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

                <header>
                    <span class="widget-icon"> <i class="fa fa-table"></i> </span>
                    <h2>@lang("content.service")</h2>
                </header>

                <!-- widget div-->
                <div>

                    <!-- widget edit box -->
                    <div class="jarviswidget-editbox">
                        <!-- This area used as dropdown edit box -->

                    </div>
                    <!-- end widget edit box -->

                    <!-- widget content -->
                    <div class="widget-body no-padding" style="min-height: 50px !important;">

                        <div class="table-responsive">

                            <table class="table table-bordered table-hover" id="service-table">
                                <thead>
                                <tr>
                                    <th rowspan="2">No</th>
                                    <th rowspan="2">@lang("content.service")</th>
                                    <th rowspan="2">Decode</th>
                                    <th rowspan="2">@lang("content.include_all_stations")</th>

                                    <th colspan="5" data-center>@lang("content.turnaround_services")</th>
                                    <th colspan="5" data-center>@lang("content.arrival_services")</th>
                                    <th colspan="5" data-center>@lang("content.departure_services")</th>

                                    <th rowspan="2">@lang("content.actions")</th>
                                </tr>
                                <tr>
                                    <th>@lang("content.staff_req")</th>
                                    <th>@lang("content.staff_min")</th>
                                    <th>Report Time<br/>(mins, before arrival)</th>
                                    <th>@lang("content.release_time")<br/>(mins, after departure)</th>
                                    <th>@lang("content.duration")</th>

                                    <th>@lang("content.staff_req")</th>
                                    <th>@lang("content.staff_min")</th>
                                    <th>Report Time<br/>(mins, before arrival)</th>
                                    <th>@lang("content.release_time")<br/>(mins, after arrival)</th>
                                    <th>@lang("content.duration")</th>

                                    <th>@lang("content.staff_req")</th>
                                    <th>@lang("content.staff_min")</th>
                                    <th>Report Time<br/>(mins, before departure)</th>
                                    <th>@lang("content.release_time")<br/>(mins, after departure)</th>
                                    <th>@lang("content.duration")</th>
                                </tr>
                                </thead>
                                <tbody>
                                @foreach($services as $i => $each)
                                    <tr>
                                        <td data-center>{{ $i + 1 }}</td>
                                        <td><strong>{{ $each->abbr }}</strong></td>
                                        <td>{{ $each->name }}</td>
                                        <td data-center>{!! $each->include_all_stations ? "<span class='glyphicon glyphicon-ok'></span>" : "<span class='glyphicon glyphicon-remove'></span>" !!}</td>

                                        @include("service.layouts.turnaround-service", ["obj" => $each])

                                        @include("service.layouts.arrival-service", ["obj" => $each])

                                        @include("service.layouts.departure-service", ["obj" => $each])

                                        <td>
                                            <a target="_blank" href="{{ route("homepage")."#". url("service/{$each->id}/edit?s=".rand(100, 999)) }}" class="btn btn-warning">@lang("content.edit")</a>
                                            <a href="{{ route("homepage")."#". url("service/{$each->id}/delete") }}" class="btn btn-danger">Delete</a>
                                        </td>
                                    </tr>
                                @endforeach

                                </tbody>

                            </table>

                        </div>

                    </div>

                </div>

            </div>

        </article>

    </div>

</section>

<script type="text/javascript">

    pageSetUp();

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyDateFormats();

        Apply_Multiselect();

        ApplyTableFilter("#table");
    }

    pagefunction();

</script>