<?php require_once(public_path("smart/inc/init.php")); ?>

        <!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            <div class="jarviswidget" id="wid-id-1" data-widget-colorbutton="false" data-widget-editbutton="false" data-widget-custombutton="false">
                <!-- widget options:
                usage: <div class="jarviswidget" id="wid-id-0" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

                data-widget-colorbutton="false"
                data-widget-editbutton="false"
                data-widget-togglebutton="false"
                data-widget-deletebutton="false"
                data-widget-fullscreenbutton="false"
                data-widget-custombutton="false"
                data-widget-collapsed="true"
                data-widget-sortable="false"

                -->
                <header>
                    <span class="widget-icon"> <i class="fa fa-edit"></i> </span>
                    <h2>{{ $service->abbr ." (".$service->name.")"}} </h2>

                </header>

                <!-- widget div-->
                <div>

                    <!-- widget edit box -->
                    <div class="jarviswidget-editbox">
                        <!-- This area used as dropdown edit box -->

                    </div>
                    <!-- end widget edit box -->

                    <!-- widget content -->
                    <div class="widget-body no-padding">

                        {!! Form::open([ 'method' => 'POST', 'class' => 'smart-form', 'url' => url("service/{$service->id}") ]) !!}

                            <fieldset>
                                <div class="row" style="padding: 5px 15px; margin-bottom: 20px;">
                                    <section>
                                        <label class="label col-md-5 color-red">Abbr*</label>
                                        <div class="col-md-1"></div>
                                        <label class="label col-md-5 color-red">@lang("content.name")*</label>

                                        <label class="input col-md-5">{!! Form::text('abbr', $service->abbr, ['required', 'class' => '']) !!}</label>
                                        <div class="col-md-1"></div>
                                        <label class="input col-md-5 col-md-offset-1">{!! Form::text('name', $service->name, ['required',  'class' => '']) !!}</label>
                                    </section>
                                </div>

                                <div class="row" style="padding: 5px 15px; margin-bottom: 20px;">
                                    <section>
                                        <label class="label col-md-5">Effective time from</label>
                                        <div class="col-md-1"></div>
                                        <label class="label col-md-5">Effective time to</label>

                                        <label class="input col-md-5">{!! Form::text('effective_from', $service->effective_from, ['class' => 'timepicker']) !!}</label>
                                        <div class="col-md-1"></div>
                                        <label class="input col-md-5 col-md-offset-1">{!! Form::text('effective_to', $service->effective_to, ['class' => 'timepicker']) !!}</label>
                                    </section>
                                </div>

                                <div class="clearfix"></div>

                                <div class="row" style="padding: 5px 15px;">
                                    <section>
                                        <label class="toggle col-md-2 col-sm-6">
                                            <input value="1" type="checkbox" name="include_all_stations" {!! $service->include_all_stations ? "checked" : ""!!}>
                                            <i data-swchon-text="ON" data-swchoff-text="OFF"></i>
                                            <label class="label color-red">@lang("content.include_all_stations")</label>
                                        </label>
                                    </section>
                                </div>

                                <div class="clearfix"></div>

                            </fieldset>

                            {{--Arrival Services--}}
                            <fieldset>
                                <section>
                                    <label class="toggle col-md-2 col-sm-6">
                                        <input value="1" type="checkbox" name="arrival_service" {!! $service->arrival_service ? "checked" : ""!!}>
                                        <i data-swchon-text="ON" data-swchoff-text="OFF"></i>
                                        <label class="label">@lang("content.arrival_services")</label>
                                    </label>
                                </section>

                                <div class="clearfix"></div>

                                <div class="row" style="padding: 5px 15px;">
                                    <section>
                                        <label class="label col-md-5">@lang("content.staff_req")</label>
                                        <div class="col-md-1"></div>
                                        <label class="label col-md-5">@lang("content.staff_min")</label>

                                        <label class="input col-md-5">{!! Form::input('number', 'arr_staff_req', $service->arr_staff_req, ['class' => '']) !!}</label>
                                        <div class="col-md-1"></div>
                                        <label class="input col-md-5 col-md-offset-1">{!! Form::input('number', 'arr_staff_min', $service->arr_staff_min, ['class' => '']) !!}</label>
                                    </section>
                                </div>

                                <div class="clearfix"></div>

                                <div class="row" style="padding: 5px 15px;">

                                    @php $arrival = true @endphp
                                    @if ($service->arr_report_time >= 0)
                                        @php $reportTime = $service->arr_report_time @endphp
                                    @else
                                        @php $reportTime = -1 * $service->arr_report_time @endphp
                                        @php $arrival = false @endphp
                                    @endif

                                    <section>
                                        <label class="label">Report Time</label>

                                        <label class="input col-md-5">{!! Form::input('number', 'arr_report_time', $reportTime, ['class' => '']) !!}</label>

                                        <div class="col-md-1"></div>

                                        <label class="col-md-5">
                                            <div class="inline-group">
                                                <label class="radio">
                                                    <input type="radio" value="0" name="arr_report_time_type" {!! $arrival ? "checked" : "" !!}>
                                                    <i></i>@lang("content.before_arrival")</label>
                                                <label class="radio">
                                                    <input type="radio" value="1" name="arr_report_time_type" {!! !$arrival ? "checked" : "" !!}>
                                                    <i></i>@lang("content.after_arrival")</label>
                                            </div>
                                        </label>
                                    </section>
                                </div>

                                <div class="row" style="padding: 5px 15px;">
                                    @php $arrival = true @endphp
                                    @if ($service->arr_release_time >= 0)
                                        @php $releaseTime = $service->arr_release_time @endphp
                                    @else
                                        @php $releaseTime = -1 * $service->arr_release_time @endphp
                                        @php $arrival = false @endphp
                                    @endif
                                    <section>
                                        <label class="label">Release Time</label>

                                        <label class="input col-md-5">{!! Form::input('number', 'arr_release_time', $releaseTime, ['class' => '']) !!}</label>

                                        <div class="col-md-1"></div>

                                        <label class="col-md-5">
                                            <div class="inline-group">
                                                <label class="radio">
                                                    <input type="radio" value="1" name="arr_release_time_type" {!! !$arrival ? "checked" : "" !!}>
                                                    <i></i>@lang("content.before_arrival")</label>
                                                <label class="radio">
                                                    <input type="radio" value="0" name="arr_release_time_type" {!! $arrival ? "checked" : "" !!}>
                                                    <i></i>@lang("content.after_arrival")</label>
                                            </div>
                                        </label>
                                    </section>
                                </div>

                            </fieldset>

                            {{--Departure Services--}}
                            <fieldset>
                               <section>
                                   <label class="toggle col-md-2 col-sm-6">
                                       <input value="1" type="checkbox" name="departure_service" {!! $service->departure_service ? "checked" : ""!!}>
                                       <i data-swchon-text="ON" data-swchoff-text="OFF"></i>
                                       <label class="label">@lang("content.departure_services")</label>
                                   </label>
                               </section>

                                <div class="clearfix"></div>

                                <div class="row" style="padding: 5px 15px;">
                                   <section>
                                       <label class="label col-md-5">@lang("content.staff_req")</label>
                                       <div class="col-md-1"></div>
                                       <label class="label col-md-5">@lang("content.staff_min")</label>

                                       <label class="input col-md-5">{!! Form::input('number', 'dep_staff_req', $service->dep_staff_req, ['class' => '']) !!}</label>
                                       <div class="col-md-1"></div>
                                       <label class="input col-md-5 col-md-offset-1">{!! Form::input('number', 'dep_staff_min', $service->dep_staff_min, ['class' => '']) !!}</label>
                                   </section>
                                </div>

                                <div class="clearfix"></div>

                                <div class="row" style="padding: 5px 15px;">
                                    @php $departure = true @endphp
                                    @if ($service->dep_report_time >= 0)
                                        @php $reportTime = $service->dep_report_time @endphp
                                    @else
                                        @php $reportTime = -1 * $service->dep_report_time @endphp
                                        @php $departure = false @endphp
                                    @endif
                                   <section>
                                       <label class="label">Report Time</label>

                                       <label class="input col-md-5">{!! Form::input('number', 'dep_report_time', $reportTime, ['class' => '']) !!}</label>

                                       <div class="col-md-1"></div>

                                       <label class="col-md-5">
                                           <div class="inline-group">
                                               <label class="radio">
                                                   <input type="radio" value="0" name="dep_report_time_type" {!! $departure ? "checked" : "" !!}>
                                                   <i></i>@lang("content.before_departure")</label>
                                               <label class="radio">
                                                   <input type="radio" value="1" name="dep_report_time_type" {!! !$departure ? "checked" : "" !!}>
                                                   <i></i>@lang("content.after_departure")</label>
                                           </div>
                                       </label>
                                   </section>
                                </div>

                                <div class="row" style="padding: 5px 15px;">
                                    @php $departure = true @endphp
                                    @if ($service->dep_release_time >= 0)
                                        @php $releaseTime = $service->dep_release_time @endphp
                                    @else
                                        @php $releaseTime = -1 * $service->dep_release_time @endphp
                                        @php $departure = false @endphp
                                    @endif
                                    <section>
                                        <label class="label">Release Time</label>

                                        <label class="input col-md-5">{!! Form::input('number', 'dep_release_time', $releaseTime, ['class' => '']) !!}</label>

                                        <div class="col-md-1"></div>

                                        <label class="col-md-5">
                                            <div class="inline-group">
                                                <label class="radio">
                                                    <input type="radio" value="0" name="dep_release_time_type" {!! $departure ? "checked" : "" !!}>
                                                    <i></i>@lang("content.before_departure")</label>
                                                <label class="radio">
                                                    <input type="radio" value="1" name="dep_release_time_type" {!! !$departure ? "checked" : "" !!}>
                                                    <i></i>@lang("content.after_departure")</label>
                                            </div>
                                        </label>
                                    </section>
                                </div>

                            </fieldset>

                            {{--Turnaround Services--}}
                            <fieldset>
                                <section>
                                    <label class="toggle col-md-2 col-sm-6">
                                        <input value="1" type="checkbox" name="turnaround_service" {!! $service->turnaround_service ? "checked" : ""!!}>
                                        <i data-swchon-text="ON" data-swchoff-text="OFF"></i>
                                        <label class="color-blue">@lang("content.turnaround_services")</label>
                                    </label>
                                </section>

                                <div class="clearfix"></div>

                                <div class="row" style="padding: 5px 15px;">
                                    <section>
                                        <label class="label col-md-5">@lang("content.staff_req")</label>
                                        <div class="col-md-1"></div>
                                        <label class="label col-md-5">@lang("content.staff_min")</label>

                                        <label class="input col-md-5">{!! Form::input('number', 'turn_staff_req', $service->turn_staff_req, ['class' => '']) !!}</label>
                                        <div class="col-md-1"></div>
                                        <label class="input col-md-5 col-md-offset-1">{!! Form::input('number', 'turn_staff_min', $service->turn_staff_min, ['class' => '']) !!}</label>
                                    </section>
                                </div>

                                <div class="clearfix"></div>

                                <div class="row" style="padding: 5px 15px;">
                                    @php $arrival = true @endphp
                                    @if ($service->turn_report_time >= 0)
                                        @php $reportTime = $service->turn_report_time @endphp
                                    @else
                                        @php $reportTime = -1 * $service->turn_report_time @endphp
                                        @php $arrival = false @endphp
                                    @endif

                                    <section>
                                        <label class="label">Report Time</label>

                                        <label class="input col-md-5">{!! Form::input('number', 'turn_report_time', $reportTime, ['class' => '']) !!}</label>

                                        <div class="col-md-1"></div>

                                        <label class="col-md-5">
                                            <div class="inline-group">
                                                <label class="radio">
                                                    <input type="radio" value="0" name="turn_report_time_type" {!! $arrival ? "checked" : "" !!}>
                                                    <i></i>@lang("content.before_arrival")</label>
                                                <label class="radio">
                                                    <input type="radio" value="1" name="turn_report_time_type" {!! !$arrival ? "checked" : "" !!}>
                                                    <i></i>@lang("content.after_arrival")</label>
                                            </div>
                                        </label>
                                    </section>
                                </div>

                                <div class="row" style="padding: 5px 15px;">
                                    @php $departure = true @endphp
                                    @if ($service->turn_release_time >= 0)
                                        @php $releaseTime = $service->turn_release_time @endphp
                                    @else
                                        @php $releaseTime = -1 * $service->turn_release_time @endphp
                                        @php $departure = false @endphp
                                    @endif
                                    <section>
                                        <label class="label">Release Time</label>

                                        <label class="input col-md-5">{!! Form::input('number', 'turn_release_time', $releaseTime, ['class' => '']) !!}</label>

                                        <div class="col-md-1"></div>

                                        <label class="col-md-5">
                                            <div class="inline-group">
                                                <label class="radio">
                                                    <input type="radio" value="0" name="turn_release_time_type" {!! $departure ? "checked" : "" !!}>
                                                    <i></i>@lang("content.before_departure")</label>
                                                <label class="radio">
                                                    <input type="radio" value="1" name="turn_release_time_type" {!! !$departure ? "checked" : "" !!}>
                                                    <i></i>@lang("content.after_departure")</label>
                                            </div>
                                        </label>
                                    </section>
                                </div>

                            </fieldset>

                            <fieldset>
                                <section>
                                   <label class="label">{!! Form::submit("Save", ['class' => 'btn btn-success btn-sm']) !!}</label>
                                </section>
                            </fieldset>

                        {!! Form::close() !!}

                    </div>

                </div>

            </div>

        </article>

    </div>

</section>

<script type="text/javascript">

    pageSetUp();

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyDateFormats();

        Apply_Multiselect();
    }

    pagefunction();

</script>