<div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-stock" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

        <header>

            <span class="widget-icon"> <i class="fa fa-table"></i> </span>

            <h2>@lang("content.calculated_stock")</h2>

        </header>

        <!-- widget div-->
        <div>

            <!-- widget edit box -->
            <div class="jarviswidget-editbox">
                <!-- This area used as dropdown edit box -->

            </div>
            <!-- end widget edit box -->

            <!-- widget content -->
            <div class="widget-body no-padding">

                <div class="table-responsive">

                    @if (isset($SCMs) && count($SCMs))

                        <table class="table table-bordered table-hover" id="stock-table" style="min-width: 100%">

                            <thead>
                            <tr>
                                <th>No</th>
                                <th>@lang("content.status")</th>
                                <th>@lang("content.airline")</th>
                                <th>@lang("content.airport")</th>
                                <th>@lang("content.date")</th>
                                <th>@lang("content.created") </th>
                                <th>@lang("content.actions")</th>
                            </tr>
                            </thead>

                            <tbody>
                            @foreach($SCMs as $j => $each)

                                @php $airline = $each->airline @endphp
                                @php $airport = $each->airport @endphp

                                <tr>
                                    <td>{{ $j + 1 }}</td>
                                    <td>{!! $each->deleted_at ? '<span class="label label-danger">DELETED</span>' : '<span class="label label-success">ACTIVE</span>' !!}</td>
                                    <td>{{ getAirlineCode($airline) }}</td>
                                    <td>{{ $airport->iata }}</td>
                                    <td>{{ $each->scm_datetime }}</td>
                                    <td>{{ $each->createdBy ? $each->createdBy->first_name." ".$each->createdBy->last_name : "-" }}</td>
                                    <td>
                                        <div class="btn-group">
                                            @if ($each->deleted_at)
                                                <a class="btn btn-primary" href="{{ route("homepage")."#". url("scm-report/restore/{$each->id}") }}">@lang("content.restore")</a>
                                            @else
                                                <a class="btn btn-danger" href="{{ route("homepage")."#". url("scm-report/delete/{$each->id}") }}">@lang("content.remove")</a>
                                            @endif
                                        </div>
                                    </td>
                                </tr>

                            @endforeach
                            </tbody>

                        </table>

                    @endif

                </div>

            </div>

        </div>

    </div>

