{!! Form::open(["url" => "scm-report", 'method' => "POST", "class" => "form-horizontal"]) !!}

    <div class="col-sm-6">
        {{--Calculated Table--}}
        <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-stock" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

            <header>

                <span class="widget-icon"> <i class="fa fa-table"></i> </span>

                <h2>@lang("content.calculated_stock")</h2>

            </header>

            <!-- widget div-->
            <div>

                <!-- widget edit box -->
                <div class="jarviswidget-editbox">
                    <!-- This area used as dropdown edit box -->

                </div>
                <!-- end widget edit box -->

                <!-- widget content -->
                <div class="widget-body no-padding">

                    <div class="table-responsive">

                        @if (isset($stockULDs) && count($stockULDs))

                            <table class="table table-bordered table-hover" id="stock-table" style="min-width: 100%">

                                <thead>
                                <tr>
                                    <th>No</th>
                                    <th>ID</th>
                                    <th>@lang("content.in_stock")</th>
                                </tr>
                                </thead>

                                <tbody>
                                @foreach($stockULDs as $j => $uld)

                                    @php $container = $uld->container @endphp

                                    @if (!$container)
                                        @continue
                                    @endif

                                    @php $type = $container->type @endphp
                                    @php $containerID = $container ? ($type ? $type->name : "").$container->num.$container->owner : "-" @endphp

                                    @php $lastInfo = $uld->getLastContainerInfo() @endphp

                                    @php $content = $container->id."_".($lastInfo ? $lastInfo->id : 0) @endphp

                                    <tr>
                                        <td style="padding: 3px 8px; vertical-align: middle;">{{ $j + 1 }}</td>
                                        <td style="padding: 3px 8px; vertical-align: middle;"><a target="_blank" href="{{ route("homepage")."#uld-report/{$container->id}?dateSearch=all" }}">{{ $containerID }}</a></td>
                                        <td style="padding: 3px 8px; vertical-align: middle;">{!! Form::checkbox("st[]", $content, true, ['class' => 'form-control'] ) !!}</td>
                                    </tr>

                                @endforeach
                                </tbody>

                            </table>

                        @endif

                    </div>

                </div>

            </div>

        </div>

    </div>

    <div class="col-sm-6">
        {{--Manual Table--}}
        <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-stock-manual" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

            <header>

                <span class="widget-icon"> <i class="fa fa-table"></i> </span>

                <h2>@lang("content.manual_input")</h2>

            </header>

            <!-- widget div-->
            <div>

                <!-- widget edit box -->
                <div class="jarviswidget-editbox">
                    <!-- This area used as dropdown edit box -->

                </div>
                <!-- end widget edit box -->

                <!-- widget content -->
                <div class="widget-body no-padding">

                    <div class="table-responsive">

                            <table class="table table-bordered table-hover" id="stock-manual-table" style="min-width: 100%">

                                <thead>
                                <tr>
                                    <th>No</th>
                                    <th colspan="2">@lang("content.type")</th>
                                    <th>ID</th>
                                    <th>@lang("content.owner")</th>
                                </tr>
                                </thead>

                                <tbody>
                                <tr class="data" data-num="1">
                                    <td>1</td>
                                    <td style="width: 15%">
                                        {!! Form::select('type[]', $uldTypes, null, ['class' => 'form-control']) !!}
                                    </td>
                                    <td>
                                        {!! Form::text("oType[]",   null, [ 'class' => 'form-control', 'placeholder' => 'Type', 'maxlength' => 3, "disabled" ]) !!}
                                    </td>
                                    <td style="width: 50%">{!! Form::text("uld[]",     null, ['style' => 'width: 100%;', 'class' => 'form-control', 'placeholder' => 'ULD ID' ]) !!}</td>
                                    <td>{!! Form::text("owner[]",   $owner ? $owner->iata : null, ['style' => 'width: 100%;', 'class' => 'form-control', 'placeholder' => 'Owner', 'required' => 'required', 'maxlength' => 2 ]) !!}</td>
                                </tr>
                                <tr class="actions">
                                    <td></td>
                                    <td colspan="4">
                                        <div class="btn-group">
                                            <a class="btn btn-success add_manual_stock">@lang("content.add")</a>
                                            <a class="btn btn-danger remove_manual_stock">@lang("content.remove")</a>
                                        </div>
                                    </td>
                                </tr>

                                </tbody>

                            </table>

                    </div>

                </div>

            </div>

        </div>

        {{--Save--}}
        <div>
            {!! Form::hidden("datetime", $datetime) !!}
            {!! Form::hidden("airline",  $airline) !!}
            {!! Form::hidden("airport",  $airport) !!}
            {!! Form::submit( trans("content.save"), ['class' => 'btn btn-primary']) !!}
        </div>

    </div>

{!! Form::close() !!}

