<?php
/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov
 * Date: 02.09.14

 */
?>



<?php require_once(public_path("smart/inc/init.php")); ?>

        <!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-sm-12 col-md-6 col-lg-4">

           @include('sales-organisation.profile-page-tab')

        </article>

        <!-- NEW WIDGET START -->
        <article class="col-sm-12 col-md-12 col-lg-8">

            <!-- Widget ID (each widget will need unique ID)-->
            <div class="jarviswidget" id="wid-id-7" data-widget-editbutton="false" data-widget-fullscreenbutton="false" data-widget-custombutton="false" data-widget-sortable="false">

                <header>
                    <ul class="nav nav-tabs pull-left in">
                        <li class="">
                            <a data-toggle="tab" href="#hr2"><i class="fa fa-lg fa-arrow-circle-o-up"></i>
                                <span class="hidden-mobile hidden-tablet"> Map</span>
                            </a>
                        </li>

                        <li class="">
                            <a data-toggle="tab" href="#hr1"><i class="fa fa-lg fa-arrow-circle-o-down"></i>
                                <span class="hidden-mobile hidden-tablet"> Organisation</span>
                            </a>
                        </li>

                        <li class="active">
                            <a data-toggle="tab" href="#hr3"><i class="fa fa-lg fa-arrow-circle-o-down"></i>
                                <span class="hidden-mobile hidden-tablet"> Sales Calls</span>
                            </a>
                        </li>

                        <li class="">
                            <a data-toggle="tab" href="#hr4"><i class="fa fa-lg fa-arrow-circle-o-down"></i>
                                <span class="hidden-mobile hidden-tablet"> Sales Dashboard</span>
                            </a>
                        </li>
                    </ul>
                </header>

                <!-- widget div-->
                <div>

                    <!-- widget edit box -->
                    <div class="jarviswidget-editbox">
                        <!-- This area used as dropdown edit box -->

                    </div>
                    <!-- end widget edit box -->

                    <!-- widget content -->
                    <div class="widget-body">

                        <div class="tab-content">
                            <div class="tab-pane" id="hr2">
                                <div id="map_canvas" style="height: 700px;"></div>
                            </div>

                            <div class="tab-pane" id="hr1">
                                @include('sales-organisation.profile-organisation-tab')
                            </div>

                            <div class="tab-pane active" id="hr3" style="">
                                @include('sales-organisation.profile-sales-calls-tab')
                            </div>

                            <div class="tab-pane" id="hr4">

                            </div>
                        </div>

                    </div>
                    <!-- end widget content -->

                </div>
                <!-- end widget div -->

            </div>
            <!-- end widget -->

        </article>


    </div>

</section>



<script type="text/javascript">

    pageSetUp();

    var pagefunction = function() {

        loadScript("<?php echo ASSETS_URL; ?>/js/plugin/bootstraptree/bootstrap-tree.min.js");

        ApplyFormSubmit();

        ApplyValidationDateFormats();

        Apply_Multiselect();

        ApplyTableFilter("#table");

        $('.progress-bar').progressbar({
            display_text : 'fill'
        });

        var date = new Date();
        var d = date.getDate();
        var m = date.getMonth();
        var y = date.getFullYear();

        var hdr = {
            left: 'title',
            center: 'month,agendaWeek,agendaDay',
            right: 'prev,today,next'
        };

        fullviewcalendar = $('#calendar').fullCalendar({

            header: hdr,
            buttonText: {
//                prev: '<i class="fa fa-chevron-left"></i>',
//                next: '<i class="fa fa-chevron-right"></i>'
            },

            editable: false,
            droppable: false, // this allows things to be dropped onto the calendar !!!

            drop: function (date, allDay) { // this function is called when something is dropped

                // retrieve the dropped element's stored Event Object
                var originalEventObject = $(this).data('eventObject');

                // we need to copy it, so that multiple events don't have a reference to the same object
                var copiedEventObject = $.extend({}, originalEventObject);

                // assign it the date that was reported
                copiedEventObject.start = date;
                copiedEventObject.allDay = allDay;

                // render the event on the calendar
                // the last `true` argument determines if the event "sticks" (http://arshaw.com/fullcalendar/docs/event_rendering/renderEvent/)
                $('#calendar').fullCalendar('renderEvent', copiedEventObject, true);

                // is the "remove after drop" checkbox checked?
                if ($('#drop-remove').is(':checked')) {
                    // if so, remove the element from the "Draggable Events" list
                    $(this).remove();
                }

            },

            select: function (start, end, allDay) {
                var title = prompt('Event Title:');
                if (title) {
                    calendar.fullCalendar('renderEvent', {
                                title: title,
                                start: start,
                                end: end,
                                allDay: allDay
                            }, true // make the event "stick"
                    );
                }
                calendar.fullCalendar('unselect');
            },

            events: {!! json_encode($salesCalls) !!},

            eventRender: function (event, element, icon) {
                if (!event.description == "") {
                    element.find('.fc-event-title').append("<br/><span class='ultra-light'>" + event.description +
                            "</span>");
                }
                if (!event.icon == "") {
                    element.find('.fc-event-title').append("<i class='air air-top-right fa " + event.icon +
                            " '></i>");
                }
            },

            windowResize: function (event, ui) {
                $('#calendar').fullCalendar('render');
            }
        });

        drawMap();

        function drawMap() {

            var mapOptions = {
                center: new google.maps.LatLng(0, 0),
                zoom: 2,
            };

            new google.maps.Map(document.getElementById('map_canvas'), mapOptions);
        }

        var  date_from = $("input[name=date_from]"),
             date_to = $("input[name=date_to]"),
             description = $("#description");

        function cleanForm(){
            var icon = $("input[type=radio][name=iconselect]:first");
            $('input[type=radio][name=iconselect]').removeAttr('checked');
            console.log(icon)
            $("input[type=radio][name=priority]:first").attr('checked', true);
            date_from.val("");
            date_to.val("");
            description.val("");
        }

        function showMessage(prependParent, message){
            var successBox = $(document).find("#success_box");
            if (successBox.length == 1){
                successBox.text(message);
            }
            else {
                success_box.text(message);
                prependParent.prepend(success_box);
            }
        }

        $("#add-sales-call").on("click",function(){
            var _this = $(this), parent_form = _this.parents("form"), _parent = parent_form.parent(),
                 icon = $("input[type=radio][name=iconselect]:checked").val(),
                 color = $("input[type=radio][name=priority]:checked").val();

            if (!$("#add-sales-call-form").valid()){
                showMessage(_parent, "Please fill out required fields");
                return;
            }

            var request = $.ajax({
                headers: {
                    'x-csrf-token': parent_form.find('input[name=_token]').val()
                },
                url: baseUrl + "/sales-organisation/ajax-add-sales-call",
                type : "POST",
                data : {
                    'icon'          : icon,
                    'color'         : color,
                    'date_from'     : date_from.val(),
                    'date_to'       : date_to.val(),
                    'description'   : description.val(),
                }
            });

            request.done(function (data) {
                if (typeof data.success !== 'undefined'){
                    if (data.success){
                        cleanForm();
                    }
                    showMessage(_parent, data.message);

                }
            });
            request.fail(function (jqXHR, text_status) {
                showMessage(_parent, "Error! Connection time out.");
            });
        });
    };

    $(window).unbind('gMapsLoaded');
    $(window).bind('gMapsLoaded', function(){
        loadScript("<?php echo ASSETS_URL; ?>/js/plugin/bootstrap-progressbar/bootstrap-progressbar.min.js", function(){
            loadScript("<?php echo ASSETS_URL; ?>/js/plugin/fullcalendar/jquery.fullcalendar.min.js", pagefunction);
        });
    });
    window.loadGoogleMaps();

</script>
