<div class="col-sm-12 col-md-12 col-lg-12 padding-15">
    <div class="well well-light well-sm">

        <div class="row">

            <div class="col-sm-12">

                <div class="row">

                    @php $picture = $organization->thumb ? $organization->thumb : 'profile.png'; @endphp

                    <div class="col-sm-3 profile-pic">
                        <a href="{{ route("homepage")."#". url("user/{$organization->user_id}") }}">
                            <img style="max-height: 100px;" src="{{ asset('/storage/users/'.$picture) }}" class=""/>
                        </a>
                        <div class="padding-10">
                            <h4 class="font-md"><strong>{{ $organization->level }}</strong>
                                <br>
                                <small>Level</small></h4>
                            <br>
                            <h4 class="font-md"><strong>{{ count($organization->reportees) }}</strong>
                                <br>
                                <small>Direct Reportees</small></h4>

                        </div>
                    </div>

                    <div class="col-sm-9">
                        <h1>{{ $organization->first_name }} <span class="semi-bold">{{ $organization->last_name }}</span>
                            <br>
                            <small> {{ $organization->position }}</small></h1>

                        <ul class="list-unstyled">
                            <li>
                                <p class="text-muted">
                                    <i class="fa fa-chevron-circle-up"></i>&nbsp;&nbsp;<span class="txt-color-darken">Reports To:
                                        @if ($organization->report_to_id)
                                            <a href="{{ route("homepage")."#". url('sales-organisation/profile/'.$organization->report_to_id) }}">{{  $organization->report_to }}</a>
                                        @else
                                            {{ $organization->report_to }}
                                        @endif
                                    </span>
                                </p>
                            </li>
                            <li>
                                <p class="text-muted">
                                    <i class="fa fa-list-alt"></i>&nbsp;&nbsp;<span class="txt-color-darken">{{ !$organization->support_staff ? "Accountable Manager" : "Support Staff" }}</span>
                                </p>
                            </li>
                            <li>
                                <p class="text-muted">
                                    <i class="fa fa-phone"></i>&nbsp;&nbsp;(<span class="txt-color-darken">313</span>) <span class="txt-color-darken">464</span> - <span class="txt-color-darken">6473</span>
                                </p>
                            </li>
                            <li>
                                <p class="text-muted">
                                    <i class="fa fa-envelope"></i>&nbsp;&nbsp;<a href="mailto:{{ $organization->user->email }}">{{ $organization->user->email }}</a>
                                </p>
                            </li>
                            <li>
                                <p class="text-muted">
                                    <i class="fa fa-calendar"></i>&nbsp;&nbsp;<span class="txt-color-darken">DOJ: {{ $organization->user->doj ?  baseDateFormat($organization->user->doj, false, "-") : "N/A" }}</span>
                                </p>
                            </li>
                            <li>
                                <p class="text-muted">
                                    <i class="fa fa-dollar"></i>&nbsp;&nbsp;<span class="txt-color-darken">Target: {{ $organization->target['yearly'] ? number_format($organization->target['yearly']->target) : "N/A" }}</span>
                                </p>
                            </li>
                            @if (count($organization->tableInfo))
                                <li>
                                    <p class="text-muted">
                                        <i class="fa fa-sitemap"></i>&nbsp;&nbsp;<span class="txt-color-darken">Accountable For
                                            @foreach($organization->tableInfo as $pos => $values)
                                                {!!  ucwords($pos)." : <br/>".implode('<br/>', $values) !!}<br/>
                                            @endforeach
                                                </span>
                                    </p>
                                </li>
                            @endif

                            <div>
                                <a href="{{ route("homepage")."#". url('organization/new-chart/'.$organization->id) }}" class="btn btn-success">Display</a>
                                <a href="{{ route("homepage")."#". url('organization/'.$organization->id."/edit?s=".rand(100, 999)) }}" class="btn btn-primary">@lang("content.edit")</a>

                                {!! Form::open(['method' => 'DELETE', 'data-same_url', 'class' => 'inline', 'url' =>  url('organization/'.$organization->id) ]) !!}
                                {!! Form::submit('Delete', [ 'class' => "btn btn-danger"]) !!}
                                {!! Form::close() !!}
                            </div>

                        </ul>
                    </div>

                </div>

                <div class="row">

                    <div class="col-md-12">
                        @if ($organization->target['yearly'] || $organization->target['quarterly'] || $organization->target['monthly'])
                            <div class="well no-padding">
                                <div class="bar-holder no-margin">
                                    @if ($organization->target['yearly'])
                                        @php $value = $performance['yearly']['accomplished'] @endphp
                                        <span class="col-sm-4">Yearly</span>
                                        <div class="progress">
                                            <div class="progress-bar {{ $performance['yearly']['status'] }}" aria-valuetransitiongoal="{{ $value }}"></div>
                                        </div>
                                    @endif

                                    @if ($organization->target['quarterly'])
                                        @php $value = $performance['quarterly']['accomplished'] @endphp
                                        @php $max = (int)($value / 100) * 100 + 100 @endphp
                                        {{ debug("VALUE: ".$value." / MAX: ".$max) }}
                                        <br/>
                                        <span class="col-sm-4">Q{{ $organization->target['quarterly']->quarter }}</span>
                                        <div class="progress">
                                            <div class="progress-bar {{ $performance['quarterly']['status'] }}" aria-valuemax="" aria-valuetransitiongoal="{{ $value }}"></div>
                                        </div>
                                    @endif

                                    @if ($organization->target['monthly'])
                                        @php $value = $performance['monthly']['accomplished'] @endphp
                                        <br/>
                                        <span class="col-sm-4">{{ date("F") }}</span>
                                        <div class="progress">
                                            <div class="progress-bar {{ $performance['monthly']['status'] }}" aria-valuetransitiongoal="{{ $value }}"></div>
                                        </div>
                                    @endif
                                </div>

                                <div class="" style="margin: 20px; margin-top: 0; display: inline-block">
                                    <span>Target Accomplishment</span><br/>
                                    <span class="label bg-color-red">Below 90%</span>
                                    <span class="label bg-color-orange">90%-100%</span>
                                    <span class="label bg-color-greenLight">101%-110%</span>
                                    <span class="label bg-color-green">111%-150%</span>
                                    <span class="label bg-color-blue">Over 150%</span>
                                </div>
                            </div>
                        @endif


                    </div>

                </div>

            </div>

        </div>
    </div>

</div>
