@if (count($revenue_targets))
    <div class="list-my-group">
        <div class="head">
            <div>
                <div style="width: 5%">No.</div>
                <div style="width: 5%">@lang("content.picture")</div>
                <div style="width: 10%" data-left>Accountable</div>
                <div style="width: 25%" data-left>Level / Position</div>
                <div style="width: 5%" data-left>@lang("content.type")</div>
                <div style="width: 10%">@lang("content.from")</div>
                <div style="width: 10%">@lang("content.to")</div>
                <div style="width: 15%">Target</div>
                <div style="width: 15%">@lang("content.actions")</div>
            </div>
        </div>
        <div class="body">

            @foreach($periods as $i => $each)
                @php $organization   = $each->organization; @endphp
                @php $level          = $organization->organizationLevel; @endphp
                @php $user           = $organization->user; @endphp
                @php $position       = $organization->position; @endphp
                @php $picture        = !is_null($user->thumb) ? $user->thumb : 'profile.png'; @endphp
                <div class="period" data-id ="{{ $each->id }}">
                    <div style="width: 5%; min-width: 5%">{{ $i + 1 }}</div>
                    <div style="width: 5%; min-width: 5%"><img height="100%" class="img-thumbnail thumb_report"  src="{{ asset("storage/users/{$user->picture}") }}"></div>
                    <div style="width: 10%; min-width: 10%" data-left>{{ $user->first_name." ".$user->last_name }}</div>
                    <div style="width: 25%; min-width: 25%" data-left>{{ "-".$level->level."- ".$position->name }}</div>
                    <div style="width: 5%; min-width: 5%" data-left>Yearly</div>
                    <div style="width: 10%; min-width: 10%">{{ baseDateFormat($each->period_from) }}</div>
                    <div style="width: 10%; min-width: 10%">{{ baseDateFormat($each->period_to) }}</div>
                    <div style="width: 15%; min-width: 15%">{{ number_format($each->target)." ".$each->currency->code }}</div>
                    <div style="width: 10%; min-width: 10%">

                    </div>
                </div>
            @endforeach

            @php $j = 1 @endphp
            @foreach($revenue_targets as $i => $each)
                @php $picture        = !is_null($each->thumb) ? $each->thumb : 'profile.png'; @endphp
                @php $type_id        = $each->type->id @endphp
                @php $type           = $each->type->type @endphp
                @php $organization   = $each->organization @endphp
                @php $level          = $organization->organizationLevel; @endphp
                @php $position       = $organization->position ? $organization->position->name : "" @endphp
                @php $user           = $organization->user @endphp
                @php $currency       = $each->period->currency @endphp
                @if(in_array($type, ['Monthly']))
                    <div style="margin-left:60px; margin-right: 60px; display: none" class="target_m monthly" data-parent_id="{{ $each->parent_id }}">
                        <div style="width: 5%; min-width: 5%"></div>
                        <div style="width: 5%; min-width: 5%"></div>
                        <div style="width: 10%; min-width: 10%" data-left></div>
                        <div style="width: 25%; min-width: 25%" data-left></div>
                        <div style="width: 5%; min-width: 5%" data-left>{{ getMonthName($each->period_from) }}</div>
                        <div style="width: 10%; min-width: 10%">{{ baseDateFormat($each->period_from) }}</div>
                        <div style="width: 10%; min-width: 10%">{{ baseDateFormat($each->period_to) }}</div>
                        <div style="width: 15%; min-width: 15%">{{ number_format($each->target)." ".$currency->code }}</div>
                        <div style="width: 10%; min-width: 10%">

                        </div>
                    </div>
                @elseif(in_array($type, ['Quarterly']))
                    <div style="margin-left:40px; margin-right: 40px; display: none" class="target_q quarterly" data-id ="{{ $each->id }}" data-parent_id="{{ $each->parent_id }}">
                        <div style="width: 5%; min-width: 5%"></div>
                        <div style="width: 5%; min-width: 5%"></div>
                        <div style="width: 10%; min-width: 10%" data-left></div>
                        <div style="width: 25%; min-width: 25%" data-left></div>
                        <div style="width: 5%; min-width: 5%" data-left>QTR {{ $each->quarter }}</div>
                        <div style="width: 10%; min-width: 10%">{{ baseDateFormat($each->period_from) }}</div>
                        <div style="width: 10%; min-width: 10%">{{ baseDateFormat($each->period_to) }}</div>
                        <div style="width: 15%; min-width: 15%">{{ number_format($each->target)." ".$currency->code }}</div>
                        <div style="width: 10%; min-width: 10%">

                        </div>
                    </div>
                @else
                    <div class="target_y yearly" style="margin-left:20px; margin-right: 20px; display: none" data-id ="{{ $each->id }}" data-parent_id = {{ $each->period_id }}>
                        <div style="width: 5%; min-width: 5%">{{ $j ++ }}</div>
                        <div style="width: 5%; min-width: 5%"><img height="100%" class="img-thumbnail thumb_report"  src="{{ asset("storage/users/{$user->picture}") }}"></div>
                        <div style="width: 10%; min-width: 10%" data-left>{{ $user->first_name." ".$user->last_name }}</div>
                        <div style="width: 25%; min-width: 25%" data-left>{{ "-".$level->level."- ".$position }}</div>
                        <div style="width: 5%; min-width: 5%" data-left>{{ $type }}</div>
                        <div style="width: 10%; min-width: 10%">{{ baseDateFormat($each->period_from) }}</div>
                        <div style="width: 10%; min-width: 10%">{{ baseDateFormat($each->period_to) }}</div>
                        <div style="width: 15%; min-width: 15%">{{ number_format($each->target)." ".$currency->code }}</div>
                        <div style="width: 15%; min-width: 15%">
                            {!! Form::open(['method' => 'PUT', 'class' => 'form-horizontal', 'url' => url("/revenue-target/{$each->id}/restore")]) !!}
                                {!! Form::submit('Restore', ['class' => 'btn btn-warning']) !!}
                            {!! Form::close() !!}

                        </div>
                    </div>
                @endif
            @endforeach
        </div>
    </div>
@endif
