@php $period                         = isset($period) ? $period : null @endphp
@php $period_disabled                = isset($period_disabled) ? "disabled" : "" @endphp
@php $organization_level             = isset($organization_level) ? $organization_level : null @endphp
@php $organization_level_disabled    = isset($organization_level_disabled) ? "disabled" : "" @endphp
@php $organization_id                = isset($organization_id) ? $organization_id : null @endphp
@php $organization_id_disabled       = isset($organization_id_disabled) ? "disabled" : "" @endphp
@php $target                         = isset($target) ? number_format($target) : null @endphp
@php $currentLevelEmployees          = isset($currentLevelEmployees) ? $currentLevelEmployees : [] @endphp

<div class="col-lg-12 list-header">
    <div class="col-md-5 list">Period <a id="period_refresh" href="#"><i class="glyphicon glyphicon-refresh"></i></a></div>
    <div class="col-md-7">
        {!! Form::select('period_id', $periods, $period, ['id' => 'period_id', 'class' => 'form-control', 'required' => 'required', $period_disabled]) !!}
        @if (isset($report_types_selected[0]))
            {!! Form::hidden('type_id', $report_types_selected[0]) !!}
        @endif
    </div>
</div>

<div class="col-lg-12 list-header">
    <div class="col-md-5 list">Level</div>
    <div class="col-md-7">
        {!! Form::select('organization_level_id', $organization_levels, $organization_level, ['id'=>'organization_level_id', 'class' => 'form-control', 'required' => 'required', $organization_level_disabled]) !!}
    </div>
</div>

<div class="col-lg-12 list-header added">
    <div class="col-md-5 list">Accountable <a id="accountable_refresh" href="#"><i class="glyphicon glyphicon-refresh"></i></a></div>
    <div class="col-md-7">
        {!! Form::select('organization_id', $currentLevelEmployees, $organization_id, ['id'=>'organization_id', 'class' => 'form-control', 'required' => 'required', $organization_id_disabled]) !!}
    </div>
</div>


<div class="col-lg-12 list-header">
    <div class="col-md-5 list">@lang("content.from")</div>
    <div class="col-md-7">
        {!! Form::text('period_from', null, ['class'=>'form-control', 'placeholder'=>'Period From', 'id'=>'period_from', 'required' => 'required', 'readonly']) !!}
    </div>
</div>

<div class="col-lg-12 list-header">
    <div class="col-md-5 list">@lang("content.to")</div>
    <div class="col-md-7">
        {!! Form::text('period_to', null, ['class'=>'form-control', 'placeholder'=>'Period To', 'id'=>'period_to', 'required' => 'required', 'readonly']) !!}
    </div>
</div>

<div class="col-lg-12 list-header">
    <div class="col-md-5 list">Target <a id="target_refresh" href="#"><i class="glyphicon glyphicon-refresh"></i></a></div>
    <div class="col-md-7">
        {!! Form::input('text', 'target', $target, ['class'=>'form-control', 'onkeyup' => "this.value=AddCommasAndSplitTarget(this.value);", 'placeholder'=>'Target', 'id'=>'target', 'required' => 'required']) !!}
    </div>
</div>

{{--<div class="col-lg-12 list-header">
    <div class="col-md-5 list">Currency</div>
    <div class="col-md-7">
        {!! Form::select('currency_id', $currencies, null, ['class' => 'form-control', 'required' => 'required']) !!}
    </div>
</div>--}}

<div class="col-lg-12 list-header">
    <div class="col-md-5 list">Quarter Share <a id="quarter_shares_refresh" href="#"><i class="glyphicon glyphicon-refresh"></i></a></div>
    <div class="col-md-7">
        {!! Form::input('number', '', 25, ['id' => 'target_q1_share', 'class'=>'form-control target_q_share excluded', 'style'=>'width:25%; float:left;', 'maxlength' => 4, 'placeholder'=>'Q1', 'required' => 'required']) !!}
        {!! Form::input('number', '', 25, ['id' => 'target_q2_share', 'class'=>'form-control target_q_share excluded', 'style'=>'width:25%; float:left;', 'maxlength' => 4, 'placeholder'=>'Q2', 'required' => 'required']) !!}
        {!! Form::input('number', '', 25, ['id' => 'target_q3_share', 'class'=>'form-control target_q_share excluded', 'style'=>'width:25%; float:left;', 'maxlength' => 4, 'placeholder'=>'Q3', 'required' => 'required']) !!}
        {!! Form::input('number', '', 25, ['id' => 'target_q4_share', 'class'=>'form-control target_q_share excluded', 'style'=>'width:25%; float:left;', 'maxlength' => 4, 'placeholder'=>'Q4', 'required' => 'required']) !!}
    </div>
</div>

