@php $quarters = isset($quarters) ? $quarters : [1, 2] @endphp
@php $quarterTargets = isset($quarterTargets) ? $quarterTargets : false @endphp

@foreach($quarters as $quarter)
    @php $id = 'target_q'.$quarter @endphp
    @php $name = $id @endphp
    @php $value = null @endphp

    @if ($quarterTargets && isset($quarterTargets[$quarter]))
            @php $quarterObj = $quarterTargets[$quarter] @endphp
            @php $name = 'target_q'.$quarterObj->id @endphp
            @php $value = number_format($quarterObj->target) @endphp
            @php $months = $quarterObj->children @endphp
            @php $months = $months->keyBy('month') @endphp
    @endif

    @php $label_id = 'label_target_q'.$quarter @endphp
    <div class="col-lg-12 list-header">
        <div class="col-md-3 list" id="{{ $label_id }}">Quarter {{ $quarter }}</div>
        <div class="col-md-6">
            {!! Form::text($name, $value, ['class'=>'form-control', 'onkeyup' => "this.value=AddCommasAndSplitTarget(this.value, 'quarterly', {$quarter}, 'check');", 'placeholder'=>'Target', 'id'=> $id, 'required' => 'required']) !!}
        </div>
        <div class="col-md-3 message"></div>
    </div>
    @for ($i = 1; $i <= 3; $i++)
        @php $month_no = ($quarter - 1) * 3 + $i @endphp
        @php $id = 'target_m'.$month_no @endphp
        @php $label_id = 'label_target_m'.$month_no @endphp
        @php $name = $id @endphp
        @php $value = null @endphp
        @if (isset($months) && isset($months[$month_no]))
            @php $monthsObj = $months[$month_no] @endphp
            @php $name = 'target_m'.$monthsObj->id @endphp
            @php $value = $monthsObj->target @endphp
        @endif
        <div class="col-lg-12 list-header">
            <div class="col-md-3 col-md-offset-1 list" id="{{ $label_id }}">Month {{ $month_no }}</div>
            <div class="col-md-5">
                {!! Form::text($name, $value, ['class'=>'form-control', 'onkeyup' => "this.value=AddCommasAndSplitTarget(this.value, 'monthly', {$quarter}, 'check');", 'placeholder'=>'Target', 'id'=> $id, 'required' => 'required']) !!}
            </div>
            <div class="col-md-3 message"></div>
        </div>
    @endfor
@endforeach